/*
 * Decompiled with CFR 0.152.
 */
package org.grails.launcher.rootloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.grails.launcher.context.GrailsLaunchContext;
import org.grails.launcher.rootloader.RootLoader;
import org.grails.launcher.util.ReflectionUtils;

public class RootLoaderFactory {
    public RootLoader create(GrailsLaunchContext context) throws MalformedURLException, ClassNotFoundException {
        return this.create(context, ClassLoader.getSystemClassLoader());
    }

    public RootLoader create(GrailsLaunchContext context, ClassLoader parentLoader) throws MalformedURLException {
        URL[] urls = RootLoaderFactory.generateBuildPath(context.getBuildDependencies());
        RootLoader rootLoader = new RootLoader(urls, parentLoader);
        ArrayList<File> loggingBootstrapJars = new ArrayList<File>();
        for (File file : context.getCompileDependencies()) {
            String name = file.getName();
            if (!name.contains("slf4j") && !name.contains("log4j") && !name.contains("spring-core")) continue;
            loggingBootstrapJars.add(file);
        }
        if (!loggingBootstrapJars.isEmpty()) {
            for (File loggingBootstrapJar : loggingBootstrapJars) {
                rootLoader.addURL(loggingBootstrapJar.toURI().toURL());
            }
            URL log4jFileUrl = this.getClass().getResource("log4j.properties");
            if (log4jFileUrl != null) {
                try {
                    Class<?> cls = rootLoader.loadClass("org.springframework.util.Log4jConfigurer");
                    ReflectionUtils.invokeStaticMethod(cls, "initLogging", new Object[]{log4jFileUrl.toExternalForm()});
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
        return rootLoader;
    }

    private static URL[] generateBuildPath(List<File> systemDependencies) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File systemDependency : systemDependencies) {
            try {
                urls.add(systemDependency.toURI().toURL());
            }
            catch (MalformedURLException e) {}
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

