/*
 * Decompiled with CFR 0.152.
 */
package org.grails.launcher.util;

import java.util.ArrayList;
import java.util.Iterator;

public class NameUtils {
    public static String toCommandName(String scriptName) {
        if (scriptName == null) {
            throw new IllegalArgumentException("'scriptName' cannot be null");
        }
        return NameUtils.toNaturalName(scriptName).replaceAll("\\s", "-").toLowerCase();
    }

    public static String toScriptName(String commandName) {
        if (commandName == null) {
            throw new IllegalArgumentException("'commandName' cannot be null");
        }
        if (commandName.trim().length() == 0) {
            throw new IllegalArgumentException("'commandName' cannot be blank");
        }
        if (commandName.indexOf(45) > -1) {
            String[] tokens;
            StringBuilder buf = new StringBuilder();
            for (String token : tokens = commandName.split("-")) {
                if (token == null || token.length() == 0) continue;
                buf.append(token.substring(0, 1).toUpperCase()).append(token.substring(1));
            }
            return buf.toString();
        }
        return commandName.substring(0, 1).toUpperCase() + commandName.substring(1);
    }

    private static String toNaturalName(String name) {
        ArrayList<String> words = new ArrayList<String>();
        int i = 0;
        char[] chars = name.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            String w;
            char c = chars[j];
            if (i >= words.size()) {
                w = "";
                words.add(i, w);
            } else {
                w = (String)words.get(i);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.length() == 0) {
                    c = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    w = "";
                    words.add(++i, w);
                }
                words.set(i, w + c);
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1))) {
                words.set(i, w + c);
                continue;
            }
            words.add(++i, String.valueOf(c));
        }
        StringBuilder buf = new StringBuilder();
        Iterator j = words.iterator();
        while (j.hasNext()) {
            String word = (String)j.next();
            buf.append(word);
            if (!j.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }
}

