/*
 * Decompiled with CFR 0.152.
 */
package org.grails.launcher.version;

import org.grails.launcher.version.GrailsVersion;

public class GrailsVersionParser {
    public GrailsVersion parse(String string) {
        String tag;
        int patch;
        int minor;
        int major;
        String[] components = string.split("\\.", 4);
        int n = major = components.length > 0 ? this.asInt(components[0]) : 0;
        if (this.containsTag(components[1])) {
            String[] parts = components[1].split("-", 2);
            minor = this.asInt(parts[0]);
            patch = 0;
            tag = parts[1];
        } else if (this.isTag(components[1])) {
            minor = 0;
            patch = 0;
            tag = components[1];
        } else {
            minor = this.asInt(components[1]);
            if (components.length > 2) {
                if (this.containsTag(components[2])) {
                    String[] parts = components[2].split("-", 2);
                    patch = this.asInt(parts[0]);
                    tag = parts[1];
                } else if (this.isTag(components[2])) {
                    patch = 0;
                    tag = components[2];
                } else {
                    patch = this.asInt(components[2]);
                    tag = components.length > 3 ? components[3] : null;
                }
            } else {
                patch = 0;
                tag = null;
            }
        }
        return new GrailsVersion(string, major, minor, patch, tag);
    }

    private int asInt(String value) throws NumberFormatException {
        return this.asInteger(value);
    }

    private Integer asInteger(String value) throws NumberFormatException {
        return Integer.valueOf(value);
    }

    private boolean isInteger(String value) {
        try {
            this.asInteger(value);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean isTag(String component) {
        return !component.matches("\\d+");
    }

    private boolean containsTag(String component) {
        return component.matches("\\d+-.*");
    }
}

