/*
 * Decompiled with CFR 0.152.
 */
package org.grails.maven.plugin.tools;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.grails.launcher.GrailsLauncher;
import org.grails.launcher.RootLoader;

public abstract class AbstractGrailsRuntime {
    protected ExecutionContext executionContext;

    public AbstractGrailsRuntime(ExecutionContext context) {
        this.executionContext = context;
    }

    public abstract void run() throws MojoExecutionException;

    public static GrailsLauncher createGrailsLauncher(ExecutionContext ec) {
        URL[] urls = AbstractGrailsRuntime.generateBuildPath(ec.getBuildDependencies());
        RootLoader rootLoader = new RootLoader(urls, ClassLoader.getSystemClassLoader());
        System.setProperty("grails.console.enable.terminal", "false");
        System.setProperty("grails.console.enable.interactive", "false");
        List<File> compileDependencies = ec.getCompileDependencies();
        try {
            AbstractGrailsRuntime.addLoggingJarsToRootLoader(rootLoader, compileDependencies);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        GrailsLauncher launcher = new GrailsLauncher((ClassLoader)rootLoader, null, ec.getBaseDir().getAbsolutePath());
        launcher.setPlainOutput(true);
        launcher.setDependenciesExternallyConfigured(true);
        launcher.setProvidedDependencies(ec.getProvidedDependencies());
        launcher.setCompileDependencies(compileDependencies);
        launcher.setTestDependencies(ec.getTestDependencies());
        launcher.setRuntimeDependencies(ec.getRuntimeDependencies());
        launcher.setGrailsWorkDir(ec.getGrailsWorkDir());
        launcher.setProjectWorkDir(ec.getProjectWorkDir());
        launcher.setClassesDir(ec.getClassesDir());
        launcher.setTestClassesDir(ec.getTestClassesDir());
        launcher.setResourcesDir(ec.getResourcesDir());
        launcher.setProjectPluginsDir(ec.getProjectPluginsDir());
        launcher.setBuildDependencies(ec.getBuildDependencies());
        return launcher;
    }

    public static void addLoggingJarsToRootLoader(RootLoader rootLoader, List<File> compileDependencies) throws MalformedURLException, ClassNotFoundException {
        ArrayList<File> loggingBootstrapJars = new ArrayList<File>();
        for (File file : compileDependencies) {
            String name = file.getName();
            if (!name.contains("slf4j") && !name.contains("log4j") && !name.contains("spring-core") && !name.contains("logback")) continue;
            loggingBootstrapJars.add(file);
        }
        if (!loggingBootstrapJars.isEmpty()) {
            for (File loggingBootstrapJar : loggingBootstrapJars) {
                rootLoader.addURL(loggingBootstrapJar.toURI().toURL());
            }
            Class cls = rootLoader.loadClass("org.springframework.util.Log4jConfigurer");
            try {
                AbstractGrailsRuntime.invokeStaticMethod(cls, "initLogging", new Object[]{"classpath:grails-maven/log4j.properties"});
            }
            catch (Throwable throwable) {}
        }
    }

    private static Object invokeStaticMethod(Class target, String name, Object[] args) {
        Class[] argTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argTypes[i] = args[i].getClass();
            ++i;
        }
        try {
            return target.getMethod(name, argTypes).invoke((Object)target, args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static void fatalError(Throwable e) {
        System.out.println();
        System.out.println("Fatal error forking Grails JVM: " + e.getMessage());
        e.printStackTrace(System.out);
        System.out.flush();
        System.exit(1);
    }

    protected static URL[] generateBuildPath(List<File> systemDependencies) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File systemDependency : systemDependencies) {
            try {
                urls.add(systemDependency.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static class ExecutionContext
    implements Serializable {
        private List<File> compileDependencies;
        private List<File> runtimeDependencies;
        private List<File> buildDependencies;
        private List<File> providedDependencies;
        private List<File> testDependencies;
        private List forkedVmArgs;
        private File grailsWorkDir;
        private File projectWorkDir;
        private File classesDir;
        private File testClassesDir;
        private File resourcesDir;
        private File projectPluginsDir;
        private File baseDir;
        private File dependencyFileLocation;
        private String scriptName;
        private String env;
        private String args;
        private String grailsBuildListener;

        public String getScriptName() {
            return this.scriptName;
        }

        public void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public String getEnv() {
            return this.env;
        }

        public void setEnv(String env) {
            this.env = env;
        }

        public String getArgs() {
            return this.args;
        }

        public void setArgs(String args) {
            this.args = args;
        }

        public List<String> getForkedVmArgs() {
            return this.forkedVmArgs;
        }

        public void setForkedVmArgs(List<String> forkedVmArgs) {
            this.forkedVmArgs = forkedVmArgs;
        }

        public File getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(File baseDir) {
            this.baseDir = baseDir;
        }

        public List<File> getCompileDependencies() {
            return this.compileDependencies;
        }

        public void setCompileDependencies(List<File> compileDependencies) {
            this.compileDependencies = compileDependencies;
        }

        public List<File> getRuntimeDependencies() {
            return this.runtimeDependencies;
        }

        public void setRuntimeDependencies(List<File> runtimeDependencies) {
            this.runtimeDependencies = runtimeDependencies;
        }

        public List<File> getBuildDependencies() {
            return this.buildDependencies;
        }

        public void setBuildDependencies(List<File> buildDependencies) {
            this.buildDependencies = buildDependencies;
        }

        public List<File> getProvidedDependencies() {
            return this.providedDependencies;
        }

        public void setProvidedDependencies(List<File> providedDependencies) {
            this.providedDependencies = providedDependencies;
        }

        public List<File> getTestDependencies() {
            return this.testDependencies;
        }

        public void setTestDependencies(List<File> testDependencies) {
            this.testDependencies = testDependencies;
        }

        public File getGrailsWorkDir() {
            return this.grailsWorkDir;
        }

        public void setGrailsWorkDir(File grailsWorkDir) {
            this.grailsWorkDir = grailsWorkDir;
        }

        public File getProjectWorkDir() {
            return this.projectWorkDir;
        }

        public void setProjectWorkDir(File projectWorkDir) {
            this.projectWorkDir = projectWorkDir;
        }

        public File getClassesDir() {
            return this.classesDir;
        }

        public void setClassesDir(File classesDir) {
            this.classesDir = classesDir;
        }

        public File getTestClassesDir() {
            return this.testClassesDir;
        }

        public void setTestClassesDir(File testClassesDir) {
            this.testClassesDir = testClassesDir;
        }

        public File getResourcesDir() {
            return this.resourcesDir;
        }

        public void setResourcesDir(File resourcesDir) {
            this.resourcesDir = resourcesDir;
        }

        public File getProjectPluginsDir() {
            return this.projectPluginsDir;
        }

        public void setProjectPluginsDir(File projectPluginsDir) {
            this.projectPluginsDir = projectPluginsDir;
        }

        public File getDependencyFileLocation() {
            return this.dependencyFileLocation;
        }

        public void setDependencyFileLocation(File dependencyFile) {
            this.dependencyFileLocation = dependencyFile;
        }

        public String getGrailsBuildListener() {
            return this.grailsBuildListener;
        }

        public void setGrailsBuildListener(String buildListener) {
            this.grailsBuildListener = buildListener;
        }
    }
}

