/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.web;

import grails.build.logging.GrailsConsole;
import grails.util.CollectionUtils;
import grails.validation.DefaultASTValidateableHelper;
import grails.web.Action;
import grails.web.RequestParameter;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.grails.compiler.injection.AstTransformer;
import org.codehaus.groovy.grails.compiler.injection.GrailsASTUtils;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.grails.compiler.web.ControllerTransformer;
import org.codehaus.groovy.grails.validation.Validateable;
import org.codehaus.groovy.grails.web.plugins.support.WebMetaUtils;
import org.codehaus.groovy.syntax.Token;
import org.springframework.validation.MapBindingResult;

@AstTransformer
public class ControllerActionTransformer
implements GrailsArtefactClassInjector {
    private static final ClassNode OBJECT_CLASS = new ClassNode(Object.class);
    private static final AnnotationNode ACTION_ANNOTATION_NODE = new AnnotationNode(new ClassNode(Action.class));
    private static final String ACTION_MEMBER_TARGET = "commandObjects";
    private static final VariableExpression THIS_EXPRESSION = new VariableExpression("this");
    private static final VariableExpression PARAMS_EXPRESSION = new VariableExpression("params");
    private static final TupleExpression EMPTY_TUPLE = new TupleExpression();
    private static final Map<ClassNode, String> TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME = CollectionUtils.newMap((Object[])new Object[]{ClassHelper.Integer_TYPE, "int", ClassHelper.Float_TYPE, "float", ClassHelper.Long_TYPE, "long", ClassHelper.Double_TYPE, "double", ClassHelper.Short_TYPE, "short", ClassHelper.Boolean_TYPE, "boolean", ClassHelper.Byte_TYPE, "byte", ClassHelper.Character_TYPE, "char"});
    private static List<ClassNode> PRIMITIVE_CLASS_NODES = CollectionUtils.newList((Object[])new ClassNode[]{ClassHelper.boolean_TYPE, ClassHelper.char_TYPE, ClassHelper.int_TYPE, ClassHelper.short_TYPE, ClassHelper.long_TYPE, ClassHelper.double_TYPE, ClassHelper.float_TYPE, ClassHelper.byte_TYPE});
    public static final String VOID_TYPE = "void";
    private Boolean converterEnabled = Boolean.parseBoolean(System.getProperty("grails.compile.artefacts.closures.convert"));

    public String[] getArtefactTypes() {
        return new String[]{"Controller"};
    }

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        this.annotateCandidateActionMethods(classNode, source);
        this.processClosures(classNode, source);
    }

    private void annotateCandidateActionMethods(ClassNode classNode, SourceUnit source) {
        ArrayList<MethodNode> deferredNewMethods = new ArrayList<MethodNode>();
        for (MethodNode method : classNode.getMethods()) {
            MethodNode wrapperMethod;
            if (method.isStatic() || !method.isPublic() || !method.getAnnotations(ACTION_ANNOTATION_NODE.getClassNode()).isEmpty() || method.getLineNumber() < 0 || method.getReturnType().getName().equals(VOID_TYPE)) continue;
            List declaredMethodsWithThisName = classNode.getDeclaredMethods(method.getName());
            if (declaredMethodsWithThisName != null && declaredMethodsWithThisName.size() > 1) {
                String message = "Controller actions may not be overloaded.  The [" + method.getName() + "] action has been overloaded in [" + classNode.getName() + "].";
                this.error(source, message);
            }
            if ((wrapperMethod = this.convertToMethodAction(classNode, method, source)) == null) continue;
            deferredNewMethods.add(wrapperMethod);
        }
        for (MethodNode newMethod : deferredNewMethods) {
            classNode.addMethod(newMethod);
        }
    }

    private MethodNode convertToMethodAction(ClassNode classNode, MethodNode _method, SourceUnit source) {
        Parameter[] parameters;
        ClassNode returnType = _method.getReturnType();
        for (Parameter param : parameters = _method.getParameters()) {
            if (!param.hasInitialExpression()) continue;
            String paramName = param.getName();
            String methodName = _method.getName();
            String initialValue = param.getInitialExpression().getText();
            String methodDeclaration = _method.getText();
            String message = "Parameter [%s] to method [%s] has default value [%s].  Default parameter values are not allowed in controller action methods. ([%s])";
            String formattedMessage = String.format(message, paramName, methodName, initialValue, methodDeclaration);
            this.error(source, formattedMessage);
        }
        MethodNode method = null;
        if (_method.getParameters().length > 0) {
            method = new MethodNode(_method.getName(), 1, returnType, ZERO_PARAMETERS, EMPTY_CLASS_ARRAY, this.addOriginalMethodCall(_method, this.initializeActionParameters(classNode, (ASTNode)_method, _method.getName(), parameters, source)));
            this.annotateActionMethod(parameters, method);
        } else {
            this.annotateActionMethod(parameters, _method);
        }
        return method;
    }

    private Statement addOriginalMethodCall(MethodNode _method, BlockStatement blockStatement) {
        if (blockStatement != null) {
            ArgumentListExpression arguments = new ArgumentListExpression();
            for (Parameter p : _method.getParameters()) {
                arguments.addExpression((Expression)new VariableExpression(p.getName(), p.getType()));
            }
            MethodCallExpression callExpression = new MethodCallExpression((Expression)THIS_EXPRESSION, _method.getName(), (Expression)arguments);
            callExpression.setMethodTarget(_method);
            blockStatement.addStatement((Statement)new ReturnStatement((Expression)callExpression));
        }
        return blockStatement;
    }

    private boolean isCommandObjectAction(Parameter[] params) {
        return params != null && params.length > 0 && params[0].getType() != new ClassNode(Object[].class) && params[0].getType() != new ClassNode(Object.class);
    }

    private void processClosures(ClassNode classNode, SourceUnit source) {
        ArrayList propertyNodes = new ArrayList(classNode.getProperties());
        for (PropertyNode property : propertyNodes) {
            Expression initialExpression = property.getInitialExpression();
            if (property.isStatic() || initialExpression == null || !initialExpression.getClass().equals(ClosureExpression.class)) continue;
            ClosureExpression closureAction = (ClosureExpression)initialExpression;
            if (this.converterEnabled.booleanValue()) {
                this.transformClosureToMethod(classNode, closureAction, property, source);
                continue;
            }
            this.addMethodToInvokeClosure(classNode, property, source);
        }
    }

    protected void addMethodToInvokeClosure(ClassNode controllerClassNode, PropertyNode closureProperty, SourceUnit source) {
        MethodNode method = controllerClassNode.getMethod(closureProperty.getName(), ZERO_PARAMETERS);
        if (method == null || !method.getDeclaringClass().equals((Object)controllerClassNode)) {
            ClosureExpression closureExpression = (ClosureExpression)closureProperty.getInitialExpression();
            Parameter[] parameters = closureExpression.getParameters();
            ArgumentListExpression closureInvocationArguments = new ArgumentListExpression();
            if (parameters != null) {
                for (Parameter p : parameters) {
                    closureInvocationArguments.addExpression((Expression)new VariableExpression(p.getName()));
                }
            }
            MethodCallExpression methodCallExpression = new MethodCallExpression((Expression)closureExpression, "call", (Expression)closureInvocationArguments);
            BlockStatement newMethodCode = this.initializeActionParameters(controllerClassNode, (ASTNode)closureProperty, closureProperty.getName(), parameters, source);
            newMethodCode.addStatement((Statement)new ExpressionStatement((Expression)methodCallExpression));
            MethodNode methodNode = new MethodNode(closureProperty.getName(), 1, new ClassNode(Object.class), ZERO_PARAMETERS, EMPTY_CLASS_ARRAY, (Statement)newMethodCode);
            this.annotateActionMethod(parameters, methodNode);
            controllerClassNode.addMethod(methodNode);
        }
    }

    protected void annotateActionMethod(Parameter[] parameters, MethodNode methodNode) {
        if (this.isCommandObjectAction(parameters)) {
            ListExpression initArray = new ListExpression();
            for (Parameter parameter : parameters) {
                initArray.addExpression((Expression)new ClassExpression(parameter.getType()));
            }
            AnnotationNode paramActionAnn = new AnnotationNode(new ClassNode(Action.class));
            paramActionAnn.setMember(ACTION_MEMBER_TARGET, (Expression)initArray);
            methodNode.addAnnotation(paramActionAnn);
        } else {
            methodNode.addAnnotation(ACTION_ANNOTATION_NODE);
        }
    }

    protected void transformClosureToMethod(ClassNode classNode, ClosureExpression closureAction, PropertyNode property, SourceUnit source) {
        MethodNode actionMethod = new MethodNode(property.getName(), 1, property.getType(), closureAction.getParameters(), EMPTY_CLASS_ARRAY, closureAction.getCode());
        MethodNode convertedMethod = this.convertToMethodAction(classNode, actionMethod, source);
        if (convertedMethod != null) {
            classNode.addMethod(convertedMethod);
        }
        classNode.getProperties().remove(property);
        classNode.getFields().remove(property.getField());
        classNode.addMethod(actionMethod);
    }

    protected BlockStatement initializeActionParameters(ClassNode classNode, ASTNode actionNode, String actionName, Parameter[] actionParameters, SourceUnit source) {
        BlockStatement wrapper = new BlockStatement();
        ArgumentListExpression mapBindingResultConstructorArgs = new ArgumentListExpression();
        mapBindingResultConstructorArgs.addExpression((Expression)new ConstructorCallExpression(new ClassNode(HashMap.class), (Expression)EMPTY_TUPLE));
        mapBindingResultConstructorArgs.addExpression((Expression)new ConstantExpression((Object)"controller"));
        ConstructorCallExpression mapBindingResultConstructorCallExpression = new ConstructorCallExpression(new ClassNode(MapBindingResult.class), (Expression)mapBindingResultConstructorArgs);
        BinaryExpression errorsAssignmentExpression = new BinaryExpression((Expression)new VariableExpression("errors"), Token.newSymbol((int)100, (int)0, (int)0), (Expression)mapBindingResultConstructorCallExpression);
        wrapper.addStatement((Statement)new ExpressionStatement((Expression)errorsAssignmentExpression));
        if (actionParameters != null) {
            for (Parameter param : actionParameters) {
                this.initializeMethodParameter(classNode, wrapper, actionNode, actionName, param, source);
            }
        }
        return wrapper;
    }

    protected void initializeMethodParameter(ClassNode classNode, BlockStatement wrapper, ASTNode actionNode, String actionName, Parameter param, SourceUnit source) {
        String paramName;
        ClassNode paramTypeClassNode = param.getType();
        String requestParameterName = paramName = param.getName();
        List requestParameters = param.getAnnotations(new ClassNode(RequestParameter.class));
        if (requestParameters.size() == 1) {
            requestParameterName = ((AnnotationNode)requestParameters.get(0)).getMember("value").getText();
        }
        if (PRIMITIVE_CLASS_NODES.contains(paramTypeClassNode) || TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.containsKey(paramTypeClassNode)) {
            this.initializePrimitiveOrTypeWrapperParameter(wrapper, param, requestParameterName);
        } else if (paramTypeClassNode.equals((Object)new ClassNode(String.class))) {
            this.initializeStringParameter(wrapper, param, requestParameterName);
        } else if (!paramTypeClassNode.equals((Object)OBJECT_CLASS)) {
            this.initializeCommandObjectParameter(wrapper, classNode, paramTypeClassNode, actionNode, actionName, paramName, source);
        }
    }

    protected void initializeCommandObjectParameter(BlockStatement wrapper, ClassNode classNode, ClassNode commandObjectTypeClassNode, ASTNode actionNode, String actionName, String paramName, SourceUnit source) {
        ModuleNode commandObjectModule;
        this.enhanceCommandObjectClass(commandObjectTypeClassNode, actionName, source);
        ConstructorCallExpression constructorCallExpression = new ConstructorCallExpression(commandObjectTypeClassNode, (Expression)EMPTY_TUPLE);
        ExpressionStatement newCommandCode = new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression(paramName, commandObjectTypeClassNode), Token.newSymbol((int)100, (int)0, (int)0), (Expression)constructorCallExpression));
        wrapper.addStatement((Statement)newCommandCode);
        Statement autoWireCommandObjectStatement = this.getAutoWireCommandObjectStatement(paramName);
        wrapper.addStatement(autoWireCommandObjectStatement);
        Statement statement = this.getCommandObjectDataBindingStatement(classNode, paramName, commandObjectTypeClassNode);
        wrapper.addStatement(statement);
        MethodCallExpression validateMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression(paramName), "validate", (Expression)EMPTY_TUPLE);
        MethodNode validateMethod = commandObjectTypeClassNode.getMethod("validate", new Parameter[0]);
        if (validateMethod != null) {
            validateMethodCallExpression.setMethodTarget(validateMethod);
        }
        wrapper.addStatement((Statement)new ExpressionStatement((Expression)validateMethodCallExpression));
        boolean argumentIsValidateable = GrailsASTUtils.hasAnyAnnotations((ClassNode)commandObjectTypeClassNode, (Class[])new Class[]{grails.validation.Validateable.class, Validateable.class, grails.persistence.Entity.class, Entity.class});
        if (!argumentIsValidateable && (commandObjectModule = commandObjectTypeClassNode.getModule()) != null && (commandObjectModule == classNode.getModule() || this.doesModulePathIncludeSubstring(commandObjectModule, "grails-app" + File.separator + "controllers" + File.separator) || this.doesModulePathIncludeSubstring(commandObjectModule, "grails-app" + File.separator + "domain" + File.separator))) {
            argumentIsValidateable = true;
        }
        if (!argumentIsValidateable) {
            String warningMessage = "The [" + actionName + "] action in [" + classNode.getName() + "] accepts a parameter of type [" + commandObjectTypeClassNode.getName() + "] which has not been marked with @grails.validation.Validateable. " + "This may lead to an intermittent MissingMethodException for validate(). " + "We strongly recommend that you mark command object classes with @Validateable " + "in order to avoid the problem.";
            this.warning(source, actionNode, warningMessage);
        }
    }

    protected void enhanceCommandObjectClass(ClassNode commandObjectTypeClassNode, String actionName, SourceUnit source) {
        List validateMethods;
        if (!commandObjectTypeClassNode.isPrimaryClassNode() && (validateMethods = commandObjectTypeClassNode.getMethods("validate")).size() == 0) {
            String errorMessage = "The [" + actionName + "] action accepts a parameter of type [" + commandObjectTypeClassNode.getName() + "] which does not appear to be a command object class.  " + "This can happen if the source code for this class is not in this " + "project and the class is not marked with @Validateable.";
            this.error(source, errorMessage);
        }
        DefaultASTValidateableHelper h = new DefaultASTValidateableHelper();
        h.injectValidateableCode(commandObjectTypeClassNode);
    }

    private boolean doesModulePathIncludeSubstring(ModuleNode moduleNode, String substring) {
        String commandObjectModuleDescription;
        boolean substringFoundInDescription = false;
        if (moduleNode != null && (commandObjectModuleDescription = moduleNode.getDescription()) != null) {
            substringFoundInDescription = commandObjectModuleDescription.contains(substring);
        }
        return substringFoundInDescription;
    }

    protected Statement getCommandObjectDataBindingStatement(ClassNode controllerClassNode, String paramName, ClassNode commandObjectClassNode) {
        BlockStatement bindingStatement = new BlockStatement();
        ArgumentListExpression getCommandObjectBindingParamsArgs = new ArgumentListExpression();
        getCommandObjectBindingParamsArgs.addExpression((Expression)new MethodCallExpression((Expression)new VariableExpression(paramName), "getClass", (Expression)ZERO_ARGS));
        getCommandObjectBindingParamsArgs.addExpression((Expression)PARAMS_EXPRESSION);
        StaticMethodCallExpression invokeGetCommandObjectBindingParamsExpression = new StaticMethodCallExpression(new ClassNode(WebMetaUtils.class), "getCommandObjectBindingParams", (Expression)getCommandObjectBindingParamsArgs);
        ExpressionStatement intializeCommandObjectParams = new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression("commandObjectParams", new ClassNode(Map.class)), Token.newSymbol((int)100, (int)0, (int)0), (Expression)invokeGetCommandObjectBindingParamsExpression));
        bindingStatement.addStatement((Statement)intializeCommandObjectParams);
        ArgumentListExpression arguments = new ArgumentListExpression();
        arguments.addExpression((Expression)new VariableExpression(paramName));
        arguments.addExpression((Expression)new VariableExpression((Variable)new VariableExpression("commandObjectParams")));
        MethodCallExpression bindDataMethodCallExpression = new MethodCallExpression((Expression)THIS_EXPRESSION, "bindData", (Expression)arguments);
        bindingStatement.addStatement((Statement)new ExpressionStatement((Expression)bindDataMethodCallExpression));
        return bindingStatement;
    }

    protected Statement getAutoWireCommandObjectStatement(String paramName) {
        ArgumentListExpression autowireBeanPropertiesArgs = new ArgumentListExpression();
        autowireBeanPropertiesArgs.addExpression((Expression)new VariableExpression(paramName));
        autowireBeanPropertiesArgs.addExpression((Expression)new ConstantExpression((Object)1));
        autowireBeanPropertiesArgs.addExpression((Expression)new ConstantExpression((Object)false));
        VariableExpression applicatonContextVariable = new VariableExpression("applicationContext");
        PropertyExpression autowireCapableBeanFactoryProperty = new PropertyExpression((Expression)applicatonContextVariable, "autowireCapableBeanFactory");
        MethodCallExpression invokeAutowireBeanPropertiesMethodExpression = new MethodCallExpression((Expression)autowireCapableBeanFactoryProperty, "autowireBeanProperties", (Expression)autowireBeanPropertiesArgs);
        return new ExpressionStatement((Expression)invokeAutowireBeanPropertiesMethodExpression);
    }

    protected void initializeStringParameter(BlockStatement wrapper, Parameter param, String requestParameterName) {
        ClassNode paramTypeClassNode = param.getType();
        String methodParamName = param.getName();
        ArgumentListExpression paramsGetMethodArguments = new ArgumentListExpression((Expression)new ConstantExpression((Object)requestParameterName));
        MethodCallExpression getValueExpression = new MethodCallExpression((Expression)PARAMS_EXPRESSION, "get", (Expression)paramsGetMethodArguments);
        ArgumentListExpression paramsContainsKeyMethodArguments = new ArgumentListExpression((Expression)new ConstantExpression((Object)requestParameterName));
        BooleanExpression containsKeyExpression = new BooleanExpression((Expression)new MethodCallExpression((Expression)PARAMS_EXPRESSION, "containsKey", (Expression)paramsContainsKeyMethodArguments));
        ExpressionStatement initializeParameterStatement = new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression(methodParamName, paramTypeClassNode), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new TernaryExpression(containsKeyExpression, (Expression)getValueExpression, (Expression)new ConstantExpression(null))));
        wrapper.addStatement((Statement)initializeParameterStatement);
    }

    protected void initializePrimitiveOrTypeWrapperParameter(BlockStatement wrapper, Parameter param, String requestParameterName) {
        ClassNode paramTypeClassNode = param.getType();
        String methodParamName = param.getName();
        ConstantExpression defaultValueExpression = paramTypeClassNode.equals((Object)ClassHelper.Boolean_TYPE) ? new ConstantExpression((Object)false) : (PRIMITIVE_CLASS_NODES.contains(paramTypeClassNode) ? new ConstantExpression((Object)0) : new ConstantExpression(null));
        ConstantExpression paramConstantExpression = new ConstantExpression((Object)requestParameterName);
        ArgumentListExpression paramsTypeConversionMethodArguments = new ArgumentListExpression((Expression)paramConstantExpression, (Expression)new ConstantExpression(null));
        String conversionMethodName = TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.containsKey(paramTypeClassNode) ? TYPE_WRAPPER_CLASS_TO_CONVERSION_METHOD_NAME.get(paramTypeClassNode) : paramTypeClassNode.getName();
        MethodCallExpression retrieveConvertedValueExpression = new MethodCallExpression((Expression)PARAMS_EXPRESSION, conversionMethodName, (Expression)paramsTypeConversionMethodArguments);
        ArgumentListExpression paramsContainsKeyMethodArguments = new ArgumentListExpression((Expression)paramConstantExpression);
        BooleanExpression containsKeyExpression = new BooleanExpression((Expression)new MethodCallExpression((Expression)PARAMS_EXPRESSION, "containsKey", (Expression)paramsContainsKeyMethodArguments));
        Token equalsToken = Token.newSymbol((int)100, (int)0, (int)0);
        VariableExpression convertedValueExpression = new VariableExpression("___converted_" + methodParamName, new ClassNode(Object.class));
        DeclarationExpression declareConvertedValueExpression = new DeclarationExpression(convertedValueExpression, equalsToken, (Expression)new EmptyExpression());
        ExpressionStatement declareVariableStatement = new ExpressionStatement((Expression)declareConvertedValueExpression);
        wrapper.addStatement((Statement)declareVariableStatement);
        VariableExpression methodParamExpression = new VariableExpression(methodParamName, paramTypeClassNode);
        DeclarationExpression declareParameterVariableStatement = new DeclarationExpression(methodParamExpression, equalsToken, (Expression)new EmptyExpression());
        declareVariableStatement = new ExpressionStatement((Expression)declareParameterVariableStatement);
        wrapper.addStatement((Statement)declareVariableStatement);
        BinaryExpression assignmentExpression = new BinaryExpression((Expression)convertedValueExpression, equalsToken, (Expression)new TernaryExpression(containsKeyExpression, (Expression)retrieveConvertedValueExpression, (Expression)defaultValueExpression));
        wrapper.addStatement((Statement)new ExpressionStatement((Expression)assignmentExpression));
        Expression rejectValueMethodCallExpression = this.getRejectValueExpression(methodParamName);
        BlockStatement ifConvertedValueIsNullBlockStatement = new BlockStatement();
        ifConvertedValueIsNullBlockStatement.addStatement((Statement)new ExpressionStatement(rejectValueMethodCallExpression));
        ifConvertedValueIsNullBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)methodParamExpression, equalsToken, (Expression)defaultValueExpression)));
        BooleanExpression isConvertedValueNullExpression = new BooleanExpression((Expression)new BinaryExpression((Expression)convertedValueExpression, Token.newSymbol((int)123, (int)0, (int)0), (Expression)new ConstantExpression(null)));
        ExpressionStatement assignConvertedValueToParamStatement = new ExpressionStatement((Expression)new BinaryExpression((Expression)methodParamExpression, equalsToken, (Expression)convertedValueExpression));
        IfStatement ifStatement = new IfStatement(isConvertedValueNullExpression, (Statement)ifConvertedValueIsNullBlockStatement, (Statement)assignConvertedValueToParamStatement);
        wrapper.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)containsKeyExpression), (Statement)ifStatement, (Statement)new ExpressionStatement((Expression)new EmptyExpression())));
    }

    protected Expression getRejectValueExpression(String methodParamName) {
        ArgumentListExpression rejectValueArgs = new ArgumentListExpression();
        rejectValueArgs.addExpression((Expression)new ConstantExpression((Object)methodParamName));
        rejectValueArgs.addExpression((Expression)new ConstantExpression((Object)("params." + methodParamName + ".conversion.error")));
        MethodCallExpression rejectValueMethodCallExpression = new MethodCallExpression((Expression)new VariableExpression("errors"), "rejectValue", (Expression)rejectValueArgs);
        return rejectValueMethodCallExpression;
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    public boolean shouldInject(URL url) {
        return url != null && ControllerTransformer.CONTROLLER_PATTERN.matcher(url.getFile()).find();
    }

    protected void error(SourceUnit source, String me) {
        source.getErrorCollector().addError((Message)new SimpleMessage(me, (ProcessingUnit)source), true);
    }

    protected void warning(SourceUnit sourceUnit, ASTNode node, String warningMessage) {
        String sample = sourceUnit.getSample(node.getLineNumber(), node.getColumnNumber(), new Janitor());
        GrailsConsole.getInstance().warning(warningMessage + "\n\n" + sample);
    }
}

