/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.springframework.beans.BeanUtils;

public class GenericJavaBeanMarshaller
implements ObjectMarshaller<XML> {
    @Override
    public boolean supports(Object object) {
        return true;
    }

    @Override
    public void marshalObject(Object o, XML xml) throws ConverterException {
        try {
            for (PropertyDescriptor property : BeanUtils.getPropertyDescriptors(o.getClass())) {
                String name = property.getName();
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                Object value = readMethod.invoke(o, (Object[])null);
                xml.startNode(name);
                xml.convertAnother(value);
                xml.end();
            }
            for (Field field : o.getClass().getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!field.isAccessible() || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                xml.startNode(field.getName());
                xml.convertAnother(field.get(o));
                xml.end();
            }
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + o.getClass().getName(), e);
        }
    }
}

