/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codehaus.groovy.grails.compiler.validation;

import grails.validation.DefaultASTValidateableHelper;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase = CompilePhase.CANONICALIZATION)
public class ValidateableTransformation implements ASTTransformation{

    private static final ClassNode ORIGINAL_VALIDATEABLE_CLASS_NODE = new ClassNode(org.codehaus.groovy.grails.validation.Validateable.class);
    private static final ClassNode NEW_VALIDATEABLE_CLASS_NODE = new ClassNode(grails.validation.Validateable.class);

    public void visit(ASTNode[] astNodes, SourceUnit source) {
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }

        AnnotatedNode parent = (AnnotatedNode) astNodes[1];
        AnnotationNode node = (AnnotationNode) astNodes[0];
        if ( (!NEW_VALIDATEABLE_CLASS_NODE.equals(node.getClassNode()) && !ORIGINAL_VALIDATEABLE_CLASS_NODE.equals(node.getClassNode())) || !(parent instanceof ClassNode)) {
            return;
        }

        ClassNode cNode = (ClassNode) parent;
        String cName = cNode.getName();
        if (cNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cName + "'.  @Validateable not allowed for interfaces.");
        }

        // GRAILS-11416 - Allow override of default nullability
        boolean defaultNullable = false;
        Expression nullable = node.getMember("nullable");
        if (nullable != null) {
            defaultNullable = Boolean.parseBoolean(nullable.getText());
        }

        new DefaultASTValidateableHelper().injectValidateableCode(cNode, defaultNullable);
    }
}
