/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons.spring;

import grails.util.Environment;
import groovy.lang.GroovyObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.compiler.GrailsClassLoader;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

public class ReloadAwareAutowireCapableBeanFactory
extends DefaultListableBeanFactory {
    ConcurrentHashMap<Class<?>, Set<String>> autowiringByNameCacheForClass = new ConcurrentHashMap();
    ThreadLocal<Boolean> autowiringBeanPropertiesFlag = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public ReloadAwareAutowireCapableBeanFactory() {
        if (Environment.getCurrent().isReloadEnabled()) {
            this.setInstantiationStrategy((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(){

                public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
                    if (beanDefinition.getMethodOverrides().isEmpty()) {
                        Constructor constructorToUse;
                        Class clazz = beanDefinition.getBeanClass();
                        if (clazz.isInterface()) {
                            throw new BeanInstantiationException(clazz, "Specified class is an interface");
                        }
                        try {
                            constructorToUse = clazz.getDeclaredConstructor(null);
                        }
                        catch (Exception ex) {
                            throw new BeanInstantiationException(clazz, "No default constructor found", (Throwable)ex);
                        }
                        return BeanUtils.instantiateClass(constructorToUse, (Object[])new Object[0]);
                    }
                    return this.instantiateWithMethodInjection(beanDefinition, beanName, owner);
                }
            });
        }
        this.setParameterNameDiscoverer((ParameterNameDiscoverer)new LocalVariableTableParameterNameDiscoverer());
        this.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
    }

    protected Object doCreateBean(String beanName, RootBeanDefinition mbd, Object[] args) {
        if (Environment.getCurrent().isReloadEnabled()) {
            try {
                return super.doCreateBean(beanName, mbd, args);
            }
            catch (BeanCreationException t) {
                GrailsApplication application;
                ClassLoader classLoader;
                Class beanClass;
                if (t.getCause() instanceof TypeMismatchException && GroovyObject.class.isAssignableFrom(beanClass = mbd.getBeanClass()) && (classLoader = (application = (GrailsApplication)this.getBean("grailsApplication")).getClassLoader()) instanceof GrailsClassLoader) {
                    GrailsClassLoader gcl = (GrailsClassLoader)classLoader;
                    gcl.reloadClass(beanClass.getName());
                    try {
                        Class newBeanClass = gcl.loadClass(beanClass.getName());
                        mbd.setBeanClass(newBeanClass);
                        if (!newBeanClass.equals(beanClass)) {
                            GrailsPluginManager pluginManager = (GrailsPluginManager)this.getBean("pluginManager");
                            pluginManager.informOfClassChange(newBeanClass);
                            return super.doCreateBean(beanName, mbd, args);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw t;
                    }
                }
                throw t;
            }
        }
        return super.doCreateBean(beanName, mbd, args);
    }

    protected boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        return super.isExcludedFromDependencyCheck(pd) || pd.getName().indexOf(36) > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode != 1) {
            super.autowireBeanProperties(existingBean, autowireMode, dependencyCheck);
            return;
        }
        try {
            Set<String> beanProps;
            this.autowiringBeanPropertiesFlag.set(Boolean.TRUE);
            if (!Environment.getCurrent().isReloadEnabled() && (beanProps = this.autowiringByNameCacheForClass.get(ClassUtils.getUserClass(existingBean.getClass()))) != null && beanProps.isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Nothing to autowire for bean of class " + existingBean.getClass().getName()));
                }
                return;
            }
            super.autowireBeanProperties(existingBean, autowireMode, dependencyCheck);
        }
        finally {
            this.autowiringBeanPropertiesFlag.remove();
        }
    }

    protected void autowireByName(String beanName, AbstractBeanDefinition mbd, BeanWrapper bw, MutablePropertyValues pvs) {
        if (!this.autowiringBeanPropertiesFlag.get().booleanValue() || Environment.getCurrent().isReloadEnabled()) {
            super.autowireByName(beanName, mbd, bw, pvs);
            return;
        }
        Set<String> beanProps = this.autowiringByNameCacheForClass.get(ClassUtils.getUserClass(bw.getWrappedInstance().getClass()));
        if (beanProps == null) {
            String[] propertyNames;
            beanProps = new LinkedHashSet<String>();
            for (String propertyName : propertyNames = this.unsatisfiedNonSimpleProperties(mbd, bw)) {
                if (!this.containsBean(propertyName)) continue;
                beanProps.add(propertyName);
            }
            this.autowiringByNameCacheForClass.put(ClassUtils.getUserClass(bw.getWrappedInstance().getClass()), beanProps);
        }
        for (String propertyName : beanProps) {
            Object bean = this.getBean(propertyName);
            pvs.addPropertyValue(propertyName, bean);
            this.registerDependentBean(propertyName, beanName);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
        }
    }
}

