/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.test.runner.phase;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import grails.util.Environment;
import grails.util.Holders;
import groovy.lang.Binding;
import groovy.lang.MetaClass;
import groovy.util.ConfigObject;
import java.net.URL;
import java.util.Map;
import org.codehaus.groovy.grails.cli.support.MetaClassRegistryCleaner;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.spring.GrailsWebApplicationContext;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.project.container.GrailsProjectRunner;
import org.codehaus.groovy.grails.project.packaging.GrailsProjectPackager;
import org.codehaus.groovy.grails.project.plugins.GrailsProjectPluginLoader;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptorExecutor;
import org.codehaus.groovy.grails.test.runner.phase.DefaultTestPhaseConfigurer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.context.ApplicationContext;

public class FunctionalTestPhaseConfigurer
extends DefaultTestPhaseConfigurer {
    private boolean https;
    private boolean warMode;
    private String baseUrl;
    private boolean httpsBaseUrl;
    private GrailsProjectRunner projectRunner;
    private BuildSettings buildSettings;
    private boolean isForkedRun;
    private boolean existingServer;
    private String functionalBaseUrl;
    protected MetaClassRegistryCleaner registryCleaner;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    /*
     * WARNING - void declaration
     */
    public FunctionalTestPhaseConfigurer(GrailsProjectRunner grailsProjectRunner) {
        BuildSettings buildSettings;
        void projectRunner;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var3_3 = projectRunner;
        this.projectRunner = var3_3;
        this.buildSettings = buildSettings = ((GrailsProjectRunner)projectRunner).getBuildSettings();
        Object v = this.buildSettings.getForkSettings().get("run");
        this.isForkedRun = DefaultTypeTransformation.booleanUnbox(v);
    }

    @Override
    public void prepare(Binding testExecutionContext, Map<String, Object> testOptions) {
        MetaClassRegistryCleaner metaClassRegistryCleaner;
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object var3_3 = null;
        Holders.setPluginManager((GrailsPluginManager)((GrailsPluginManager)ScriptBytecodeAdapter.castToType(var3_3, GrailsPluginManager.class)));
        Object var4_4 = null;
        Holders.setGrailsApplication((GrailsApplication)((GrailsApplication)ScriptBytecodeAdapter.castToType(var4_4, GrailsApplication.class)));
        this.https = bl3 = DefaultTypeTransformation.booleanUnbox((Object)testOptions.get("https"));
        this.warMode = bl2 = DefaultTypeTransformation.booleanUnbox((Object)testOptions.get("war"));
        Object object = testOptions.get("baseUrl");
        this.baseUrl = ShortTypeHandling.castToString((Object)object);
        this.httpsBaseUrl = bl = DefaultTypeTransformation.booleanUnbox((Object)testOptions.get("httpsBaseUrl"));
        GrailsProjectPackager packager = this.projectRunner.getProjectPackager();
        packager.packageApplication();
        boolean isServerRunning = this.projectRunner.isServerRunning();
        if (!isServerRunning) {
            GrailsProjectPluginLoader grailsProjectPluginLoader = new GrailsProjectPluginLoader(null, packager.getClassLoader(), packager.getBuildSettings(), this.projectRunner.getBuildEventListener());
            GrailsPluginManager pluginManager = grailsProjectPluginLoader.loadPlugins();
            testExecutionContext.setVariable("pluginManager", (Object)pluginManager);
            packager.getBuildEventListener().getBinding().setVariable("pluginManager", (Object)pluginManager);
            packager.generateWebXml(pluginManager);
        }
        this.registryCleaner = metaClassRegistryCleaner = MetaClassRegistryCleaner.createAndRegister();
        if (!isServerRunning) {
            packager.createConfig();
            if (this.warMode) {
                if (!Environment.isFork()) {
                    this.projectRunner.getWarCreator().packageWar();
                }
                if (this.https) {
                    this.projectRunner.runWarHttps();
                } else {
                    this.projectRunner.runWar();
                }
                this.initFunctionalBaseUrl();
            } else {
                ConfigObject config = this.projectRunner.getProjectPackager().packageApplication();
                testExecutionContext.setVariable("config", (Object)config);
                if (this.https) {
                    this.projectRunner.runAppHttps();
                } else {
                    this.projectRunner.runApp();
                }
                this.initFunctionalBaseUrl();
                if (!this.isForkedRun) {
                    FunctionalTestPhaseConfigurer.initPersistenceContext();
                } else {
                    this.waitForServer();
                }
            }
        } else {
            boolean bl4;
            this.existingServer = bl4 = true;
            this.initFunctionalBaseUrl();
        }
    }

    private void waitForServer() {
        GrailsConsole console = GrailsConsole.getInstance();
        console.updateStatus("Waiting for server availability");
        int maxWait = 10000;
        int timeout = 0;
        while (timeout <= maxWait) {
            ResourceGroovyMethods.getText((URL)new URL(this.functionalBaseUrl), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"connectTimeout", 1000, "readTimeout", 1000}), (String)"UTF-8");
            try {
                break;
            }
            catch (Throwable ignored) {
                console.indicateProgress();
                int cfr_ignored_0 = timeout + 1000;
                DefaultGroovyStaticMethods.sleep(null, (long)1000);
            }
        }
    }

    @Override
    public void cleanup(Binding testExecutionContext, Map<String, Object> testOptions) {
        if (!this.warMode && !this.isForkedRun) {
            FunctionalTestPhaseConfigurer.destroyPersistenceContext();
        }
        if (!this.existingServer) {
            this.projectRunner.stopServer();
        }
        this.clearFunctionalBaseUrl();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.registryCleaner)) {
            MetaClassRegistryCleaner.cleanAndRemove((MetaClassRegistryCleaner)this.registryCleaner);
        }
    }

    private void initFunctionalBaseUrl() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.baseUrl)) {
            String string;
            this.functionalBaseUrl = string = this.baseUrl;
        } else {
            String string;
            String string2;
            this.functionalBaseUrl = string2 = this.httpsBaseUrl ? this.projectRunner.getUrlHttps() : this.projectRunner.getUrl();
            this.functionalBaseUrl = string = StringGroovyMethods.plus((String)this.functionalBaseUrl, (CharSequence)"/");
        }
        System.setProperty(BuildSettings.FUNCTIONAL_BASE_URL_PROPERTY, this.functionalBaseUrl);
    }

    private void clearFunctionalBaseUrl() {
        Object var1_1 = null;
        this.functionalBaseUrl = ShortTypeHandling.castToString(var1_1);
        System.setProperty(BuildSettings.FUNCTIONAL_BASE_URL_PROPERTY, "");
    }

    private static void initPersistenceContext() {
        try {
            ApplicationContext appCtx = Holders.getApplicationContext();
            PersistenceContextInterceptorExecutor.initPersistenceContext((ApplicationContext)appCtx);
        }
        catch (IllegalStateException ignored) {
        }
        catch (IllegalArgumentException ignored) {
        }
    }

    private static void destroyPersistenceContext() {
        GrailsWebApplicationContext appCtx = null;
        try {
            GrailsWebApplicationContext grailsWebApplicationContext;
            appCtx = grailsWebApplicationContext = (GrailsWebApplicationContext)ScriptBytecodeAdapter.castToType((Object)Holders.getApplicationContext(), GrailsWebApplicationContext.class);
        }
        catch (IllegalStateException ignored) {
        }
        catch (IllegalArgumentException ignored) {
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)appCtx)) {
            Object v0;
            PersistenceContextInterceptorExecutor.destroyPersistenceContext((ApplicationContext)appCtx);
            GrailsWebApplicationContext grailsWebApplicationContext = appCtx;
            if (grailsWebApplicationContext != null) {
                grailsWebApplicationContext.close();
                v0 = null;
            } else {
                v0 = null;
            }
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FunctionalTestPhaseConfigurer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public boolean getHttps() {
        return this.https;
    }

    public boolean isHttps() {
        return this.https;
    }

    public void setHttps(boolean bl) {
        this.https = bl;
    }

    public boolean getWarMode() {
        return this.warMode;
    }

    public boolean isWarMode() {
        return this.warMode;
    }

    public void setWarMode(boolean bl) {
        this.warMode = bl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public boolean getHttpsBaseUrl() {
        return this.httpsBaseUrl;
    }

    public boolean isHttpsBaseUrl() {
        return this.httpsBaseUrl;
    }

    public void setHttpsBaseUrl(boolean bl) {
        this.httpsBaseUrl = bl;
    }

    public GrailsProjectRunner getProjectRunner() {
        return this.projectRunner;
    }

    public void setProjectRunner(GrailsProjectRunner grailsProjectRunner) {
        this.projectRunner = grailsProjectRunner;
    }

    public String getFunctionalBaseUrl() {
        return this.functionalBaseUrl;
    }

    public void setFunctionalBaseUrl(String string) {
        this.functionalBaseUrl = string;
    }
}

