/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet.view;

import groovy.text.Template;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.util.WebUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public abstract class AbstractGrailsView
extends AbstractUrlBasedView {
    protected final void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        this.renderWithinGrailsWebRequest(model, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderWithinGrailsWebRequest(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        boolean attributesChanged = false;
        try {
            GrailsWebRequest webRequest;
            if (!(requestAttributes instanceof GrailsWebRequest)) {
                webRequest = this.createGrailsWebRequest(request, response, request.getServletContext());
                attributesChanged = true;
                WebUtils.storeGrailsWebRequest(webRequest);
            } else {
                webRequest = (GrailsWebRequest)requestAttributes;
            }
            this.renderTemplate(model, webRequest, request, response);
        }
        finally {
            if (attributesChanged) {
                request.removeAttribute("org.grails.WEB_REQUEST");
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
            }
        }
    }

    protected abstract void renderTemplate(Map<String, Object> var1, GrailsWebRequest var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected GrailsWebRequest createGrailsWebRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        return new GrailsWebRequest(request, response, servletContext);
    }

    public void rethrowRenderException(Throwable ex, String message) {
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex, message);
    }

    public abstract Template getTemplate();
}

