/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.taglib;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsStringUtils;
import org.codehaus.groovy.grails.web.pages.GroovyPageParser;
import org.codehaus.groovy.grails.web.taglib.GrailsTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;
import org.springframework.util.Assert;

public abstract class GroovySyntaxTag
implements GrailsTag {
    private static final String ERROR_NO_VAR_WITH_STATUS = "When using <g:each> with a [status] attribute, you must also define a [var]. eg. <g:each var=\"myVar\">";
    protected static final String ATTRIBUTE_IN = "in";
    protected static final String ATTRIBUTE_VAR = "var";
    protected static final String ATTRIBUTES_STATUS = "status";
    protected Map tagContext;
    protected PrintWriter out;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected GroovyPageParser parser;
    protected String foreachRenamedIt;

    @Override
    public void init(Map context) {
        this.tagContext = context;
        this.parser = (GroovyPageParser)context.get(GroovyPageParser.class);
        Object outObj = context.get("out");
        if (outObj instanceof PrintWriter) {
            this.out = (PrintWriter)context.get("out");
        }
    }

    @Override
    public void setWriter(Writer w) {
        Assert.isInstanceOf(PrintWriter.class, (Object)w, (String)"A GroovySynax tag requires a java.io.PrintWriter instance");
        this.out = (PrintWriter)w;
    }

    @Override
    public void setAttributes(Map attributes) {
        for (String attrName : attributes.keySet()) {
            this.setAttribute(attrName, attributes.get(attrName));
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        Assert.isInstanceOf(String.class, (Object)value, (String)"A GroovySyntax tag requires only string valued attributes");
        this.attributes.put(name.substring(1, name.length() - 1), (String)value);
    }

    public abstract boolean isKeepPrecedingWhiteSpace();

    public abstract boolean isAllowPrecedingContent();

    protected String calculateExpression(String expr) {
        Assert.isTrue((!GrailsStringUtils.isBlank((String)expr) ? 1 : 0) != 0, (String)"Argument [expr] cannot be null or blank");
        expr = expr.trim();
        if (expr.startsWith("\"") && expr.endsWith("\"") || expr.startsWith("'") && expr.endsWith("'")) {
            expr = expr.substring(1, expr.length() - 1);
            expr = expr.trim();
        }
        if (expr.startsWith("${") && expr.endsWith("}")) {
            expr = expr.substring(2, expr.length() - 1);
            expr = expr.trim();
        }
        return expr;
    }

    protected void doEachMethod(String in) {
        boolean hasVar;
        String var = this.attributes.get(ATTRIBUTE_VAR);
        String status = this.attributes.get(ATTRIBUTES_STATUS);
        var = this.extractAttributeValue(var);
        boolean hasStatus = !GrailsStringUtils.isBlank((String)(status = this.extractAttributeValue(status)));
        boolean bl = hasVar = !GrailsStringUtils.isBlank((String)var);
        if (hasStatus && !hasVar) {
            throw new GrailsTagException(ERROR_NO_VAR_WITH_STATUS, this.parser.getPageName(), this.parser.getCurrentOutputLineNumber());
        }
        if (var.equals(status) && hasStatus) {
            throw new GrailsTagException("Attribute [var] cannot have the same value as attribute [status]", this.parser.getPageName(), this.parser.getCurrentOutputLineNumber());
        }
        if (hasStatus) {
            this.out.println("loop:{");
            this.out.println("int " + status + " = 0");
        }
        if (!hasVar) {
            this.foreachRenamedIt = var = "_it" + Math.abs(System.identityHashCode(this));
        }
        String[] entryVars = null;
        if (hasVar && var.indexOf(44) > -1) {
            entryVars = var.split("\\s*,\\s*");
            var = "_entry" + Math.abs(System.identityHashCode(this));
        }
        this.out.print("for( " + var);
        this.out.print(" in ");
        this.out.print(this.parser != null ? this.parser.getExpressionText(in, false) : this.extractAttributeValue(in));
        this.out.print(" )");
        this.out.print(" {");
        this.out.println();
        if (!hasVar) {
            this.out.println("changeItVariable(" + this.foreachRenamedIt + ")");
        } else if (entryVars != null) {
            this.out.println("def " + entryVars[0].trim() + "=" + var + ".getKey()");
            this.out.println("def " + entryVars[1].trim() + "=" + var + ".getValue()");
        }
    }

    protected void endEachMethod() {
        boolean hasStatus;
        String status = this.attributes.get(ATTRIBUTES_STATUS);
        boolean bl = hasStatus = !GrailsStringUtils.isBlank((String)(status = this.extractAttributeValue(status)));
        if (hasStatus) {
            this.out.println(status + "++");
            this.out.println("}");
        }
        this.out.println("}");
    }

    private String extractAttributeValue(String attr) {
        if (GrailsStringUtils.isBlank((String)attr)) {
            return "";
        }
        if ((attr.startsWith("\"") && attr.endsWith("\"") || attr.startsWith("'") && attr.endsWith("'")) && attr.length() > 1) {
            attr = attr.substring(1, attr.length() - 1);
        }
        if (attr.endsWith("?") && attr.length() > 1) {
            attr = attr.substring(0, attr.length() - 1);
        }
        return attr;
    }

    public String getForeachRenamedIt() {
        return this.foreachRenamedIt;
    }
}

