/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import grails.util.Pair;
import grails.web.Action;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaProperty;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.web.servlet.mvc.AbstractGrailsControllerHelper;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.util.ReflectionUtils;

public class MixedGrailsControllerHelper
extends AbstractGrailsControllerHelper {
    private static final Class<?>[] NOARGS = new Class[0];
    private static final Logger log = LoggerFactory.getLogger(MixedGrailsControllerHelper.class);
    Map<Pair<Class<?>, String>, Method> controllerToActionMethodCache = new ConcurrentHashMap();
    private static final Method NULL_METHOD_HOLDER = ReflectionUtils.findMethod(Object.class, (String)"toString");
    Map<Pair<Class<?>, String>, MetaProperty> controllerToMetaPropertyCache = new ConcurrentHashMap();
    private static final MetaProperty NULL_META_PROPERTY_HOLDER = new MetaProperty("null", Void.class){

        public void setProperty(Object object, Object newValue) {
        }

        public Object getProperty(Object object) {
            return null;
        }
    };

    @Override
    protected Object retrieveAction(GroovyObject controller, String actionName, HttpServletResponse response) {
        Class controllerClass;
        if (controller == null || actionName == null) {
            return this.sendNotFoundError(response);
        }
        Pair key = new Pair(controller.getClass(), (Object)actionName);
        Method mAction = this.controllerToActionMethodCache.get(key);
        if (mAction != null) {
            if (mAction != NULL_METHOD_HOLDER) {
                return mAction;
            }
            return this.sendNotFoundError(response);
        }
        MetaProperty metaProperty = this.controllerToMetaPropertyCache.get(key);
        if (metaProperty == null && (mAction = ReflectionUtils.findMethod((Class)(controllerClass = AopProxyUtils.ultimateTargetClass((Object)controller)), (String)actionName, (Class[])NOARGS)) != null) {
            ReflectionUtils.makeAccessible((Method)mAction);
            if (mAction.getAnnotation(Action.class) != null) {
                if (!this.developmentMode) {
                    this.controllerToActionMethodCache.put(key, mAction);
                }
                return mAction;
            }
            if (!this.developmentMode) {
                this.controllerToActionMethodCache.put(key, NULL_METHOD_HOLDER);
            }
        }
        if (metaProperty == null) {
            metaProperty = controller.getMetaClass().getMetaProperty(actionName);
            if (!this.developmentMode) {
                if (metaProperty != null) {
                    this.controllerToMetaPropertyCache.put(key, metaProperty);
                } else {
                    this.controllerToMetaPropertyCache.put(key, NULL_META_PROPERTY_HOLDER);
                }
            }
        }
        Object closureAction = null;
        if (metaProperty != null) {
            if (metaProperty == NULL_META_PROPERTY_HOLDER) {
                return this.sendNotFoundError(response);
            }
            if (metaProperty.getType() == Object.class || Closure.class.isAssignableFrom(metaProperty.getType())) {
                closureAction = metaProperty.getProperty((Object)controller);
            } else {
                log.error("Invalid type for " + actionName + " in " + controller.getClass().getName() + ". type is " + metaProperty.getType());
                if (!this.developmentMode) {
                    this.controllerToMetaPropertyCache.put(key, NULL_META_PROPERTY_HOLDER);
                }
            }
        }
        if (!(closureAction instanceof Closure)) {
            return this.sendNotFoundError(response);
        }
        return closureAction;
    }

    protected Object sendNotFoundError(HttpServletResponse response) {
        try {
            response.sendError(404);
            return null;
        }
        catch (IOException e) {
            throw new ControllerExecutionException("I/O error sending 404 error", (Throwable)e);
        }
    }

    @Override
    protected Object invoke(GroovyObject controller, Object action) {
        try {
            if (action.getClass() == Method.class) {
                return ((Method)action).invoke((Object)controller, new Object[0]);
            }
            return ((Closure)action).call();
        }
        catch (Exception e) {
            throw new ControllerExecutionException("Runtime error executing action", (Throwable)e);
        }
    }
}

