/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.parser.AbstractHTMLPage;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.compatability.Content2HTMLPage;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.grails.buffer.StreamCharBuffer;
import org.grails.web.sitemesh.TokenizedHTMLPage2Content;

public class GSPSitemeshPage
extends AbstractHTMLPage
implements Content {
    StreamCharBuffer headBuffer;
    StreamCharBuffer bodyBuffer;
    StreamCharBuffer pageBuffer;
    StreamCharBuffer titleBuffer;
    boolean used;
    boolean titleCaptured;
    Map<String, StreamCharBuffer> contentBuffers;
    private boolean renderingLayout;

    public GSPSitemeshPage() {
        this(false);
    }

    public GSPSitemeshPage(boolean renderingLayout) {
        this.reset();
        this.renderingLayout = renderingLayout;
    }

    public void reset() {
        this.headBuffer = null;
        this.bodyBuffer = null;
        this.pageBuffer = null;
        this.titleBuffer = null;
        this.used = false;
        this.titleCaptured = false;
        this.contentBuffers = null;
        this.renderingLayout = false;
    }

    public void addProperty(String name, Object value) {
        this.addProperty(name, value == null ? null : String.valueOf(value));
    }

    public void addProperty(String name, String value) {
        super.addProperty(name, value);
        this.used = true;
    }

    public void writeHead(Writer out) throws IOException {
        if (this.headBuffer == null) {
            return;
        }
        if (this.titleCaptured) {
            if (this.titleBuffer != null) {
                int headlen = this.headBuffer.length();
                this.titleBuffer.clear();
                if (this.headBuffer.length() < headlen) {
                    this.headBuffer.writeTo(out);
                    return;
                }
            }
            String headAsString = this.headBuffer.toString();
            out.write(headAsString.replaceFirst("(?is)<title(\\s[^>]*)?>(.*?)</title>", ""));
        } else {
            this.headBuffer.writeTo(out);
        }
    }

    public void writeBody(Writer out) throws IOException {
        if (this.bodyBuffer != null) {
            this.bodyBuffer.writeTo(out);
        } else if (this.pageBuffer != null) {
            this.pageBuffer.writeTo(out);
        }
    }

    public void writePage(Writer out) throws IOException {
        if (this.pageBuffer != null) {
            this.pageBuffer.writeTo(out);
        }
    }

    public String getHead() {
        if (this.headBuffer != null) {
            return this.headBuffer.toString();
        }
        return null;
    }

    public String getBody() {
        if (this.bodyBuffer != null) {
            return this.bodyBuffer.toString();
        }
        return null;
    }

    public String getPage() {
        if (this.pageBuffer != null) {
            return this.pageBuffer.toString();
        }
        return null;
    }

    public int originalLength() {
        return this.pageBuffer.size();
    }

    public void writeOriginal(Writer writer) throws IOException {
        this.writePage(writer);
    }

    public void setHeadBuffer(StreamCharBuffer headBuffer) {
        this.headBuffer = headBuffer;
        this.applyStreamCharBufferSettings(headBuffer);
        this.used = true;
    }

    private void applyStreamCharBufferSettings(StreamCharBuffer buffer) {
        if (!this.renderingLayout && buffer != null) {
            buffer.setPreferSubChunkWhenWritingToOtherBuffer(true);
        }
    }

    public void setBodyBuffer(StreamCharBuffer bodyBuffer) {
        this.bodyBuffer = bodyBuffer;
        this.applyStreamCharBufferSettings(bodyBuffer);
        this.used = true;
    }

    public void setPageBuffer(StreamCharBuffer pageBuffer) {
        this.pageBuffer = pageBuffer;
        this.applyStreamCharBufferSettings(pageBuffer);
    }

    public void setTitleBuffer(StreamCharBuffer titleBuffer) {
        this.titleBuffer = titleBuffer;
        this.applyStreamCharBufferSettings(titleBuffer);
    }

    public StreamCharBuffer getTitleBuffer() {
        return this.titleBuffer;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public void setContentBuffer(String tagName, StreamCharBuffer buffer) {
        this.used = true;
        if (this.contentBuffers == null) {
            this.contentBuffers = new HashMap<String, StreamCharBuffer>();
        }
        String propertyName = "page." + tagName;
        this.contentBuffers.put(propertyName, buffer);
        super.addProperty(propertyName, "");
    }

    public Object getContentBuffer(String name) {
        if (this.contentBuffers == null) {
            return null;
        }
        return this.contentBuffers.get(name);
    }

    public static HTMLPage content2htmlPage(Content content) {
        Object htmlPage = null;
        htmlPage = content instanceof HTMLPage ? (HTMLPage)content : (content instanceof TokenizedHTMLPage2Content ? ((TokenizedHTMLPage2Content)content).getPage() : new Content2HTMLPage(content, null));
        return htmlPage;
    }

    public boolean isTitleCaptured() {
        return this.titleCaptured;
    }

    public void setTitleCaptured(boolean titleCaptured) {
        this.titleCaptured = titleCaptured;
    }
}

