/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.binding;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.binding.StructuredPropertyEditor;
import org.springframework.beans.propertyeditors.CustomDateEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredDateEditor
extends CustomDateEditor
implements StructuredPropertyEditor {
    public StructuredDateEditor(DateFormat dateFormat, boolean b) {
        super(dateFormat, b);
    }

    public StructuredDateEditor(DateFormat dateFormat, boolean b, int i) {
        super(dateFormat, b, i);
    }

    @Override
    public List<String> getRequiredFields() {
        return Arrays.asList("year");
    }

    @Override
    public List<String> getOptionalFields() {
        return Arrays.asList("month", "day", "hour", "minute");
    }

    @Override
    public Object assemble(Class type, Map fieldValues) throws IllegalArgumentException {
        if (!fieldValues.containsKey("year")) {
            throw new IllegalArgumentException("Can't populate a date without a year");
        }
        String yearString = (String)fieldValues.get("year");
        String monthString = (String)fieldValues.get("month");
        String dayString = (String)fieldValues.get("day");
        String hourString = (String)fieldValues.get("hour");
        String minuteString = (String)fieldValues.get("minute");
        if (StringUtils.isBlank((String)yearString) && StringUtils.isBlank((String)monthString) && StringUtils.isBlank((String)dayString) && StringUtils.isBlank((String)hourString) && StringUtils.isBlank((String)minuteString)) {
            return null;
        }
        try {
            if (StringUtils.isBlank((String)yearString)) {
                throw new IllegalArgumentException("Can't populate a date without a year");
            }
            int year = Integer.parseInt(yearString);
            int month = this.getIntegerValue(fieldValues, "month", 1);
            int day = this.getIntegerValue(fieldValues, "day", 1);
            int hour = this.getIntegerValue(fieldValues, "hour", 0);
            int minute = this.getIntegerValue(fieldValues, "minute", 0);
            GregorianCalendar c = new GregorianCalendar(year, month - 1, day, hour, minute);
            if (type == Date.class) {
                return c.getTime();
            }
            if (type == java.sql.Date.class) {
                return new java.sql.Date(c.getTime().getTime());
            }
            return c;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Unable to parse structured date from request for date [\"+propertyName+\"]\"");
        }
    }

    private int getIntegerValue(Map values, String name, int defaultValue) throws NumberFormatException {
        if (values.get(name) != null) {
            return Integer.parseInt((String)values.get(name));
        }
        return defaultValue;
    }
}

