/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsUrlMappingsClass;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingEvaluator;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingsHolder;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappingEvaluator;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlMappingsHolderFactoryBean
implements FactoryBean<UrlMappingsHolder>,
InitializingBean,
GrailsApplicationAware,
ServletContextAware {
    private static final String URL_MAPPING_CACHE_MAX_SIZE = "grails.urlmapping.cache.maxsize";
    private static final String URL_CREATOR_CACHE_MAX_SIZE = "grails.urlcreator.cache.maxsize";
    private GrailsApplication grailsApplication;
    private UrlMappingsHolder urlMappingsHolder;
    private UrlMappingEvaluator mappingEvaluator;
    private ServletContext servletContext;

    public UrlMappingsHolder getObject() throws Exception {
        return this.urlMappingsHolder;
    }

    public Class<UrlMappingsHolder> getObjectType() {
        return UrlMappingsHolder.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Integer urlCreatorCacheSize;
        Assert.state((this.grailsApplication != null ? 1 : 0) != 0, (String)"Property [grailsApplication] must be set!");
        ArrayList<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
        ArrayList excludePatterns = new ArrayList();
        GrailsClass[] mappings = this.grailsApplication.getArtefacts("UrlMappings");
        this.mappingEvaluator = new DefaultUrlMappingEvaluator(this.servletContext);
        for (GrailsClass mapping : mappings) {
            GrailsUrlMappingsClass mappingClass = (GrailsUrlMappingsClass)mapping;
            List grailsClassMappings = Script.class.isAssignableFrom(mappingClass.getClass()) ? this.mappingEvaluator.evaluateMappings(mappingClass.getClazz()) : this.mappingEvaluator.evaluateMappings(mappingClass.getMappingsClosure());
            urlMappings.addAll(grailsClassMappings);
            if (mappingClass.getExcludePatterns() == null) continue;
            excludePatterns.addAll(mappingClass.getExcludePatterns());
        }
        DefaultUrlMappingsHolder defaultUrlMappingsHolder = new DefaultUrlMappingsHolder(urlMappings, excludePatterns, true);
        Map flatConfig = this.grailsApplication.getFlatConfig();
        Integer cacheSize = UrlMappingsHolderFactoryBean.mapGetInteger(flatConfig, URL_MAPPING_CACHE_MAX_SIZE);
        if (cacheSize != null) {
            defaultUrlMappingsHolder.setMaxWeightedCacheCapacity(cacheSize);
        }
        if ((urlCreatorCacheSize = UrlMappingsHolderFactoryBean.mapGetInteger(flatConfig, URL_CREATOR_CACHE_MAX_SIZE)) != null) {
            defaultUrlMappingsHolder.setUrlCreatorMaxWeightedCacheCapacity(urlCreatorCacheSize);
        }
        defaultUrlMappingsHolder.initialize();
        this.urlMappingsHolder = defaultUrlMappingsHolder;
    }

    private static Integer mapGetInteger(Map map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(String.valueOf(value));
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

