/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.lang.GroovyObject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriService;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriSupport;
import org.springframework.util.Assert;

public class DefaultGroovyPagesUriService
extends GroovyPagesUriSupport
implements GroovyPagesUriService {
    ConcurrentMap<TupleStringKey, String> templateURICache = new ConcurrentHashMap<TupleStringKey, String>();
    ConcurrentMap<TupleStringKey, String> deployedViewURICache = new ConcurrentHashMap<TupleStringKey, String>();
    ConcurrentMap<ControllerObjectKey, String> controllerNameCache = new ConcurrentHashMap<ControllerObjectKey, String>();
    ConcurrentMap<TupleStringKey, String> noSuffixViewURICache = new ConcurrentHashMap<TupleStringKey, String>();

    public String getTemplateURI(String controllerName, String templateName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, templateName);
        String uri = (String)this.templateURICache.get(key);
        if (uri == null && (prevuri = this.templateURICache.putIfAbsent(key, uri = super.getTemplateURI(controllerName, templateName))) != null) {
            return prevuri;
        }
        return uri;
    }

    public String getDeployedViewURI(String controllerName, String viewName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, viewName);
        String uri = (String)this.deployedViewURICache.get(key);
        if (uri == null && (prevuri = this.deployedViewURICache.putIfAbsent(key, uri = super.getDeployedViewURI(controllerName, viewName))) != null) {
            return prevuri;
        }
        return uri;
    }

    public String getLogicalControllerName(GroovyObject controller) {
        String prevname;
        ControllerObjectKey key = new ControllerObjectKey(controller);
        String name = (String)this.controllerNameCache.get(key);
        if (name == null && (prevname = this.controllerNameCache.putIfAbsent(key, name = super.getLogicalControllerName(controller))) != null) {
            return prevname;
        }
        return name;
    }

    public String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        Assert.notNull((Object)controller, (String)"Argument [controller] cannot be null");
        return this.getNoSuffixViewURI(this.getLogicalControllerName(controller), viewName);
    }

    public String getNoSuffixViewURI(String controllerName, String viewName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, viewName);
        String uri = (String)this.noSuffixViewURICache.get(key);
        if (uri == null && (prevuri = this.noSuffixViewURICache.putIfAbsent(key, uri = super.getNoSuffixViewURI(controllerName, viewName))) != null) {
            return prevuri;
        }
        return uri;
    }

    public String getTemplateURI(GroovyObject controller, String templateName) {
        return this.getTemplateURI(this.getLogicalControllerName(controller), templateName);
    }

    public void clear() {
        this.templateURICache.clear();
        this.deployedViewURICache.clear();
        this.controllerNameCache.clear();
        this.noSuffixViewURICache.clear();
    }

    private static class ControllerObjectKey {
        private long controllerHashCode;
        private String controllerClassName;

        public ControllerObjectKey(GroovyObject controller) {
            this.controllerHashCode = System.identityHashCode(controller.getClass());
            this.controllerClassName = controller.getClass().getName();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            ControllerObjectKey thatKey = (ControllerObjectKey)that;
            return new EqualsBuilder().append(this.controllerHashCode, thatKey.controllerHashCode).append((Object)this.controllerClassName, (Object)thatKey.controllerClassName).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.controllerHashCode).append((Object)this.controllerClassName).toHashCode();
        }
    }

    private static class TupleStringKey {
        String keyPart1;
        String keyPart2;

        public TupleStringKey(String keyPart1, String keyPart2) {
            this.keyPart1 = keyPart1;
            this.keyPart2 = keyPart2;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            TupleStringKey thatKey = (TupleStringKey)that;
            return new EqualsBuilder().append((Object)this.keyPart1, (Object)thatKey.keyPart1).append((Object)this.keyPart2, (Object)thatKey.keyPart2).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.keyPart1).append((Object)this.keyPart2).toHashCode();
        }
    }
}

