/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.sitemesh;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.Decorator;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.web.pages.exceptions.GroovyPagesException;
import org.codehaus.groovy.grails.web.sitemesh.GSPSitemeshPage;
import org.codehaus.groovy.grails.web.sitemesh.GrailsPageFilter;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class SpringMVCViewDecorator
extends DefaultDecorator
implements Decorator {
    private View view;

    public SpringMVCViewDecorator(String name, View view) {
        super(name, view instanceof AbstractUrlBasedView ? ((AbstractUrlBasedView)view).getUrl() : view.toString(), Collections.EMPTY_MAP);
        this.view = view;
    }

    public void render(Content content, SiteMeshContext context) {
        SiteMeshWebAppContext ctx = (SiteMeshWebAppContext)context;
        this.render(content, ctx.getRequest(), ctx.getResponse(), ctx.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Content content, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        HTMLPage htmlPage = GSPSitemeshPage.content2htmlPage(content);
        request.setAttribute("__sitemesh__page", (Object)htmlPage);
        if (!response.isCommitted()) {
            boolean dispatched = false;
            try {
                request.setAttribute(GrailsPageFilter.GSP_SITEMESH_PAGE, (Object)new GSPSitemeshPage());
                request.setAttribute("com.opensymphony.sitemesh.APPLIED_ONCE", (Object)Boolean.TRUE);
                try {
                    this.view.render(Collections.emptyMap(), request, response);
                    dispatched = true;
                    if (!response.isCommitted()) {
                        response.getWriter().flush();
                    }
                }
                catch (Exception e) {
                    this.cleanRequestAttributes(request);
                    throw new GroovyPagesException("Error applying layout : " + this.getName(), e);
                }
                Object var9_8 = null;
                if (!dispatched) {
                    this.cleanRequestAttributes(request);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!dispatched) {
                    this.cleanRequestAttributes(request);
                }
                throw throwable;
            }
        }
        request.removeAttribute("__sitemesh__page");
        request.removeAttribute(GrailsPageFilter.GSP_SITEMESH_PAGE);
    }

    private void cleanRequestAttributes(HttpServletRequest request) {
        request.removeAttribute("org.codehaus.groovy.grails.PAGE_SCOPE");
        request.removeAttribute("org.grails.layout.name");
        request.setAttribute("com.opensymphony.sitemesh.APPLIED_ONCE", null);
    }
}

