/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import groovy.lang.Writable;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.util.GrailsWrappedWriter;
import org.codehaus.groovy.grails.web.util.StringCharArrayAccessor;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.util.HtmlUtils;

public class StreamCharBuffer
implements Writable,
CharSequence,
Externalizable {
    static final long serialVersionUID = 5486972234419632945L;
    private static final Log log = LogFactory.getLog(StreamCharBuffer.class);
    private static final int DEFAULT_CHUNK_SIZE = Integer.getInteger("streamcharbuffer.chunksize", 512);
    private static final int DEFAULT_MAX_CHUNK_SIZE = Integer.getInteger("streamcharbuffer.maxchunksize", 0x100000);
    private static final int DEFAULT_CHUNK_SIZE_GROW_PROCENT = Integer.getInteger("streamcharbuffer.growprocent", 100);
    private static final int SUB_BUFFERCHUNK_MIN_SIZE = Integer.getInteger("streamcharbuffer.subbufferchunkminsize", 512);
    private static final int SUB_STRINGCHUNK_MIN_SIZE = Integer.getInteger("streamcharbuffer.substringchunkminsize", 512);
    private static final int WRITE_DIRECT_MIN_SIZE = Integer.getInteger("streamcharbuffer.writedirectminsize", 1024);
    private static final int CHUNK_MIN_SIZE = Integer.getInteger("streamcharbuffer.chunkminsize", 256);
    private final int firstChunkSize;
    private final int growProcent;
    private final int maxChunkSize;
    private int subStringChunkMinSize = SUB_STRINGCHUNK_MIN_SIZE;
    private int subBufferChunkMinSize = SUB_BUFFERCHUNK_MIN_SIZE;
    private int writeDirectlyToConnectedMinSize = WRITE_DIRECT_MIN_SIZE;
    private int chunkMinSize = CHUNK_MIN_SIZE;
    private int chunkSize;
    private int totalChunkSize;
    private final StreamCharBufferWriter writer;
    private List<ConnectedWriter> connectedWriters;
    private Writer connectedWritersWriter;
    boolean preferSubChunkWhenWritingToOtherBuffer = false;
    private AllocatedBuffer allocBuffer;
    private AbstractChunk firstChunk;
    private AbstractChunk lastChunk;
    private int totalCharsInList;
    private int totalCharsInDynamicChunks;
    private int sizeAtLeast;
    private StreamCharBufferKey bufferKey = new StreamCharBufferKey();
    private Map<StreamCharBufferKey, StreamCharBufferSubChunk> dynamicChunkMap;
    private Set<SoftReference<StreamCharBufferKey>> parentBuffers;
    int allocatedBufferIdSequence = 0;
    int readerCount = 0;
    boolean hasReaders = false;

    public StreamCharBuffer() {
        this(DEFAULT_CHUNK_SIZE, DEFAULT_CHUNK_SIZE_GROW_PROCENT, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize) {
        this(chunkSize, DEFAULT_CHUNK_SIZE_GROW_PROCENT, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize, int growProcent) {
        this(chunkSize, growProcent, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize, int growProcent, int maxChunkSize) {
        this.firstChunkSize = chunkSize;
        this.growProcent = growProcent;
        this.maxChunkSize = maxChunkSize;
        this.writer = new StreamCharBufferWriter();
        this.reset(true);
    }

    public boolean isPreferSubChunkWhenWritingToOtherBuffer() {
        return this.preferSubChunkWhenWritingToOtherBuffer;
    }

    public void setPreferSubChunkWhenWritingToOtherBuffer(boolean preferSubChunkWhenWritingToOtherBuffer) {
        this.preferSubChunkWhenWritingToOtherBuffer = preferSubChunkWhenWritingToOtherBuffer;
    }

    public final void reset() {
        this.reset(true);
    }

    public final void reset(boolean resetChunkSize) {
        this.firstChunk = null;
        this.lastChunk = null;
        this.totalCharsInList = 0;
        this.totalCharsInDynamicChunks = -1;
        this.sizeAtLeast = -1;
        if (resetChunkSize) {
            this.chunkSize = this.firstChunkSize;
            this.totalChunkSize = 0;
        }
        this.allocBuffer = new AllocatedBuffer(this.chunkSize);
        this.dynamicChunkMap = new HashMap<StreamCharBufferKey, StreamCharBufferSubChunk>();
        this.parentBuffers = null;
    }

    public final void connectTo(Writer w) {
        this.connectTo(w, true);
    }

    public final void connectTo(Writer w, boolean autoFlush) {
        this.initConnected();
        this.connectedWriters.add(new ConnectedWriter(w, autoFlush));
        this.initConnectedWritersWriter();
    }

    private void initConnectedWritersWriter() {
        this.connectedWritersWriter = this.connectedWriters.size() > 1 ? new MultiOutputWriter(this.connectedWriters) : new SingleOutputWriter(this.connectedWriters.get(0));
    }

    public final void connectTo(LazyInitializingWriter w) {
        this.connectTo(w, true);
    }

    public final void connectTo(LazyInitializingWriter w, boolean autoFlush) {
        this.initConnected();
        this.connectedWriters.add(new ConnectedWriter(w, autoFlush));
        this.initConnectedWritersWriter();
    }

    public final void removeConnections() {
        if (this.connectedWriters != null) {
            this.connectedWriters.clear();
            this.connectedWritersWriter = null;
        }
    }

    private void initConnected() {
        if (this.connectedWriters == null) {
            this.connectedWriters = new ArrayList<ConnectedWriter>(2);
        }
    }

    public int getSubStringChunkMinSize() {
        return this.subStringChunkMinSize;
    }

    public void setSubStringChunkMinSize(int stringChunkMinSize) {
        this.subStringChunkMinSize = stringChunkMinSize;
    }

    public int getSubBufferChunkMinSize() {
        return this.subBufferChunkMinSize;
    }

    public void setSubBufferChunkMinSize(int subBufferChunkMinSize) {
        this.subBufferChunkMinSize = subBufferChunkMinSize;
    }

    public int getWriteDirectlyToConnectedMinSize() {
        return this.writeDirectlyToConnectedMinSize;
    }

    public void setWriteDirectlyToConnectedMinSize(int writeDirectlyToConnectedMinSize) {
        this.writeDirectlyToConnectedMinSize = writeDirectlyToConnectedMinSize;
    }

    public int getChunkMinSize() {
        return this.chunkMinSize;
    }

    public void setChunkMinSize(int chunkMinSize) {
        this.chunkMinSize = chunkMinSize;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Reader getReader() {
        return this.getReader(false);
    }

    public Reader getReader(boolean removeAfterReading) {
        ++this.readerCount;
        this.hasReaders = true;
        return new StreamCharBufferReader(removeAfterReading);
    }

    public Writer writeTo(Writer target) throws IOException {
        this.writeTo(target, false, false);
        return this.getWriter();
    }

    public void writeTo(Writer target, boolean flushTarget, boolean emptyAfter) throws IOException {
        if (target instanceof GrailsWrappedWriter) {
            target = ((GrailsWrappedWriter)((Object)target)).unwrap();
        }
        if (target instanceof StreamCharBufferWriter) {
            if (target == this.writer) {
                throw new IllegalArgumentException("Cannot write buffer to itself.");
            }
            ((StreamCharBufferWriter)target).write(this);
            return;
        }
        this.writeToImpl(target, flushTarget, emptyAfter);
    }

    private void writeToImpl(Writer target, boolean flushTarget, boolean emptyAfter) throws IOException {
        AbstractChunk current = this.firstChunk;
        while (current != null) {
            current.writeTo(target);
            current = current.next;
        }
        if (emptyAfter) {
            this.firstChunk = null;
            this.lastChunk = null;
            this.totalCharsInList = 0;
            this.totalCharsInDynamicChunks = -1;
            this.sizeAtLeast = -1;
            this.dynamicChunkMap.clear();
        }
        this.allocBuffer.writeTo(target);
        if (emptyAfter) {
            this.allocBuffer.reuseBuffer();
        }
        if (flushTarget) {
            target.flush();
        }
    }

    public char[] readAsCharArray() {
        int currentSize = this.size();
        if (currentSize == 0) {
            return new char[0];
        }
        FixedCharArrayWriter target = new FixedCharArrayWriter(currentSize);
        try {
            this.writeTo(target);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
        return target.getCharArray();
    }

    public String readAsString() {
        char[] buf = this.readAsCharArray();
        if (buf.length > 0) {
            return StringCharArrayAccessor.createString(buf);
        }
        return "";
    }

    public String toString() {
        if (this.firstChunk == this.lastChunk && this.firstChunk instanceof StringChunk && this.allocBuffer.charsUsed() == 0 && ((StringChunk)this.firstChunk).isSingleBuffer()) {
            return ((StringChunk)this.firstChunk).str;
        }
        int initialReaderCount = this.readerCount;
        String str = this.readAsString();
        if (initialReaderCount == 0) {
            this.reset();
            if (str.length() > 0) {
                this.addChunk(new StringChunk(str, 0, str.length()));
            }
        }
        return str;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharSequence)) {
            return false;
        }
        CharSequence other = (CharSequence)o;
        return this.toString().equals(((Object)other).toString());
    }

    public String plus(String value) {
        return this.toString() + value;
    }

    public String plus(Object value) {
        return this.toString() + String.valueOf(value);
    }

    public char[] toCharArray() {
        if (this.firstChunk == this.lastChunk && this.firstChunk instanceof CharBufferChunk && this.allocBuffer.charsUsed() == 0 && ((CharBufferChunk)this.firstChunk).isSingleBuffer()) {
            return ((CharBufferChunk)this.firstChunk).buffer;
        }
        int initialReaderCount = this.readerCount;
        char[] buf = this.readAsCharArray();
        if (initialReaderCount == 0) {
            this.reset();
            if (buf.length > 0) {
                this.addChunk(new CharBufferChunk(-1, buf, 0, buf.length));
            }
        }
        return buf;
    }

    public int size() {
        int total = this.totalCharsInList;
        if (this.totalCharsInDynamicChunks == -1) {
            this.totalCharsInDynamicChunks = 0;
            for (StreamCharBufferSubChunk chunk : this.dynamicChunkMap.values()) {
                this.totalCharsInDynamicChunks += chunk.size();
            }
        }
        total += this.totalCharsInDynamicChunks;
        this.sizeAtLeast = total += this.allocBuffer.charsUsed();
        return total;
    }

    public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    boolean isNotEmpty() {
        if (this.totalCharsInList > 0) {
            return true;
        }
        if (this.totalCharsInDynamicChunks > 0) {
            return true;
        }
        if (this.allocBuffer.charsUsed() > 0) {
            return true;
        }
        if (this.totalCharsInDynamicChunks == -1) {
            for (StreamCharBufferSubChunk chunk : this.dynamicChunkMap.values()) {
                if (!chunk.getSubBuffer().isNotEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    boolean isSizeLarger(int minSize) {
        if (minSize <= this.sizeAtLeast) {
            return true;
        }
        boolean retval = this.calculateIsSizeLarger(minSize);
        if (retval && minSize > this.sizeAtLeast) {
            this.sizeAtLeast = minSize;
        }
        return retval;
    }

    private boolean calculateIsSizeLarger(int minSize) {
        int total = this.totalCharsInList;
        if ((total += this.allocBuffer.charsUsed()) > minSize) {
            return true;
        }
        if (this.totalCharsInDynamicChunks != -1) {
            if ((total += this.totalCharsInDynamicChunks) > minSize) {
                return true;
            }
        } else {
            for (StreamCharBufferSubChunk chunk : this.dynamicChunkMap.values()) {
                if (!chunk.hasCachedSize() && chunk.getSubBuffer().isSizeLarger(minSize - total)) {
                    return true;
                }
                if ((total += chunk.size()) <= minSize) continue;
                return true;
            }
        }
        return false;
    }

    int allocateSpace() throws IOException {
        int spaceLeft = this.allocBuffer.spaceLeft();
        if (spaceLeft == 0) {
            spaceLeft = this.appendCharBufferChunk(true);
        }
        return spaceLeft;
    }

    private int appendCharBufferChunk(boolean flushInConnected) throws IOException {
        int spaceLeft = 0;
        if (flushInConnected && this.isConnectedMode()) {
            this.flushToConnected();
            if (!this.isChunkSizeResizeable()) {
                this.allocBuffer.reuseBuffer();
                spaceLeft = this.allocBuffer.spaceLeft();
            } else {
                spaceLeft = 0;
            }
        } else {
            if (this.allocBuffer.hasChunk()) {
                this.addChunk(this.allocBuffer.createChunk());
            }
            spaceLeft = this.allocBuffer.spaceLeft();
        }
        if (spaceLeft == 0) {
            this.totalChunkSize += this.allocBuffer.chunkSize();
            this.resizeChunkSizeAsProcentageOfTotalSize();
            this.allocBuffer = new AllocatedBuffer(this.chunkSize);
            spaceLeft = this.allocBuffer.spaceLeft();
        }
        return spaceLeft;
    }

    void appendStringChunk(String str, int off, int len) throws IOException {
        this.appendCharBufferChunk(false);
        this.addChunk(new StringChunk(str, off, len));
    }

    public void appendStreamCharBufferChunk(StreamCharBuffer subBuffer) throws IOException {
        this.appendCharBufferChunk(false);
        this.addChunk(new StreamCharBufferSubChunk(subBuffer));
    }

    void addChunk(AbstractChunk newChunk) {
        if (this.lastChunk != null) {
            this.lastChunk.next = newChunk;
            if (this.hasReaders) {
                newChunk.prev = this.lastChunk;
            }
        }
        this.lastChunk = newChunk;
        if (this.firstChunk == null) {
            this.firstChunk = newChunk;
        }
        if (newChunk instanceof StreamCharBufferSubChunk) {
            StreamCharBufferSubChunk bufSubChunk = (StreamCharBufferSubChunk)newChunk;
            this.dynamicChunkMap.put(bufSubChunk.streamCharBuffer.bufferKey, bufSubChunk);
        } else {
            this.totalCharsInList += newChunk.size();
        }
    }

    public boolean isConnectedMode() {
        return this.connectedWriters != null && !this.connectedWriters.isEmpty();
    }

    private void flushToConnected() throws IOException {
        this.writeTo(this.connectedWritersWriter, true, true);
    }

    protected boolean isChunkSizeResizeable() {
        return this.growProcent > 0;
    }

    protected void resizeChunkSizeAsProcentageOfTotalSize() {
        if (this.growProcent == 0) {
            return;
        }
        if (this.growProcent == 100) {
            this.chunkSize = Math.min(this.totalChunkSize, this.maxChunkSize);
        } else if (this.growProcent == 200) {
            this.chunkSize = Math.min(this.totalChunkSize << 1, this.maxChunkSize);
        } else if (this.growProcent > 0) {
            this.chunkSize = Math.max(Math.min(this.totalChunkSize * this.growProcent / 100, this.maxChunkSize), this.firstChunkSize);
        }
    }

    protected static final void arrayCopy(char[] src, int srcPos, char[] dest, int destPos, int length) {
        if (length == 1) {
            dest[destPos] = src[srcPos];
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    public int length() {
        return this.size();
    }

    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public boolean asBoolean() {
        return this.isNotEmpty();
    }

    void addParentBuffer(StreamCharBuffer parent) {
        if (this.parentBuffers == null) {
            this.parentBuffers = new HashSet<SoftReference<StreamCharBufferKey>>();
        }
        this.parentBuffers.add(new SoftReference<StreamCharBufferKey>(parent.bufferKey));
    }

    boolean bufferChanged(StreamCharBuffer buffer) {
        StreamCharBufferSubChunk subChunk = this.dynamicChunkMap.get(buffer.bufferKey);
        if (subChunk == null) {
            return false;
        }
        if (subChunk.resetSize()) {
            this.totalCharsInDynamicChunks = -1;
            this.sizeAtLeast = -1;
            this.notifyBufferChange();
        }
        return true;
    }

    void notifyBufferChange() {
        if (this.parentBuffers == null) {
            return;
        }
        Iterator<SoftReference<StreamCharBufferKey>> i = this.parentBuffers.iterator();
        while (i.hasNext()) {
            SoftReference<StreamCharBufferKey> ref = i.next();
            StreamCharBufferKey parentKey = ref.get();
            boolean removeIt = true;
            if (parentKey != null) {
                StreamCharBuffer parent = parentKey.getBuffer();
                boolean bl = removeIt = !parent.bufferChanged(this);
            }
            if (!removeIt) continue;
            i.remove();
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String str = in.readUTF();
        this.reset();
        if (str.length() > 0) {
            this.addChunk(new StringChunk(str, 0, str.length()));
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        String str = this.toString();
        out.writeUTF(str);
    }

    public StreamCharBuffer encodeAsHTML() {
        StreamCharBuffer coded = new StreamCharBuffer(Math.min(Math.max(this.totalChunkSize, this.chunkSize) * 12 / 10, this.maxChunkSize));
        Writer codedWriter = coded.getWriter();
        if (StreamingHTMLEncoderHelper.disabled) {
            try {
                codedWriter.write(HtmlUtils.htmlEscape((String)this.toString()));
            }
            catch (IOException e) {
                log.error((Object)"IOException in StreamCharBuffer.encodeAsHTML", (Throwable)e);
            }
        } else {
            Reader reader = this.getReader();
            char[] buf = new char[1];
            try {
                while (reader.read(buf) != -1) {
                    String reference = StreamingHTMLEncoderHelper.convertToReference(buf[0]);
                    if (reference != null) {
                        codedWriter.write(reference);
                        continue;
                    }
                    codedWriter.write(buf);
                }
            }
            catch (IOException e) {
                log.error((Object)"IOException in StreamCharBuffer.encodeAsHTML", (Throwable)e);
            }
        }
        return coded;
    }

    private static class StreamingHTMLEncoderHelper {
        private static Object instance;
        private static Method mapMethod;
        private static boolean disabled;

        private StreamingHTMLEncoderHelper() {
        }

        public static String convertToReference(char c) {
            return (String)ReflectionUtils.invokeMethod((Method)mapMethod, (Object)instance, (Object[])new Object[]{Character.valueOf(c)});
        }

        static {
            disabled = false;
            try {
                Field instanceField = ReflectionUtils.findField(HtmlUtils.class, (String)"characterEntityReferences");
                ReflectionUtils.makeAccessible((Field)instanceField);
                instance = instanceField.get(null);
                mapMethod = ReflectionUtils.findMethod(instance.getClass(), (String)"convertToReference", (Class[])new Class[]{Character.TYPE});
                if (mapMethod != null) {
                    ReflectionUtils.makeAccessible((Method)mapMethod);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Couldn't use reflection for resolving characterEntityReferences in HtmlUtils class", (Throwable)e);
                disabled = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MultiOutputWriter
    extends Writer {
        final List<ConnectedWriter> writers;

        public MultiOutputWriter(List<ConnectedWriter> writers) {
            this.writers = writers;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
            for (ConnectedWriter writer : this.writers) {
                writer.flush();
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (ConnectedWriter writer : this.writers) {
                writer.getWriter().write(cbuf, off, len);
            }
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            for (ConnectedWriter writer : this.writers) {
                writer.getWriter().append(csq, start, end);
            }
            return this;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            for (ConnectedWriter writer : this.writers) {
                StringCharArrayAccessor.writeStringAsCharArray(writer.getWriter(), str, off, len);
            }
        }
    }

    static final class SingleOutputWriter
    extends Writer {
        private ConnectedWriter writer;

        public SingleOutputWriter(ConnectedWriter writer) {
            this.writer = writer;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.writer.getWriter().write(cbuf, off, len);
        }

        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.writer.getWriter().append(csq, start, end);
            return this;
        }

        public void write(String str, int off, int len) throws IOException {
            StringCharArrayAccessor.writeStringAsCharArray(this.writer.getWriter(), str, off, len);
        }
    }

    static final class ConnectedWriter {
        Writer writer;
        LazyInitializingWriter lazyInitializingWriter;
        final boolean autoFlush;

        ConnectedWriter(Writer writer, boolean autoFlush) {
            this.writer = writer;
            this.autoFlush = autoFlush;
        }

        ConnectedWriter(LazyInitializingWriter lazyInitializingWriter, boolean autoFlush) {
            this.lazyInitializingWriter = lazyInitializingWriter;
            this.autoFlush = autoFlush;
        }

        Writer getWriter() throws IOException {
            if (this.writer == null && this.lazyInitializingWriter != null) {
                this.writer = this.lazyInitializingWriter.getWriter();
            }
            return this.writer;
        }

        public void flush() throws IOException {
            if (this.writer != null && this.isAutoFlush()) {
                this.writer.flush();
            }
        }

        public boolean isAutoFlush() {
            return this.autoFlush;
        }
    }

    public static interface LazyInitializingWriter {
        public Writer getWriter() throws IOException;
    }

    private static final class FixedCharArrayWriter
    extends Writer {
        char[] buf;
        int count = 0;

        public FixedCharArrayWriter(int fixedSize) {
            this.buf = new char[fixedSize];
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            StreamCharBuffer.arrayCopy(cbuf, off, this.buf, this.count, len);
            this.count += len;
        }

        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        public void write(String str, int off, int len) throws IOException {
            str.getChars(off, off + len, this.buf, this.count);
            this.count += len;
        }

        public void write(String str) throws IOException {
            this.write(str, 0, str.length());
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public char[] getCharArray() {
            return this.buf;
        }
    }

    final class AllocatedBufferReader
    extends ChunkReader {
        AllocatedBuffer parent;
        int position;
        int writerUsedCounter;
        boolean removeAfterReading;

        public AllocatedBufferReader(AllocatedBuffer parent, boolean removeAfterReading) {
            this.parent = parent;
            this.position = parent.chunkStart;
            this.writerUsedCounter = StreamCharBuffer.this.hasReaders ? ((StreamCharBuffer)StreamCharBuffer.this).writer.writerUsedCounter : 1;
            this.removeAfterReading = removeAfterReading;
        }

        public int getReadLenLimit(int askedAmount) {
            return Math.min(this.parent.used - this.position, askedAmount);
        }

        public int read(char[] ch, int off, int len) throws IOException {
            StreamCharBuffer.arrayCopy(this.parent.buffer, this.position, ch, off, len);
            this.position += len;
            if (this.removeAfterReading) {
                this.parent.chunkStart = this.position;
            }
            return len;
        }

        public ChunkReader next() {
            return null;
        }

        public int getWriterUsedCounter() {
            return this.writerUsedCounter;
        }

        public boolean isValid() {
            return StreamCharBuffer.this.allocBuffer == this.parent && (StreamCharBuffer.this.lastChunk == null || ((StreamCharBuffer)StreamCharBuffer.this).lastChunk.writerUsedCounter < this.writerUsedCounter);
        }
    }

    final class StreamCharBufferSubChunkReader
    extends AbstractChunkReader {
        StreamCharBufferSubChunk parent;
        private StreamCharBufferReader reader;

        public StreamCharBufferSubChunkReader(StreamCharBufferSubChunk parent, boolean removeAfterReading) {
            super(parent, removeAfterReading);
            this.parent = parent;
            this.reader = (StreamCharBufferReader)parent.streamCharBuffer.getReader();
        }

        public int getReadLenLimit(int askedAmount) {
            return this.reader.getReadLenLimit(askedAmount);
        }

        public int read(char[] ch, int off, int len) throws IOException {
            return this.reader.read(ch, off, len);
        }
    }

    final class StreamCharBufferSubChunk
    extends AbstractChunk {
        StreamCharBuffer streamCharBuffer;
        int cachedSize;

        public StreamCharBufferSubChunk(StreamCharBuffer streamCharBuffer2) {
            this.streamCharBuffer = streamCharBuffer2;
            if (StreamCharBuffer.this.totalCharsInDynamicChunks != -1) {
                this.cachedSize = streamCharBuffer2.size();
                StreamCharBuffer.this.totalCharsInDynamicChunks += this.cachedSize;
            } else {
                this.cachedSize = -1;
            }
        }

        public void writeTo(Writer target) throws IOException {
            this.streamCharBuffer.writeTo(target);
        }

        public ChunkReader getChunkReader(boolean removeAfterReading) {
            return new StreamCharBufferSubChunkReader(this, removeAfterReading);
        }

        public int size() {
            if (this.cachedSize == -1) {
                this.cachedSize = this.streamCharBuffer.size();
            }
            return this.cachedSize;
        }

        public boolean hasCachedSize() {
            return this.cachedSize != -1;
        }

        public StreamCharBuffer getSubBuffer() {
            return this.streamCharBuffer;
        }

        public boolean resetSize() {
            if (this.cachedSize != -1) {
                this.cachedSize = -1;
                return true;
            }
            return false;
        }

        public void subtractFromTotalCount() {
            if (StreamCharBuffer.this.totalCharsInDynamicChunks != -1) {
                StreamCharBuffer.this.totalCharsInDynamicChunks -= this.size();
            }
            StreamCharBuffer.this.dynamicChunkMap.remove(this.streamCharBuffer.bufferKey);
        }
    }

    final class StringChunkReader
    extends AbstractChunkReader {
        StringChunk parent;
        int position;

        public StringChunkReader(StringChunk parent, boolean removeAfterReading) {
            super(parent, removeAfterReading);
            this.parent = parent;
            this.position = parent.offset;
        }

        public int read(char[] ch, int off, int len) {
            this.parent.str.getChars(this.position, this.position + len, ch, off);
            this.position += len;
            return len;
        }

        public int getReadLenLimit(int askedAmount) {
            return Math.min(this.parent.lastposition - this.position, askedAmount);
        }
    }

    final class StringChunk
    extends AbstractChunk {
        String str;
        int offset;
        int lastposition;
        int length;

        public StringChunk(String str, int offset, int length) {
            this.str = str;
            this.offset = offset;
            this.length = length;
            this.lastposition = offset + length;
        }

        public ChunkReader getChunkReader(boolean removeAfterReading) {
            return new StringChunkReader(this, removeAfterReading);
        }

        public void writeTo(Writer target) throws IOException {
            target.write(this.str, this.offset, this.length);
        }

        public int size() {
            return this.length;
        }

        public boolean isSingleBuffer() {
            return this.offset == 0 && this.length == this.str.length();
        }
    }

    final class CharBufferChunkReader
    extends AbstractChunkReader {
        CharBufferChunk parent;
        int pointer;

        public CharBufferChunkReader(CharBufferChunk parent, boolean removeAfterReading) {
            super(parent, removeAfterReading);
            this.parent = parent;
            this.pointer = parent.offset;
        }

        public int read(char[] ch, int off, int len) throws IOException {
            StreamCharBuffer.arrayCopy(this.parent.buffer, this.pointer, ch, off, len);
            this.pointer += len;
            return len;
        }

        public int getReadLenLimit(int askedAmount) {
            return Math.min(this.parent.lastposition - this.pointer, askedAmount);
        }
    }

    abstract class AbstractChunkReader
    extends ChunkReader {
        private AbstractChunk parentChunk;
        private boolean removeAfterReading;

        public AbstractChunkReader(AbstractChunk parentChunk, boolean removeAfterReading) {
            this.parentChunk = parentChunk;
            this.removeAfterReading = removeAfterReading;
        }

        public boolean isValid() {
            return true;
        }

        public ChunkReader next() {
            AbstractChunk nextChunk;
            if (this.removeAfterReading) {
                if (StreamCharBuffer.this.firstChunk == this.parentChunk) {
                    StreamCharBuffer.this.firstChunk = null;
                }
                if (StreamCharBuffer.this.lastChunk == this.parentChunk) {
                    StreamCharBuffer.this.lastChunk = null;
                }
            }
            if ((nextChunk = this.parentChunk.next) != null) {
                if (this.removeAfterReading) {
                    if (StreamCharBuffer.this.firstChunk == null) {
                        StreamCharBuffer.this.firstChunk = nextChunk;
                    }
                    if (StreamCharBuffer.this.lastChunk == null) {
                        StreamCharBuffer.this.lastChunk = nextChunk;
                    }
                    nextChunk.prev = null;
                    nextChunk.subtractFromTotalCount();
                }
                return nextChunk.getChunkReader(this.removeAfterReading);
            }
            return new AllocatedBufferReader(StreamCharBuffer.this.allocBuffer, this.removeAfterReading);
        }

        public int getWriterUsedCounter() {
            return this.parentChunk.getWriterUsedCounter();
        }
    }

    final class CharBufferChunk
    extends AbstractChunk {
        int allocatedBufferId;
        char[] buffer;
        int offset;
        int lastposition;
        int length;

        public CharBufferChunk(int allocatedBufferId, char[] buffer, int offset, int len) {
            this.allocatedBufferId = allocatedBufferId;
            this.buffer = buffer;
            this.offset = offset;
            this.lastposition = offset + len;
            this.length = len;
        }

        public void writeTo(Writer target) throws IOException {
            target.write(this.buffer, this.offset, this.length);
        }

        public ChunkReader getChunkReader(boolean removeAfterReading) {
            return new CharBufferChunkReader(this, removeAfterReading);
        }

        public int size() {
            return this.length;
        }

        public boolean isSingleBuffer() {
            return this.offset == 0 && this.length == this.buffer.length;
        }
    }

    final class AllocatedBuffer {
        private int id;
        private int size;
        private char[] buffer;
        private int used;
        private int chunkStart;

        public AllocatedBuffer(int size) {
            this.id = StreamCharBuffer.this.allocatedBufferIdSequence++;
            this.used = 0;
            this.chunkStart = 0;
            this.size = size;
            this.buffer = new char[size];
        }

        public int charsUsed() {
            return this.used - this.chunkStart;
        }

        public void writeTo(Writer target) throws IOException {
            if (this.used - this.chunkStart > 0) {
                target.write(this.buffer, this.chunkStart, this.used - this.chunkStart);
            }
        }

        public void reuseBuffer() {
            this.used = 0;
            this.chunkStart = 0;
        }

        public int chunkSize() {
            return this.buffer.length;
        }

        public int spaceLeft() {
            return this.size - this.used;
        }

        public boolean write(char ch) {
            if (this.used < this.size) {
                this.buffer[this.used++] = ch;
                return true;
            }
            return false;
        }

        public final void write(char[] ch, int off, int len) {
            StreamCharBuffer.arrayCopy(ch, off, this.buffer, this.used, len);
            this.used += len;
        }

        public final void writeString(String str, int off, int len) {
            str.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public final void writeStringBuilder(StringBuilder stringBuilder, int off, int len) {
            stringBuilder.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public final void writeStringBuffer(StringBuffer stringBuffer, int off, int len) {
            stringBuffer.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public CharBufferChunk createChunk() {
            CharBufferChunk chunk = new CharBufferChunk(this.id, this.buffer, this.chunkStart, this.used - this.chunkStart);
            this.chunkStart = this.used;
            return chunk;
        }

        public boolean hasChunk() {
            return this.used > this.chunkStart;
        }
    }

    static abstract class ChunkReader {
        ChunkReader() {
        }

        public abstract int read(char[] var1, int var2, int var3) throws IOException;

        public abstract int getReadLenLimit(int var1);

        public abstract ChunkReader next();

        public abstract int getWriterUsedCounter();

        public abstract boolean isValid();
    }

    abstract class AbstractChunk {
        AbstractChunk next;
        AbstractChunk prev;
        int writerUsedCounter;

        public AbstractChunk() {
            this.writerUsedCounter = StreamCharBuffer.this.hasReaders ? ((StreamCharBuffer)StreamCharBuffer.this).writer.writerUsedCounter : 1;
        }

        public abstract void writeTo(Writer var1) throws IOException;

        public abstract ChunkReader getChunkReader(boolean var1);

        public abstract int size();

        public int getWriterUsedCounter() {
            return this.writerUsedCounter;
        }

        public void subtractFromTotalCount() {
            StreamCharBuffer.this.totalCharsInList -= this.size();
        }
    }

    public final class StreamCharBufferReader
    extends Reader {
        boolean eofException = false;
        int eofReachedCounter = 0;
        ChunkReader chunkReader;
        ChunkReader lastChunkReader;
        boolean removeAfterReading;

        public StreamCharBufferReader(boolean removeAfterReading) {
            this.removeAfterReading = removeAfterReading;
        }

        private int prepareRead(int len) {
            if (StreamCharBuffer.this.hasReaders && this.eofReachedCounter != 0 && this.eofReachedCounter != ((StreamCharBuffer)StreamCharBuffer.this).writer.writerUsedCounter) {
                this.eofReachedCounter = 0;
                this.eofException = false;
                this.repositionChunkReader();
            }
            if (this.chunkReader == null && this.eofReachedCounter == 0) {
                if (StreamCharBuffer.this.firstChunk != null) {
                    this.chunkReader = StreamCharBuffer.this.firstChunk.getChunkReader(this.removeAfterReading);
                    if (this.removeAfterReading) {
                        StreamCharBuffer.this.firstChunk.subtractFromTotalCount();
                    }
                } else {
                    this.chunkReader = new AllocatedBufferReader(StreamCharBuffer.this.allocBuffer, this.removeAfterReading);
                }
            }
            int available = 0;
            if (this.chunkReader != null) {
                available = this.chunkReader.getReadLenLimit(len);
                while (available == 0 && this.chunkReader != null) {
                    this.chunkReader = this.chunkReader.next();
                    if (this.chunkReader != null) {
                        available = this.chunkReader.getReadLenLimit(len);
                        continue;
                    }
                    available = 0;
                }
            }
            if (this.chunkReader == null) {
                this.eofReachedCounter = StreamCharBuffer.this.hasReaders ? ((StreamCharBuffer)StreamCharBuffer.this).writer.writerUsedCounter : 1;
            } else if (StreamCharBuffer.this.hasReaders) {
                this.lastChunkReader = this.chunkReader;
            }
            return available;
        }

        private void repositionChunkReader() {
            if (this.lastChunkReader instanceof AllocatedBufferReader) {
                if (this.lastChunkReader.isValid()) {
                    this.chunkReader = this.lastChunkReader;
                } else {
                    AllocatedBufferReader allocBufferReader = (AllocatedBufferReader)this.lastChunkReader;
                    int currentPosition = allocBufferReader.position;
                    AbstractChunk chunk = StreamCharBuffer.this.lastChunk;
                    while (chunk != null && chunk.writerUsedCounter >= this.lastChunkReader.getWriterUsedCounter()) {
                        if (chunk instanceof CharBufferChunk) {
                            CharBufferChunk charBufChunk = (CharBufferChunk)chunk;
                            if (charBufChunk.allocatedBufferId == allocBufferReader.parent.id && currentPosition >= charBufChunk.offset && currentPosition <= charBufChunk.lastposition) {
                                CharBufferChunkReader charBufChunkReader = (CharBufferChunkReader)charBufChunk.getChunkReader(this.removeAfterReading);
                                int oldpointer = charBufChunkReader.pointer;
                                charBufChunkReader.pointer = currentPosition;
                                if (this.removeAfterReading) {
                                    int diff = charBufChunkReader.pointer - oldpointer;
                                    StreamCharBuffer.this.totalCharsInList -= diff;
                                    charBufChunk.subtractFromTotalCount();
                                }
                                this.chunkReader = charBufChunkReader;
                                break;
                            }
                        }
                        chunk = chunk.prev;
                    }
                }
            }
        }

        public boolean ready() throws IOException {
            return true;
        }

        public final int read(char[] b, int off, int len) throws IOException {
            return this.readImpl(b, off, len);
        }

        final int readImpl(char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int charsLeft = len;
            int currentOffset = off;
            int readChars = this.prepareRead(charsLeft);
            if (this.eofException) {
                throw new EOFException();
            }
            int totalCharsRead = 0;
            while (charsLeft > 0 && readChars > 0) {
                this.chunkReader.read(b, currentOffset, readChars);
                currentOffset += readChars;
                totalCharsRead += readChars;
                if ((charsLeft -= readChars) <= 0) continue;
                readChars = this.prepareRead(charsLeft);
            }
            if (totalCharsRead > 0) {
                return totalCharsRead;
            }
            this.eofException = true;
            return -1;
        }

        public void close() throws IOException {
        }

        public final StreamCharBuffer getBuffer() {
            return StreamCharBuffer.this;
        }

        public int getReadLenLimit(int askedAmount) {
            return this.prepareRead(askedAmount);
        }
    }

    public final class StreamCharBufferWriter
    extends Writer {
        boolean closed = false;
        int writerUsedCounter = 0;
        boolean increaseCounter = true;

        public final void write(char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.markUsed();
            if (this.shouldWriteDirectly(len)) {
                StreamCharBuffer.this.appendCharBufferChunk(true);
                StreamCharBuffer.this.connectedWritersWriter.write(b, off, len);
            } else {
                int charsLeft = len;
                int currentOffset = off;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace();
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    StreamCharBuffer.this.allocBuffer.write(b, currentOffset, writeChars);
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
            }
        }

        private final boolean shouldWriteDirectly(int len) {
            if (!StreamCharBuffer.this.isConnectedMode()) {
                return false;
            }
            if (StreamCharBuffer.this.writeDirectlyToConnectedMinSize < 0 || len < StreamCharBuffer.this.writeDirectlyToConnectedMinSize) {
                return false;
            }
            return this.isNextChunkBigEnough(len);
        }

        private final boolean isNextChunkBigEnough(int len) {
            return len > this.getNewChunkMinSize();
        }

        private final int getDirectChunkMinSize() {
            if (!StreamCharBuffer.this.isConnectedMode()) {
                return -1;
            }
            if (StreamCharBuffer.this.writeDirectlyToConnectedMinSize >= 0) {
                return StreamCharBuffer.this.writeDirectlyToConnectedMinSize;
            }
            return this.getNewChunkMinSize();
        }

        private final int getNewChunkMinSize() {
            if (StreamCharBuffer.this.chunkMinSize <= 0 || StreamCharBuffer.this.allocBuffer.charsUsed() == 0 || StreamCharBuffer.this.allocBuffer.charsUsed() >= StreamCharBuffer.this.chunkMinSize) {
                return 0;
            }
            return StreamCharBuffer.this.allocBuffer.spaceLeft();
        }

        public final void write(String str) throws IOException {
            this.write(str, 0, str.length());
        }

        public final void write(String str, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            this.markUsed();
            if (this.shouldWriteDirectly(len)) {
                StreamCharBuffer.this.appendCharBufferChunk(true);
                StreamCharBuffer.this.connectedWritersWriter.write(str, off, len);
            } else if (len >= StreamCharBuffer.this.subStringChunkMinSize && this.isNextChunkBigEnough(len)) {
                StreamCharBuffer.this.appendStringChunk(str, off, len);
            } else {
                int charsLeft = len;
                int currentOffset = off;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace();
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    StreamCharBuffer.this.allocBuffer.writeString(str, currentOffset, writeChars);
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
            }
        }

        public final void write(StreamCharBuffer subBuffer) throws IOException {
            this.markUsed();
            int directChunkMinSize = this.getDirectChunkMinSize();
            if (directChunkMinSize != -1 && subBuffer.isSizeLarger(directChunkMinSize)) {
                StreamCharBuffer.this.appendCharBufferChunk(true);
                subBuffer.writeToImpl(StreamCharBuffer.this.connectedWritersWriter, false, false);
            } else if (subBuffer.preferSubChunkWhenWritingToOtherBuffer || subBuffer.isSizeLarger(Math.max(StreamCharBuffer.this.subBufferChunkMinSize, this.getNewChunkMinSize()))) {
                StreamCharBuffer.this.appendStreamCharBufferChunk(subBuffer);
                subBuffer.addParentBuffer(StreamCharBuffer.this);
            } else {
                subBuffer.writeToImpl(this, false, false);
            }
        }

        public final Writer append(CharSequence csq, int start, int end) throws IOException {
            this.markUsed();
            if (csq == null) {
                this.write("null");
            } else if (csq instanceof String || csq instanceof StringBuffer || csq instanceof StringBuilder) {
                int len;
                int charsLeft = len = end - start;
                int currentOffset = start;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace();
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    if (csq instanceof String) {
                        StreamCharBuffer.this.allocBuffer.writeString((String)csq, currentOffset, writeChars);
                    } else if (csq instanceof StringBuffer) {
                        StreamCharBuffer.this.allocBuffer.writeStringBuffer((StringBuffer)csq, currentOffset, writeChars);
                    } else if (csq instanceof StringBuilder) {
                        StreamCharBuffer.this.allocBuffer.writeStringBuilder((StringBuilder)csq, currentOffset, writeChars);
                    }
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
            } else {
                this.write(((Object)csq.subSequence(start, end)).toString());
            }
            return this;
        }

        public final Writer append(CharSequence csq) throws IOException {
            this.markUsed();
            if (csq == null) {
                this.write("null");
            } else {
                this.append(csq, 0, csq.length());
            }
            return this;
        }

        public void close() throws IOException {
            this.closed = true;
            this.flush();
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean isUsed() {
            return this.writerUsedCounter > 0;
        }

        public final void markUsed() {
            if (this.increaseCounter) {
                ++this.writerUsedCounter;
                if (!StreamCharBuffer.this.hasReaders) {
                    this.increaseCounter = false;
                }
            }
        }

        public int resetUsed() {
            int prevUsed = this.writerUsedCounter;
            this.writerUsedCounter = 0;
            this.increaseCounter = true;
            return prevUsed;
        }

        public void write(int b) throws IOException {
            this.markUsed();
            StreamCharBuffer.this.allocateSpace();
            StreamCharBuffer.this.allocBuffer.write((char)b);
        }

        public void flush() throws IOException {
            if (StreamCharBuffer.this.isConnectedMode()) {
                StreamCharBuffer.this.flushToConnected();
            }
            StreamCharBuffer.this.notifyBufferChange();
        }

        public final StreamCharBuffer getBuffer() {
            return StreamCharBuffer.this;
        }
    }

    private class StreamCharBufferKey {
        private StreamCharBufferKey() {
        }

        StreamCharBuffer getBuffer() {
            return StreamCharBuffer.this;
        }
    }
}

