/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import groovy.lang.GroovyObjectSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeConvertingMap
extends GroovyObjectSupport
implements Map,
Cloneable {
    protected Map wrappedMap;

    public AbstractTypeConvertingMap() {
        this(new LinkedHashMap());
    }

    public AbstractTypeConvertingMap(Map map) {
        if (map == null) {
            map = new LinkedHashMap();
        }
        this.wrappedMap = map;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        AbstractTypeConvertingMap thatMap = (AbstractTypeConvertingMap)that;
        if (this.wrappedMap == thatMap.wrappedMap) {
            return true;
        }
        if (this.wrappedMap.size() != thatMap.wrappedMap.size()) {
            return false;
        }
        if (!this.wrappedMap.keySet().equals(thatMap.wrappedMap.keySet())) {
            return false;
        }
        for (Object key : this.wrappedMap.keySet()) {
            Object thisValue = this.wrappedMap.get(key);
            Object thatValue = thatMap.wrappedMap.get(key);
            if (thisValue == null && thatValue != null) {
                return false;
            }
            if (thisValue.equals(thatValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(23, 31);
        for (Map.Entry entry : this.wrappedMap.entrySet()) {
            builder.append(entry);
        }
        return builder.toHashCode();
    }

    public Byte getByte(String name) {
        Object o = this.get(name);
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o != null) {
            try {
                String string = o.toString();
                if (string != null && string.length() > 0) {
                    return Byte.parseByte(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Byte getByte(String name, Integer defaultValue) {
        Byte value = this.getByte(name);
        if (value == null && defaultValue != null) {
            value = (byte)defaultValue.intValue();
        }
        return value;
    }

    public Character getChar(String name) {
        String string;
        Object o = this.get(name);
        if (o instanceof Character) {
            return (Character)o;
        }
        if (o != null && (string = o.toString()) != null && string.length() == 1) {
            return Character.valueOf(string.charAt(0));
        }
        return null;
    }

    public Character getChar(String name, Integer defaultValue) {
        Character value = this.getChar(name);
        if (value == null && defaultValue != null) {
            value = Character.valueOf((char)defaultValue.intValue());
        }
        return value;
    }

    public Integer getInt(String name) {
        Object o = this.get(name);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o != null) {
            try {
                String string = o.toString();
                if (string != null) {
                    return Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Integer getInt(String name, Integer defaultValue) {
        Integer value = this.getInt(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Long getLong(String name) {
        Object o = this.get(name);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o != null) {
            try {
                return Long.parseLong(o.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Long getLong(String name, Long defaultValue) {
        Long value = this.getLong(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Short getShort(String name) {
        Object o = this.get(name);
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o != null) {
            try {
                String string = o.toString();
                if (string != null) {
                    return Short.parseShort(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Short getShort(String name, Integer defaultValue) {
        Short value = this.getShort(name);
        if (value == null && defaultValue != null) {
            value = defaultValue.shortValue();
        }
        return value;
    }

    public Double getDouble(String name) {
        Object o = this.get(name);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o != null) {
            try {
                String string = o.toString();
                if (string != null) {
                    return Double.parseDouble(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Double getDouble(String name, Double defaultValue) {
        Double value = this.getDouble(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Float getFloat(String name) {
        Object o = this.get(name);
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o != null) {
            try {
                String string = o.toString();
                if (string != null) {
                    return Float.valueOf(Float.parseFloat(string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Float getFloat(String name, Float defaultValue) {
        Float value = this.getFloat(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Boolean getBoolean(String name) {
        Object o = this.get(name);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o != null) {
            try {
                String string = o.toString();
                if (string != null) {
                    return Boolean.parseBoolean(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        Boolean value = this.containsKey(name) ? this.getBoolean(name) : defaultValue;
        return value;
    }

    public Date getDate(String name) {
        return this.getDate(name, "yyyy-MM-dd HH:mm:ss.S");
    }

    public Date getDate(String name, String format) {
        Object value = this.get(name);
        if (value != null) {
            try {
                return new SimpleDateFormat(format).parse(value.toString());
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Date date(String name) {
        return this.getDate(name);
    }

    public Date date(String name, String format) {
        return this.getDate(name, format);
    }

    public Date date(String name, Collection<String> formats) {
        return this.getDate(name, formats);
    }

    private Date getDate(String name, Collection<String> formats) {
        for (String format : formats) {
            Date date = this.getDate(name, format);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    public List getList(String name) {
        Object paramValues = this.get(name);
        if (paramValues == null) {
            return Collections.EMPTY_LIST;
        }
        if (paramValues.getClass().isArray()) {
            return Arrays.asList((Object[])paramValues);
        }
        if (paramValues instanceof Collection) {
            return new ArrayList((Collection)paramValues);
        }
        return Collections.singletonList(paramValues);
    }

    public List list(String name) {
        return this.getList(name);
    }

    public Object put(Object k, Object v) {
        return this.wrappedMap.put(k, v);
    }

    public Object remove(Object o) {
        return this.wrappedMap.remove(o);
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.wrappedMap.containsKey(k);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.wrappedMap.containsValue(v);
    }

    public Object get(Object k) {
        return this.wrappedMap.get(k);
    }

    public void putAll(Map m) {
        this.wrappedMap.putAll(m);
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }

    public Set keySet() {
        return this.wrappedMap.keySet();
    }

    public Collection values() {
        return this.wrappedMap.values();
    }

    public Set entrySet() {
        return this.wrappedMap.entrySet();
    }

    public String toString() {
        return DefaultGroovyMethods.toMapString((Map)this);
    }

    public boolean asBoolean() {
        return !this.isEmpty();
    }
}

