/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.errors;

import grails.util.Environment;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.exceptions.DefaultStackTraceFilterer;
import org.codehaus.groovy.grails.exceptions.GrailsRuntimeException;
import org.codehaus.groovy.grails.exceptions.StackTraceFilterer;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.errors.GrailsWrappedRuntimeException;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.GrailsMVCException;
import org.codehaus.groovy.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class GrailsExceptionResolver
extends SimpleMappingExceptionResolver
implements ServletContextAware,
GrailsApplicationAware {
    public static final String EXCEPTION_ATTRIBUTE = "exception";
    protected static final Log LOG = LogFactory.getLog(GrailsExceptionResolver.class);
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected ServletContext servletContext;
    protected GrailsApplication grailsApplication;
    protected StackTraceFilterer stackFilterer;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        request.removeAttribute("org.codehaus.groovy.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE");
        ex = this.findWrappedException(ex);
        this.filterStackTrace(ex);
        ModelAndView mv = super.resolveException(request, response, handler, ex);
        this.setStatus(request, response, mv, ex);
        this.logStackTrace(ex, request);
        UrlMappingsHolder urlMappings = this.lookupUrlMappings();
        if (urlMappings != null) {
            mv = this.resolveViewOrForward(ex, urlMappings, request, response, mv);
        }
        return mv;
    }

    protected void filterStackTrace(Exception e) {
        this.stackFilterer.filter((Throwable)e, true);
    }

    protected void setStatus(HttpServletRequest request, HttpServletResponse response, ModelAndView mv, Exception e) {
        response.setStatus(500);
        request.setAttribute("javax.servlet.error.status_code", (Object)500);
        mv.addObject(EXCEPTION_ATTRIBUTE, (Object)new GrailsWrappedRuntimeException(this.servletContext, e));
    }

    protected UrlMappingsHolder lookupUrlMappings() {
        try {
            return WebUtils.lookupUrlMappings(this.servletContext);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected ModelAndView resolveViewOrForward(Exception ex, UrlMappingsHolder urlMappings, HttpServletRequest request, HttpServletResponse response, ModelAndView mv) {
        UrlMappingInfo info = this.matchStatusCode(ex, urlMappings);
        try {
            if (info != null && info.getViewName() != null) {
                this.resolveView(request, info, mv);
            } else if (info != null && info.getControllerName() != null) {
                String uri = this.determineUri(request);
                if (!response.isCommitted()) {
                    if (response instanceof GrailsContentBufferingResponse) {
                        ((GrailsContentBufferingResponse)response).deactivateSitemesh();
                    }
                    this.forwardRequest(info, request, response, mv, uri);
                    return new ModelAndView();
                }
            }
            return mv;
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to render errors view: " + e.getMessage()), (Throwable)e);
            throw new GrailsRuntimeException((Throwable)e);
        }
    }

    protected void forwardRequest(UrlMappingInfo info, HttpServletRequest request, HttpServletResponse response, ModelAndView mv, String uri) throws ServletException, IOException {
        info.configure(WebUtils.retrieveGrailsWebRequest());
        String forwardUrl = WebUtils.forwardRequestForUrlMappingInfo(request, response, info, mv.getModel());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Matched URI [" + uri + "] to URL mapping [" + info + "], forwarding to [" + forwardUrl + "] with response [" + response.getClass() + "]"));
        }
    }

    protected String determineUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return uri;
    }

    protected void resolveView(HttpServletRequest request, UrlMappingInfo info, ModelAndView mv) throws Exception {
        ViewResolver viewResolver = WebUtils.lookupViewResolver(this.servletContext);
        View v = WebUtils.resolveView(request, info, info.getViewName(), viewResolver);
        if (v != null) {
            mv.setView(v);
        }
    }

    protected UrlMappingInfo matchStatusCode(Exception ex, UrlMappingsHolder urlMappings) {
        UrlMappingInfo info = urlMappings.matchStatusCode(500, ex);
        if (info == null) {
            info = urlMappings.matchStatusCode(500, GrailsExceptionResolver.getRootCause(ex));
        }
        if (info == null) {
            info = urlMappings.matchStatusCode(500);
        }
        return info;
    }

    protected void logStackTrace(Exception e, HttpServletRequest request) {
        LOG.error((Object)this.getRequestLogMessage(e, request), (Throwable)e);
    }

    protected Exception findWrappedException(Exception e) {
        Throwable t;
        if ((e instanceof InvokerInvocationException || e instanceof GrailsMVCException) && (t = GrailsExceptionResolver.getRootCause(e)) instanceof Exception) {
            e = (Exception)t;
        }
        return e;
    }

    public static Throwable getRootCause(Throwable ex) {
        while (ex.getCause() != null && !ex.equals(ex.getCause())) {
            ex = ex.getCause();
        }
        return ex;
    }

    public static int extractLineNumber(CompilationFailedException e) {
        MultipleCompilationErrorsException mcee;
        Object message;
        int lineNumber = -1;
        if (e instanceof MultipleCompilationErrorsException && (message = (mcee = (MultipleCompilationErrorsException)e).getErrorCollector().getErrors().iterator().next()) instanceof SyntaxErrorMessage) {
            SyntaxErrorMessage sem = (SyntaxErrorMessage)message;
            lineNumber = sem.getCause().getLine();
        }
        return lineNumber;
    }

    public static RuntimeException getFirstRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        Throwable ex = e;
        while (ex.getCause() != null && !ex.equals(ex.getCause())) {
            if (!((ex = ex.getCause()) instanceof RuntimeException)) continue;
            return (RuntimeException)ex;
        }
        return null;
    }

    protected String getRequestLogMessage(String exceptionName, HttpServletRequest request, String message) {
        Enumeration params;
        boolean shouldLogRequestParameters;
        Map flatConfig;
        StringBuilder sb = new StringBuilder();
        sb.append(exceptionName).append(" occurred when processing request: ").append("[").append(request.getMethod().toUpperCase()).append("] ");
        if (request.getAttribute("javax.servlet.forward.request_uri") != null) {
            sb.append(request.getAttribute("javax.servlet.forward.request_uri"));
        } else {
            sb.append(request.getRequestURI());
        }
        Map map = flatConfig = this.grailsApplication != null ? this.grailsApplication.getFlatConfig() : Collections.emptyMap();
        if (flatConfig.containsKey("grails.exceptionresolver.logRequestParameters")) {
            shouldLogRequestParameters = Boolean.TRUE.equals(flatConfig.get("grails.exceptionresolver.logRequestParameters"));
        } else {
            boolean bl = shouldLogRequestParameters = Environment.getCurrent() == Environment.DEVELOPMENT;
        }
        if (shouldLogRequestParameters && (params = request.getParameterNames()).hasMoreElements()) {
            sb.append(" - parameters:");
            List blackList = (List)flatConfig.get("grails.exceptionresolver.params.exclude");
            if (blackList == null) {
                blackList = Collections.emptyList();
            }
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                String[] values = request.getParameterValues(param);
                if (values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    sb.append(LINE_SEPARATOR).append(param).append(": ");
                    if (blackList.contains(param)) {
                        sb.append("***");
                        continue;
                    }
                    sb.append(values[i]);
                }
            }
        }
        sb.append(LINE_SEPARATOR);
        if (message != null) {
            sb.append(message).append(". ");
        }
        sb.append("Stacktrace follows:");
        return sb.toString();
    }

    public String getRequestLogMessage(Throwable e, HttpServletRequest request) {
        Throwable cause = GrailsExceptionResolver.getRootCause(e);
        String exceptionName = cause.getClass().getSimpleName();
        return this.getRequestLogMessage(exceptionName, request, cause.getMessage());
    }

    public String getRequestLogMessage(HttpServletRequest request) {
        return this.getRequestLogMessage("Exception", request, null);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
        this.createStackFilterer();
    }

    protected void createStackFilterer() {
        try {
            this.stackFilterer = (StackTraceFilterer)GrailsClassUtils.instantiateFromFlatConfig((Map)this.grailsApplication.getFlatConfig(), (String)"grails.logging.stackTraceFiltererClass", (String)DefaultStackTraceFilterer.class.getName());
        }
        catch (Throwable t) {
            this.logger.error((Object)("Problem instantiating StackTracePrinter class, using default: " + t.getMessage()));
            this.stackFilterer = new DefaultStackTraceFilterer();
        }
    }
}

