/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet;

import grails.util.GrailsWebUtil;
import grails.web.mapping.UrlMappingInfo;
import grails.web.mapping.UrlMappingsHolder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.grails.web.errors.GrailsExceptionResolver;
import org.grails.web.errors.GrailsWrappedRuntimeException;
import org.grails.web.mapping.UrlMappingUtils;
import org.grails.web.servlet.WrappedResponseHolder;
import org.grails.web.servlet.mvc.GrailsDispatcherServlet;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.util.WebUtils;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class ErrorHandlingServlet
extends GrailsDispatcherServlet {
    public static final String UTF_8 = "UTF-8";
    private static final String CONFIG_OPTION_GSP_ENCODING = "grails.views.gsp.encoding";
    private static final long serialVersionUID = 8792197458391395589L;
    private static final String GSP_SUFFIX = ".gsp";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String TEXT_HTML = "text/html";
    private String defaultEncoding = "UTF-8";

    protected void initFrameworkServlet() throws ServletException, BeansException {
        super.initFrameworkServlet();
        String encoding = (String)GrailsWebUtil.lookupApplication((ServletContext)this.getServletContext()).getFlatConfig().get(CONFIG_OPTION_GSP_ENCODING);
        if (encoding != null) {
            this.defaultEncoding = encoding;
        }
    }

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        GrailsWebRequest webRequest;
        if (response.isCommitted()) {
            return;
        }
        int statusCode = request.getAttribute("javax.servlet.error.status_code") != null ? Integer.parseInt(request.getAttribute("javax.servlet.error.status_code").toString()) : 500;
        Throwable t = null;
        if (request.getAttribute("javax.servlet.error.exception") != null && !((t = (Throwable)request.getAttribute("javax.servlet.error.exception")) instanceof GrailsWrappedRuntimeException) && request.getAttribute("exception") == null) {
            request.setAttribute("exception", (Object)new GrailsWrappedRuntimeException(this.getServletContext(), t));
        }
        UrlMappingsHolder urlMappingsHolder = (UrlMappingsHolder)this.getBean("grailsUrlMappingsHolder");
        UrlMappingInfo urlMappingInfo = null;
        if (t != null && (urlMappingInfo = urlMappingsHolder.matchStatusCode(statusCode, t)) == null) {
            urlMappingInfo = urlMappingsHolder.matchStatusCode(statusCode, GrailsExceptionResolver.getRootCause((Throwable)t));
        }
        if (urlMappingInfo == null) {
            urlMappingInfo = urlMappingsHolder.matchStatusCode(statusCode);
        }
        if (urlMappingInfo == null) {
            this.renderDefaultResponse(response, statusCode);
            return;
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        boolean restoreOriginalRequestAttributes = false;
        if (requestAttributes instanceof GrailsWebRequest) {
            webRequest = (GrailsWebRequest)requestAttributes;
            urlMappingInfo.configure(webRequest);
        } else {
            restoreOriginalRequestAttributes = true;
            webRequest = new GrailsWebRequest(request, response, this.getServletContext());
            RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
            urlMappingInfo.configure(webRequest);
        }
        webRequest.removeAttribute("org.grails.GRAILS_CONTROLLER_CLASS_AVAILABLE", 0);
        HttpServletResponse originalResponse = WrappedResponseHolder.getWrappedResponse();
        try {
            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)response);
            String viewName = urlMappingInfo.getViewName();
            if (viewName != null && !viewName.endsWith(GSP_SUFFIX)) {
                if (viewName.endsWith(JSP_SUFFIX)) {
                } else {
                    ViewResolver viewResolver = WebUtils.lookupViewResolver((ServletContext)this.getServletContext());
                    if (viewResolver != null) {
                        try {
                            if (!response.isCommitted()) {
                                response.setContentType("text/html;charset=" + this.defaultEncoding);
                            }
                            View v = UrlMappingUtils.resolveView((HttpServletRequest)request, (UrlMappingInfo)urlMappingInfo, (String)viewName, (ViewResolver)viewResolver);
                            v.render(Collections.EMPTY_MAP, request, response);
                        }
                        catch (Throwable e) {
                            this.renderDefaultResponse(response, statusCode, "Internal Server Error", e.getMessage());
                        }
                    }
                }
            }
        }
        finally {
            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)originalResponse);
            if (restoreOriginalRequestAttributes) {
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
            }
        }
    }

    private void renderDefaultResponse(HttpServletResponse response, int statusCode) throws IOException {
        if (statusCode == 404) {
            this.renderDefaultResponse(response, statusCode, "Not Found", "Page not found.");
        } else {
            this.renderDefaultResponse(response, statusCode, "Internal Error", "Internal server error.");
        }
    }

    private void renderDefaultResponse(HttpServletResponse response, int statusCode, String title, String text) throws IOException {
        response.setStatus(404);
        response.setContentType(TEXT_HTML);
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write("<HTML>\n<HEAD>\n<TITLE>Error " + statusCode + " - " + title);
        ((Writer)writer).write("</TITLE>\n<BODY>\n<H2>Error " + statusCode + " - " + title + ".</H2>\n");
        ((Writer)writer).write(text + "<BR/>");
        for (int i = 0; i < 20; ++i) {
            ((Writer)writer).write("\n<!-- Padding for IE                  -->");
        }
        ((Writer)writer).write("\n</BODY>\n</HTML>\n");
        ((Writer)writer).flush();
    }

    private Object getBean(String name) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return wac.getBean(name);
    }
}

