/* Copyright 2012-2013 SpringSource.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.grails.plugin.cache;

import org.springframework.cache.CacheManager;

/**
 * @author Burt Beckwith
 */
public interface GrailsCacheManager extends CacheManager {

	/**
	 * Whether the cache for the given name exits
	 *
	 * @param name The name of the cache
	 * @return True if it does
	 */
	boolean cacheExists(String name);

	/**
	 * Destroys the given named cache
	 * @param name The name of the cache
	 * @return True if it was destroyed
	 */
	boolean destroyCache(String name);
}
