/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.ObjectMarshaller;
import org.grails.web.json.JSONException;

public class DateMarshaller
implements ObjectMarshaller<JSON> {
    private final Format formatter;

    public DateMarshaller(Format formatter) {
        this.formatter = formatter;
    }

    public DateMarshaller() {
        this((Format)FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US));
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof Date;
    }

    @Override
    public void marshalObject(Object object, JSON converter) throws ConverterException {
        try {
            converter.getWriter().value((Object)this.formatter.format(object));
        }
        catch (JSONException e) {
            throw new ConverterException(e);
        }
    }
}

