/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.databasemigration.liquibase;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.PrintStream;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.InternalGenerateChangelogCommandStep;
import liquibase.command.core.InternalSnapshotCommandStep;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffResult;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.util.StringUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class GroovyGenerateChangeLogCommandStep
extends InternalGenerateChangelogCommandStep
implements GroovyObject {
    public static final String[] COMMAND_NAME;
    private static final String INFO_MESSAGE;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public GroovyGenerateChangeLogCommandStep() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        this.outputBestPracticeMessage();
        String changeLogFile = StringUtil.trimToNull((String)ShortTypeHandling.castToString((Object)commandScope.getArgumentValue(CHANGELOG_FILE_ARG)));
        if (changeLogFile != null && changeLogFile.toLowerCase().endsWith(".sql")) {
            Scope.getCurrentScope().getUI().sendMessage(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\n", (CharSequence)INFO_MESSAGE), (CharSequence)"\n"));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\n", (CharSequence)INFO_MESSAGE), (CharSequence)"\n"));
        }
        Database referenceDatabase = (Database)ScriptBytecodeAdapter.castToType((Object)commandScope.getArgumentValue(REFERENCE_DATABASE_ARG), Database.class);
        InternalSnapshotCommandStep.logUnsupportedDatabase((Database)referenceDatabase, ((Object)((Object)this)).getClass());
        DiffResult diffResult = this.createDiffResult(commandScope);
        DiffToChangeLog changeLogWriter = new DiffToChangeLog(diffResult, (DiffOutputControl)ScriptBytecodeAdapter.castToType((Object)commandScope.getArgumentValue(DIFF_OUTPUT_CONTROL_ARG), DiffOutputControl.class));
        changeLogWriter.setChangeSetAuthor(ShortTypeHandling.castToString((Object)commandScope.getArgumentValue(AUTHOR_ARG)));
        changeLogWriter.setChangeSetContext(ShortTypeHandling.castToString((Object)commandScope.getArgumentValue(CONTEXT_ARG)));
        changeLogWriter.setChangeSetPath(changeLogFile);
        ObjectQuotingStrategy originalStrategy = referenceDatabase.getObjectQuotingStrategy();
        try {
            referenceDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            ChangeLogSerializer serializer = ChangeLogSerializerFactory.getInstance().getSerializer("groovy");
            if (StringUtil.trimToNull((String)changeLogFile) != null) {
                changeLogWriter.print(changeLogFile, serializer);
            } else {
                PrintStream outputStream = new PrintStream(resultsBuilder.getOutputStream());
                try {
                    changeLogWriter.print(outputStream, serializer);
                }
                finally {
                    outputStream.flush();
                }
            }
            if (StringUtil.trimToNull((String)changeLogFile) != null) {
                Scope.getCurrentScope().getUI().sendMessage(StringGroovyMethods.plus((String)"Generated changelog written to ", (CharSequence)new File(changeLogFile).getAbsolutePath()));
            }
        }
        finally {
            referenceDatabase.setObjectQuotingStrategy(originalStrategy);
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GroovyGenerateChangeLogCommandStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        String[] stringArray = new String[]{"groovyGenerateChangeLog"};
        COMMAND_NAME = stringArray;
        INFO_MESSAGE = string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"When generating formatted SQL changelogs, it is important to decide if batched statements\n", (CharSequence)"should be split or not.  For storedlogic objects, the default behavior is 'splitStatements:false'\n."), (CharSequence)"All other objects default to 'splitStatements:true'.  See https://docs.liquibase.org for additional information.");
    }
}

