/*
 * Decompiled with CFR 0.152.
 */
package grails.plugins.mail;

import grails.artefact.Artefact;
import grails.config.Config;
import grails.plugins.mail.MailConfigurationProperties;
import grails.plugins.mail.MailMessageBuilder;
import grails.plugins.mail.MailMessageBuilderFactory;
import grails.plugins.metadata.GrailsPlugin;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.mail.MailMessage;

@GrailsPlugin(name="mail", version="4.0.0")
@Artefact(value="Service")
public class MailService
implements InitializingBean,
DisposableBean,
GroovyObject {
    private MailConfigurationProperties mailConfigurationProperties;
    private MailMessageBuilderFactory mailMessageBuilderFactory;
    private ThreadPoolExecutor mailExecutorService;
    private static final Integer DEFAULT_POOL_SIZE;
    private static final Bindable<MailConfigurationProperties> CONFIG_BINDABLE;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public MailService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public MailMessage sendMail(MailConfigurationProperties properties, @DelegatesTo(strategy=1, value=MailMessageBuilder.class) Closure callable) {
        if (this.isDisabled()) {
            log.warn("Sending emails disabled by configuration option");
            return (MailMessage)ScriptBytecodeAdapter.castToType(null, MailMessage.class);
        }
        MailMessageBuilder messageBuilder = this.mailMessageBuilderFactory.createBuilder(properties);
        MailMessageBuilder mailMessageBuilder = messageBuilder;
        callable.setDelegate((Object)mailMessageBuilder);
        int n = Closure.DELEGATE_FIRST;
        callable.setResolveStrategy(n);
        callable.call((Object)messageBuilder);
        return messageBuilder.sendMessage(this.mailExecutorService);
    }

    public MailMessage sendMail(Config config, @DelegatesTo(strategy=1, value=MailMessageBuilder.class) Closure callable) {
        return this.sendMail(MailService.toMailProperties(config), callable);
    }

    public MailMessage sendMail(@DelegatesTo(strategy=1, value=MailMessageBuilder.class) Closure callable) {
        return this.sendMail(this.mailConfigurationProperties, callable);
    }

    private static MailConfigurationProperties toMailProperties(Config config) {
        PropertiesPropertySource propertySource = new PropertiesPropertySource("mailProperties", config.toProperties());
        Iterable configurationPropertySources = ConfigurationPropertySources.from((PropertySource)propertySource);
        Binder binder = new Binder(configurationPropertySources);
        return (MailConfigurationProperties)ScriptBytecodeAdapter.castToType((Object)binder.bind(MailConfigurationProperties.PREFIX, CONFIG_BINDABLE).get(), MailConfigurationProperties.class);
    }

    public boolean isDisabled() {
        return this.mailConfigurationProperties.isDisabled();
    }

    public void setPoolSize(Integer poolSize) {
        Integer n = poolSize;
        this.mailExecutorService.setMaximumPoolSize(DefaultTypeTransformation.booleanUnbox((Object)n) ? n : DEFAULT_POOL_SIZE);
        Integer n2 = poolSize;
        this.mailExecutorService.setCorePoolSize(DefaultTypeTransformation.booleanUnbox((Object)n2) ? n2 : DEFAULT_POOL_SIZE);
    }

    public void destroy() throws Exception {
        this.mailExecutorService.shutdown();
        this.mailExecutorService.awaitTermination(10, TimeUnit.SECONDS);
    }

    public void afterPropertiesSet() throws Exception {
        ThreadPoolExecutor threadPoolExecutor;
        this.mailExecutorService = threadPoolExecutor = new ThreadPoolExecutor(1, 1, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.mailExecutorService.allowCoreThreadTimeOut(true);
        this.setPoolSize(this.mailConfigurationProperties.getPoolSize());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MailService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        Bindable bindable;
        int n = 5;
        DEFAULT_POOL_SIZE = n;
        CONFIG_BINDABLE = bindable = Bindable.of(MailConfigurationProperties.class);
        log = logger = LoggerFactory.getLogger((String)"grails.plugins.mail.MailService");
    }

    @Generated
    public MailConfigurationProperties getMailConfigurationProperties() {
        return this.mailConfigurationProperties;
    }

    @Generated
    public void setMailConfigurationProperties(MailConfigurationProperties mailConfigurationProperties) {
        this.mailConfigurationProperties = mailConfigurationProperties;
    }

    @Generated
    public MailMessageBuilderFactory getMailMessageBuilderFactory() {
        return this.mailMessageBuilderFactory;
    }

    @Generated
    public void setMailMessageBuilderFactory(MailMessageBuilderFactory mailMessageBuilderFactory) {
        this.mailMessageBuilderFactory = mailMessageBuilderFactory;
    }
}

