/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javafx.beans.value.ObservableValue;
import org.granite.client.javafx.JavaFXProperty;
import org.granite.client.persistence.Id;
import org.granite.client.util.BeanUtil;
import org.granite.client.util.PropertyHolder;
import org.granite.config.ConvertersConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.FieldProperty;
import org.granite.messaging.amf.io.util.MethodProperty;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.DefaultExternalizer;
import org.granite.messaging.annotations.Exclude;
import org.granite.messaging.annotations.Include;
import org.granite.messaging.annotations.Serialized;

public class JavaFXExternalizer
extends DefaultExternalizer {
    private static final Logger log = Logger.getLogger(JavaFXExternalizer.class);

    @Override
    public List<Property> findOrderedFields(Class<?> clazz, boolean returnSettersWhenAvailable) {
        List<Property> fields = (ArrayList)this.orderedFields.get(clazz);
        if (fields == null) {
            PropertyDescriptor[] propertyDescriptors = BeanUtil.getProperties(clazz);
            Converters converters = ((ConvertersConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getConverters();
            fields = new ArrayList();
            HashSet<String> allFieldNames = new HashSet<String>();
            allFieldNames.add("__initialized__");
            allFieldNames.add("__detachedState__");
            allFieldNames.add("__handlerManager");
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                ArrayList<Property> newFields = new ArrayList<Property>();
                for (Field field : c.getDeclaredFields()) {
                    if (!(allFieldNames.contains(field.getName()) || Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || this.isPropertyIgnored(field) || field.isAnnotationPresent(Exclude.class))) {
                        boolean found = false;
                        if (propertyDescriptors != null) {
                            for (PropertyDescriptor pd : propertyDescriptors) {
                                if (!pd.getName().equals(field.getName())) continue;
                                newFields.add(new JavaFXProperty(converters, field.getName(), field, pd.getReadMethod(), pd.getWriteMethod()));
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            if (ObservableValue.class.isAssignableFrom(field.getType())) {
                                newFields.add(new JavaFXProperty(converters, field.getName(), field, null, null));
                            } else {
                                newFields.add(new FieldProperty(converters, field));
                            }
                        }
                    }
                    allFieldNames.add(field.getName());
                }
                if (propertyDescriptors != null) {
                    for (PropertyDescriptor property : propertyDescriptors) {
                        Method getter = property.getReadMethod();
                        if (getter == null || !getter.isAnnotationPresent(Include.class) || !getter.getDeclaringClass().equals(c) || allFieldNames.contains(property.getName())) continue;
                        newFields.add(new MethodProperty(converters, property.getName(), null, getter));
                        allFieldNames.add(property.getName());
                    }
                }
                if (c.isAnnotationPresent(Serialized.class) && c.getAnnotation(Serialized.class).propertiesOrder().length > 0) {
                    final List<String> propertiesOrder = Arrays.asList(c.getAnnotation(Serialized.class).propertiesOrder());
                    Collections.sort(newFields, new Comparator<Property>(){

                        @Override
                        public int compare(Property o1, Property o2) {
                            return propertiesOrder.indexOf(o1.getName()) - propertiesOrder.indexOf(o2.getName());
                        }
                    });
                } else {
                    Collections.sort(newFields, new Comparator<Property>(){

                        @Override
                        public int compare(Property o1, Property o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                }
                fields.addAll(0, newFields);
            }
            List previousFields = (returnSettersWhenAvailable ? this.orderedSetterFields : this.orderedFields).putIfAbsent(clazz, fields);
            if (previousFields != null) {
                fields = previousFields;
            }
        }
        return fields;
    }

    @Override
    public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
        List<Property> fields;
        Field initializedField = null;
        Field detachedStateField = null;
        for (Class<?> clazz = o.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                initializedField = clazz.getDeclaredField("__initialized__");
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            try {
                detachedStateField = clazz.getDeclaredField("__detachedState__");
                continue;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        boolean initialized = true;
        if (initializedField != null && detachedStateField != null) {
            initialized = (Boolean)in.readObject();
            String detachedState = (String)in.readObject();
            initializedField.setAccessible(true);
            initializedField.set(o, initialized);
            detachedStateField.setAccessible(true);
            detachedStateField.set(o, detachedState);
        }
        if (initialized) {
            fields = this.findOrderedFields(o.getClass(), false);
            log.debug("Reading entity %s with fields %s", o.getClass().getName(), fields);
            for (Property field : fields) {
                Object value = in.readObject();
                field.setValue(o, value, true);
            }
        } else {
            fields = this.findOrderedFields(o.getClass(), false);
            log.debug("Reading entity %s with fields %s", o.getClass().getName(), fields);
            for (Property field : fields) {
                if (!field.isAnnotationPresent(Id.class)) continue;
                Object value = in.readObject();
                field.setValue(o, value, true);
            }
        }
    }

    @Override
    public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
        boolean initialized = true;
        String detachedState = null;
        Field initializedField = null;
        Field detachedStateField = null;
        for (Class<?> clazz = o.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                initializedField = clazz.getDeclaredField("__initialized__");
                initializedField.setAccessible(true);
                initialized = initializedField.getBoolean(o);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            try {
                detachedStateField = clazz.getDeclaredField("__detachedState__");
                detachedStateField.setAccessible(true);
                detachedState = (String)detachedStateField.get(o);
                continue;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        if (initializedField != null && detachedStateField != null) {
            if (!initialized) {
                out.writeObject(Boolean.FALSE);
                out.writeObject(detachedState);
                for (Property field : this.findOrderedFields(o.getClass(), false)) {
                    if (!field.isAnnotationPresent(Id.class)) continue;
                    out.writeObject(field.getValue(o));
                    break;
                }
                return;
            }
            out.writeObject(Boolean.TRUE);
            out.writeObject(detachedState);
        }
        List<Property> fields = this.findOrderedFields(o.getClass(), false);
        log.debug("Writing entity %s with fields %s", o.getClass().getName(), fields);
        for (Property field : fields) {
            Object value = field.getValue(o);
            if (value != null && value instanceof PropertyHolder) {
                value = ((PropertyHolder)value).getObject();
            }
            if (this.isValueIgnored(value)) {
                out.writeObject(null);
                continue;
            }
            out.writeObject(value);
        }
    }
}

