/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx;

import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.collections.ObservableSetWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableFloatValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableListValue;
import javafx.beans.value.WritableMapValue;
import javafx.beans.value.WritableSetValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import org.granite.client.javafx.persistence.collection.FXPersistentCollections;
import org.granite.client.persistence.collection.PersistentBag;
import org.granite.client.persistence.collection.PersistentList;
import org.granite.client.persistence.collection.PersistentMap;
import org.granite.client.persistence.collection.PersistentSet;
import org.granite.client.persistence.collection.PersistentSortedMap;
import org.granite.client.persistence.collection.PersistentSortedSet;
import org.granite.client.persistence.collection.UnsafePersistentCollection;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.Property;
import org.granite.util.TypeUtil;

public class JavaFXProperty
extends Property {
    private static final Field observableListWrapperField;
    private static final Field observableSetWrapperField;
    private static final Field observableMapWrapperField;
    private final Field field;
    private final Method setter;
    private final Method getter;

    public JavaFXProperty(Converters converters, String name, Field field, Method getter, Method setter) {
        super(converters, name);
        this.field = field;
        field.setAccessible(true);
        this.setter = setter;
        this.getter = getter;
    }

    @Override
    public void setValue(Object instance, Object value, boolean convert) {
        try {
            Class<?> fieldType = this.field.getType();
            Object convertedValue = value;
            if (WritableValue.class.isAssignableFrom(fieldType)) {
                WritableValue writableValue = (WritableValue)this.field.get(instance);
                convertedValue = writableValue instanceof WritableListValue ? (value instanceof PersistentBag ? FXPersistentCollections.observablePersistentBag((PersistentBag)((Object)value)) : (value instanceof PersistentList ? FXPersistentCollections.observablePersistentList((PersistentList)((Object)value)) : FXCollections.observableList((List)((List)((Object)value))))) : (writableValue instanceof WritableSetValue ? (value instanceof PersistentSortedSet ? FXPersistentCollections.observablePersistentSortedSet((PersistentSortedSet)((Object)value)) : (value instanceof PersistentSet ? FXPersistentCollections.observablePersistentSet((PersistentSet)((Object)value)) : FXCollections.observableSet((Set)((Set)((Object)value))))) : (writableValue instanceof WritableMapValue ? (value instanceof PersistentSortedMap ? FXPersistentCollections.observablePersistentSortedMap((PersistentSortedMap)((Object)value)) : (value instanceof PersistentMap ? FXPersistentCollections.observablePersistentMap((PersistentMap)((Object)value)) : FXCollections.observableMap((Map)((Map)((Object)value))))) : (convert ? this.convert(value) : value)));
                writableValue.setValue(convertedValue);
            } else {
                convertedValue = convert ? this.convert(value) : value;
                this.field.set(instance, convertedValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set value of property " + this.field, e);
        }
    }

    @Override
    public Object getValue(Object instance) {
        try {
            Object fieldValue = this.field.get(instance);
            if (fieldValue instanceof ObservableValue) {
                Object wrappedValue = ((ObservableValue)fieldValue).getValue();
                if (wrappedValue instanceof UnsafePersistentCollection) {
                    return ((UnsafePersistentCollection)wrappedValue).internalPersistentCollection();
                }
                if (wrappedValue instanceof ObservableListWrapper) {
                    return observableListWrapperField.get(wrappedValue);
                }
                if (wrappedValue instanceof ObservableSetWrapper) {
                    return observableSetWrapperField.get(wrappedValue);
                }
                if (wrappedValue instanceof ObservableMapWrapper) {
                    return observableMapWrapperField.get(wrappedValue);
                }
                return wrappedValue;
            }
            return fieldValue;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get value of property " + this.field, e);
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        if (this.getter != null) {
            return this.getter.getDeclaringClass();
        }
        if (this.setter != null) {
            return this.setter.getDeclaringClass();
        }
        return this.field.getDeclaringClass();
    }

    @Override
    public Type getType() {
        Class<?> type = this.field.getType();
        if (ObservableValue.class.isAssignableFrom(type)) {
            if (this.getter != null) {
                return this.getter.getGenericReturnType();
            }
            if (this.setter != null) {
                return this.setter.getGenericParameterTypes()[0];
            }
            if (ObservableBooleanValue.class.isAssignableFrom(type)) {
                return Boolean.TYPE;
            }
            if (ObservableIntegerValue.class.isAssignableFrom(type)) {
                return Integer.TYPE;
            }
            if (ObservableLongValue.class.isAssignableFrom(type)) {
                return Long.TYPE;
            }
            if (ObservableDoubleValue.class.isAssignableFrom(type)) {
                return Double.TYPE;
            }
            if (ObservableFloatValue.class.isAssignableFrom(type)) {
                return Float.TYPE;
            }
            if (ObservableStringValue.class.isAssignableFrom(type)) {
                return String.class;
            }
            if (this.field.getGenericType() instanceof ParameterizedType) {
                return ((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0];
            }
        }
        return type;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass, boolean recursive) {
        if (this.field != null) {
            if (this.field.isAnnotationPresent(annotationClass)) {
                return true;
            }
            if (recursive && TypeUtil.isAnnotationPresent(this.field, annotationClass)) {
                return true;
            }
        }
        if (this.getter != null) {
            if (this.getter.isAnnotationPresent(annotationClass)) {
                return true;
            }
            if (recursive && TypeUtil.isAnnotationPresent(this.getter, annotationClass)) {
                return true;
            }
        }
        if (this.setter != null) {
            if (this.setter.isAnnotationPresent(annotationClass)) {
                return true;
            }
            if (recursive && TypeUtil.isAnnotationPresent(this.setter, annotationClass)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, boolean recursive) {
        TypeUtil.DeclaredAnnotation<T> declaredAnnotation;
        Object annotation = null;
        if (this.field != null && (annotation = this.field.getAnnotation(annotationClass)) == null && recursive && (declaredAnnotation = TypeUtil.getAnnotation(this.field, annotationClass)) != null) {
            annotation = declaredAnnotation.annotation;
        }
        if (this.getter != null && (annotation = this.getter.getAnnotation(annotationClass)) == null && recursive && (declaredAnnotation = TypeUtil.getAnnotation(this.getter, annotationClass)) != null) {
            annotation = declaredAnnotation.annotation;
        }
        if (annotation == null && this.setter != null && (annotation = this.setter.getAnnotation(annotationClass)) == null && recursive && (declaredAnnotation = TypeUtil.getAnnotation(this.setter, annotationClass)) != null) {
            annotation = declaredAnnotation.annotation;
        }
        return null;
    }

    static {
        try {
            observableListWrapperField = ObservableListWrapper.class.getDeclaredField("backingList");
            observableListWrapperField.setAccessible(true);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Could not find backingList field in: " + ObservableListWrapper.class.getName());
        }
        try {
            observableSetWrapperField = ObservableSetWrapper.class.getDeclaredField("backingSet");
            observableSetWrapperField.setAccessible(true);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Could not find backingSet field in: " + ObservableSetWrapper.class.getName());
        }
        try {
            observableMapWrapperField = ObservableMapWrapper.class.getDeclaredField("backingMap");
            observableMapWrapperField.setAccessible(true);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Could not find backingMap field in: " + ObservableMapWrapper.class.getName());
        }
    }
}

