/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.platform;

import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.collections.ObservableSetWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableFloatValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableBooleanValue;
import javafx.beans.value.WritableDoubleValue;
import javafx.beans.value.WritableFloatValue;
import javafx.beans.value.WritableIntegerValue;
import javafx.beans.value.WritableListValue;
import javafx.beans.value.WritableLongValue;
import javafx.beans.value.WritableMapValue;
import javafx.beans.value.WritableSetValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import org.granite.client.javafx.persistence.collection.FXPersistentCollections;
import org.granite.client.javafx.platform.JavaFXProperty;
import org.granite.client.persistence.collection.PersistentBag;
import org.granite.client.persistence.collection.PersistentList;
import org.granite.client.persistence.collection.PersistentMap;
import org.granite.client.persistence.collection.PersistentSet;
import org.granite.client.persistence.collection.PersistentSortedMap;
import org.granite.client.persistence.collection.PersistentSortedSet;
import org.granite.client.persistence.collection.UnsafePersistentCollection;
import org.granite.messaging.reflect.Property;

public abstract class AbstractJavaFXProperty
implements JavaFXProperty {
    private static final Field observableListWrapperField;
    private static final Field observableSetWrapperField;
    private static final Field observableMapWrapperField;
    protected final Property property;

    public AbstractJavaFXProperty(Property property) {
        this.property = property;
    }

    @Override
    public String getName() {
        return this.property.getName();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.property.isAnnotationPresent(annotationClass);
    }

    @Override
    public boolean isReadable() {
        return this.property.isReadable();
    }

    @Override
    public boolean isWritable() {
        return this.property.isWritable();
    }

    @Override
    public Class<?> getType() {
        Class<?> type = this.property.getType();
        if (ObservableValue.class.isAssignableFrom(type)) {
            if (ObservableBooleanValue.class.isAssignableFrom(type)) {
                return Boolean.TYPE;
            }
            if (ObservableIntegerValue.class.isAssignableFrom(type)) {
                return Integer.TYPE;
            }
            if (ObservableLongValue.class.isAssignableFrom(type)) {
                return Long.TYPE;
            }
            if (ObservableDoubleValue.class.isAssignableFrom(type)) {
                return Double.TYPE;
            }
            if (ObservableFloatValue.class.isAssignableFrom(type)) {
                return Float.TYPE;
            }
            if (ObservableStringValue.class.isAssignableFrom(type)) {
                return String.class;
            }
            return Object.class;
        }
        return type;
    }

    @Override
    public boolean getBoolean(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (ObservableBooleanValue.class.isAssignableFrom(this.property.getType())) {
            return ((ObservableBooleanValue)this.property.getObject(holder)).get();
        }
        return this.property.getBoolean(holder);
    }

    @Override
    public char getChar(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (ObservableValue.class.isAssignableFrom(this.property.getType())) {
            throw new UnsupportedOperationException("JavaFX doesn't support char properties");
        }
        return this.property.getChar(holder);
    }

    @Override
    public byte getByte(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (ObservableValue.class.isAssignableFrom(this.property.getType())) {
            throw new UnsupportedOperationException("JavaFX doesn't support byte properties");
        }
        return this.property.getByte(holder);
    }

    @Override
    public short getShort(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (ObservableValue.class.isAssignableFrom(this.property.getType())) {
            throw new UnsupportedOperationException("JavaFX doesn't support short properties");
        }
        return this.property.getShort(holder);
    }

    @Override
    public int getInt(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (ObservableIntegerValue.class.isAssignableFrom(this.property.getType())) {
            return ((ObservableIntegerValue)this.property.getObject(holder)).get();
        }
        return this.property.getInt(holder);
    }

    @Override
    public long getLong(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (ObservableLongValue.class.isAssignableFrom(this.property.getType())) {
            return ((ObservableLongValue)this.property.getObject(holder)).get();
        }
        return this.property.getLong(holder);
    }

    @Override
    public float getFloat(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (ObservableFloatValue.class.isAssignableFrom(this.property.getType())) {
            return ((ObservableFloatValue)this.property.getObject(holder)).get();
        }
        return this.property.getFloat(holder);
    }

    @Override
    public double getDouble(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (ObservableDoubleValue.class.isAssignableFrom(this.property.getType())) {
            return ((ObservableDoubleValue)this.property.getObject(holder)).get();
        }
        return this.property.getDouble(holder);
    }

    @Override
    public Object getRawObject(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object fieldValue = this.property.getObject(holder);
        if (fieldValue instanceof ObservableValue) {
            return ((ObservableValue)fieldValue).getValue();
        }
        return fieldValue;
    }

    @Override
    public Object getObject(Object holder) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object fieldValue = this.property.getObject(holder);
        if (fieldValue instanceof ObservableValue) {
            Object wrappedValue = ((ObservableValue)fieldValue).getValue();
            if (wrappedValue instanceof UnsafePersistentCollection) {
                return ((UnsafePersistentCollection)wrappedValue).internalPersistentCollection();
            }
            if (wrappedValue instanceof ObservableListWrapper) {
                return observableListWrapperField.get(wrappedValue);
            }
            if (wrappedValue instanceof ObservableSetWrapper) {
                return observableSetWrapperField.get(wrappedValue);
            }
            if (wrappedValue instanceof ObservableMapWrapper) {
                return observableMapWrapperField.get(wrappedValue);
            }
            return wrappedValue;
        }
        return fieldValue;
    }

    @Override
    public void setBoolean(Object holder, boolean value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (WritableBooleanValue.class.isAssignableFrom(this.property.getType())) {
            ((WritableBooleanValue)this.property.getObject(holder)).set(value);
        } else {
            this.property.setBoolean(holder, value);
        }
    }

    @Override
    public void setChar(Object holder, char value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (WritableValue.class.isAssignableFrom(this.property.getType())) {
            throw new UnsupportedOperationException("JavaFX doesn't support char properties");
        }
        this.property.setChar(holder, value);
    }

    @Override
    public void setByte(Object holder, byte value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (WritableValue.class.isAssignableFrom(this.property.getType())) {
            throw new UnsupportedOperationException("JavaFX doesn't support byte properties");
        }
        this.property.setByte(holder, value);
    }

    @Override
    public void setShort(Object holder, short value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (WritableValue.class.isAssignableFrom(this.property.getType())) {
            throw new UnsupportedOperationException("JavaFX doesn't support short properties");
        }
        this.property.setShort(holder, value);
    }

    @Override
    public void setInt(Object holder, int value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (WritableIntegerValue.class.isAssignableFrom(this.property.getType())) {
            ((WritableIntegerValue)this.property.getObject(holder)).set(value);
        } else {
            this.property.setInt(holder, value);
        }
    }

    @Override
    public void setLong(Object holder, long value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (WritableLongValue.class.isAssignableFrom(this.property.getType())) {
            ((WritableLongValue)this.property.getObject(holder)).set(value);
        } else {
            this.property.setLong(holder, value);
        }
    }

    @Override
    public void setFloat(Object holder, float value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (WritableFloatValue.class.isAssignableFrom(this.property.getType())) {
            ((WritableFloatValue)this.property.getObject(holder)).set(value);
        } else {
            this.property.setFloat(holder, value);
        }
    }

    @Override
    public void setDouble(Object holder, double value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (WritableDoubleValue.class.isAssignableFrom(this.property.getType())) {
            ((WritableDoubleValue)this.property.getObject(holder)).set(value);
        } else {
            this.property.setDouble(holder, value);
        }
    }

    @Override
    public void setObject(Object holder, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> fieldType = this.property.getType();
        if (WritableValue.class.isAssignableFrom(fieldType)) {
            WritableValue writableValue = (WritableValue)this.property.getObject(holder);
            if (writableValue instanceof WritableListValue) {
                if (value instanceof PersistentBag) {
                    value = FXPersistentCollections.observablePersistentBag((PersistentBag)value);
                } else if (value instanceof PersistentList) {
                    value = FXPersistentCollections.observablePersistentList((PersistentList)value);
                } else if (value != null && !(value instanceof ObservableList)) {
                    value = FXCollections.observableList((List)((List)value));
                }
            } else if (writableValue instanceof WritableSetValue) {
                if (value instanceof PersistentSortedSet) {
                    value = FXPersistentCollections.observablePersistentSortedSet((PersistentSortedSet)value);
                } else if (value instanceof PersistentSet) {
                    value = FXPersistentCollections.observablePersistentSet((PersistentSet)value);
                } else if (value != null && !(value instanceof ObservableSet)) {
                    value = FXCollections.observableSet((Set)((Set)value));
                }
            } else if (writableValue instanceof WritableMapValue) {
                if (value instanceof PersistentSortedMap) {
                    value = FXPersistentCollections.observablePersistentSortedMap((PersistentSortedMap)value);
                } else if (value instanceof PersistentMap) {
                    value = FXPersistentCollections.observablePersistentMap((PersistentMap)value);
                } else if (value != null && !(value instanceof ObservableMap)) {
                    value = FXCollections.observableMap((Map)((Map)value));
                }
            }
            writableValue.setValue(value);
        } else {
            this.property.setObject(holder, value);
        }
    }

    public boolean equals(Object obj) {
        return this.property.equals(obj);
    }

    public int hashCode() {
        return this.property.hashCode();
    }

    public String toString() {
        return this.property.toString();
    }

    static {
        try {
            observableListWrapperField = ObservableListWrapper.class.getDeclaredField("backingList");
            observableListWrapperField.setAccessible(true);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Could not find backingList field in: " + ObservableListWrapper.class.getName());
        }
        try {
            observableSetWrapperField = ObservableSetWrapper.class.getDeclaredField("backingSet");
            observableSetWrapperField.setAccessible(true);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Could not find backingSet field in: " + ObservableSetWrapper.class.getName());
        }
        try {
            observableMapWrapperField = ObservableMapWrapper.class.getDeclaredField("backingMap");
            observableMapWrapperField.setAccessible(true);
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError("Could not find backingMap field in: " + ObservableMapWrapper.class.getName());
        }
    }
}

