/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.util;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.granite.client.javafx.util.ChangeWatcher;

public class ChainedObservableValue<T, P>
implements ObservableValue<P>,
ChangeListener<T>,
ChangeWatcher.Trigger<T, P> {
    private final ObservableValueGetter<T, P> targetObservableValueGetter;
    private ObservableValue<P> targetObservableValue = null;
    private List<ChangeListener<? super P>> changeListeners = new ArrayList<ChangeListener<? super P>>();
    private List<InvalidationListener> invalidationListeners = new ArrayList<InvalidationListener>();
    private ChangeListener<? super P> targetChangeListener = new ChangeListener<P>(){

        public void changed(ObservableValue<? extends P> target, P oldTarget, P newTarget) {
            for (ChangeListener listener : ChainedObservableValue.this.changeListeners) {
                listener.changed(target, oldTarget, newTarget);
            }
        }
    };
    private InvalidationListener targetInvalidationListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            for (InvalidationListener listener : ChainedObservableValue.this.invalidationListeners) {
                listener.invalidated(observable);
            }
        }
    };

    public static <T, P> ChainedObservableValue<T, P> chain(ObservableValue<T> sourceObservableValue, ObservableValueGetter<T, P> targetPropertyGetter) {
        return new ChainedObservableValue<T, P>(sourceObservableValue, targetPropertyGetter);
    }

    public static <T, P> ChainedObservableValue<T, P> chain(ChangeWatcher<T> sourceWatcher, ObservableValueGetter<T, P> targetPropertyGetter) {
        return new ChainedObservableValue<T, P>(sourceWatcher, targetPropertyGetter);
    }

    public ChainedObservableValue(ObservableValue<T> sourceObservableValue, ObservableValueGetter<T, P> targetPropertyGetter) {
        this.targetObservableValueGetter = targetPropertyGetter;
        sourceObservableValue.addListener((ChangeListener)this);
        this.afterChange((T)sourceObservableValue.getValue(), (P)null);
    }

    public ChainedObservableValue(ChangeWatcher<T> sourceWatcher, ObservableValueGetter<T, P> targetPropertyGetter) {
        this.targetObservableValueGetter = targetPropertyGetter;
        sourceWatcher.addTrigger(this);
    }

    public <X> ChainedObservableValue<P, X> chain(ObservableValueGetter<P, X> nextPropertyGetter) {
        return new ChainedObservableValue<P, X>(this, nextPropertyGetter);
    }

    @Override
    public P beforeChange(T oldSource) {
        Object oldValue;
        Object object = oldValue = this.targetObservableValue != null ? this.targetObservableValue.getValue() : null;
        if (this.targetObservableValue != null) {
            this.targetObservableValue.removeListener(this.targetChangeListener);
            this.targetObservableValue.removeListener(this.targetInvalidationListener);
        }
        return (P)oldValue;
    }

    @Override
    public void afterChange(T newSource, P oldValue) {
        Object newValue;
        if (newSource != null) {
            this.targetObservableValue = this.targetObservableValueGetter.getObservableValue(newSource);
        }
        Object object = newValue = this.targetObservableValue != null ? this.targetObservableValue.getValue() : null;
        if (this.targetObservableValue != null) {
            this.targetObservableValue.addListener(this.targetChangeListener);
            this.targetObservableValue.addListener(this.targetInvalidationListener);
        }
        if (newValue != oldValue) {
            this.targetInvalidationListener.invalidated((Observable)this);
            this.targetChangeListener.changed((ObservableValue)this, oldValue, newValue);
        }
    }

    public void changed(ObservableValue<? extends T> source, T oldSource, T newSource) {
        P oldValue = this.beforeChange(oldSource);
        this.afterChange(newSource, oldValue);
    }

    public P getValue() {
        if (this.targetObservableValue == null) {
            return null;
        }
        return (P)this.targetObservableValue.getValue();
    }

    public void addListener(ChangeListener<? super P> listener) {
        this.changeListeners.add(listener);
    }

    public void removeListener(ChangeListener<? super P> listener) {
        this.changeListeners.remove(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.invalidationListeners.remove(listener);
    }

    public static interface ObservableValueGetter<B, T> {
        public ObservableValue<T> getObservableValue(B var1);
    }
}

