/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.util;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.granite.client.javafx.util.ChangeWatcher;

public class ChainedProperty<T, P>
implements Property<P>,
ChangeListener<T>,
ChangeWatcher.Trigger<T, P> {
    private final PropertyGetter<T, P> targetPropertyGetter;
    private Property<P> targetProperty = null;
    private List<ChangeListener<? super P>> changeListeners = new ArrayList<ChangeListener<? super P>>();
    private List<InvalidationListener> invalidationListeners = new ArrayList<InvalidationListener>();
    private ChangeListener<? super P> targetChangeListener = new ChangeListener<P>(){

        public void changed(ObservableValue<? extends P> target, P oldTarget, P newTarget) {
            for (ChangeListener listener : ChainedProperty.this.changeListeners) {
                listener.changed(target, oldTarget, newTarget);
            }
        }
    };
    private InvalidationListener targetInvalidationListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            for (InvalidationListener listener : ChainedProperty.this.invalidationListeners) {
                listener.invalidated(observable);
            }
        }
    };

    public static <T, P> ChainedProperty<T, P> chain(ObservableValue<T> sourceObservableValue, PropertyGetter<T, P> targetPropertyGetter) {
        return new ChainedProperty<T, P>(sourceObservableValue, targetPropertyGetter);
    }

    public static <T, P> ChainedProperty<T, P> chain(ChangeWatcher<T> sourceWatcher, PropertyGetter<T, P> targetPropertyGetter) {
        return new ChainedProperty<T, P>(sourceWatcher, targetPropertyGetter);
    }

    public ChainedProperty(ObservableValue<T> sourceObservableValue, PropertyGetter<T, P> targetPropertyGetter) {
        this.targetPropertyGetter = targetPropertyGetter;
        sourceObservableValue.addListener((ChangeListener)this);
        this.afterChange((T)sourceObservableValue.getValue(), (P)null);
    }

    public ChainedProperty(ChangeWatcher<T> sourceWatcher, PropertyGetter<T, P> targetPropertyGetter) {
        this.targetPropertyGetter = targetPropertyGetter;
        sourceWatcher.addTrigger(this);
    }

    public <X> ChainedProperty<P, X> chain(PropertyGetter<P, X> nextPropertyGetter) {
        return new ChainedProperty<P, X>(this, nextPropertyGetter);
    }

    @Override
    public P beforeChange(T oldSource) {
        Object oldValue;
        Object object = oldValue = this.targetProperty != null ? this.targetProperty.getValue() : null;
        if (this.targetProperty != null) {
            this.targetProperty.removeListener(this.targetChangeListener);
            this.targetProperty.removeListener(this.targetInvalidationListener);
        }
        return (P)oldValue;
    }

    @Override
    public void afterChange(T newSource, P oldValue) {
        Object newValue;
        this.targetProperty = newSource != null ? this.targetPropertyGetter.getProperty(newSource) : null;
        Object object = newValue = this.targetProperty != null ? this.targetProperty.getValue() : null;
        if (this.targetProperty != null) {
            this.targetProperty.addListener(this.targetChangeListener);
            this.targetProperty.addListener(this.targetInvalidationListener);
            if (newValue != oldValue) {
                this.targetInvalidationListener.invalidated((Observable)this);
                this.targetChangeListener.changed((ObservableValue)this, oldValue, newValue);
            }
        }
    }

    public void changed(ObservableValue<? extends T> source, T oldSource, T newSource) {
        P oldValue = this.beforeChange(oldSource);
        this.afterChange(newSource, oldValue);
    }

    public Object getBean() {
        if (this.targetProperty == null) {
            return null;
        }
        return this.targetProperty.getBean();
    }

    public String getName() {
        if (this.targetProperty == null) {
            return null;
        }
        return this.targetProperty.getName();
    }

    public P getValue() {
        if (this.targetProperty == null) {
            return null;
        }
        return (P)this.targetProperty.getValue();
    }

    public void setValue(P value) {
        if (this.targetProperty == null) {
            return;
        }
        this.targetProperty.setValue(value);
    }

    public void addListener(ChangeListener<? super P> listener) {
        this.changeListeners.add(listener);
    }

    public void removeListener(ChangeListener<? super P> listener) {
        this.changeListeners.remove(listener);
    }

    public void addListener(InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.invalidationListeners.remove(listener);
    }

    public void bind(ObservableValue<? extends P> observableValue) {
        throw new UnsupportedOperationException();
    }

    public void bindBidirectional(Property<P> property) {
        throw new UnsupportedOperationException();
    }

    public boolean isBound() {
        throw new UnsupportedOperationException();
    }

    public void unbind() {
        throw new UnsupportedOperationException();
    }

    public void unbindBidirectional(Property<P> property) {
        throw new UnsupportedOperationException();
    }

    public static interface PropertyGetter<B, T> {
        public Property<T> getProperty(B var1);
    }
}

