/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.javafx.util;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class ChangeWatcher<T>
implements ChangeListener<T> {
    private List<Trigger<T, ?>> triggers = new ArrayList();
    private final ObservableValue<T> sourceObservableValue;

    public static <T> ChangeWatcher<T> watch(ObservableValue<T> sourceObservableValue) {
        return new ChangeWatcher<T>(sourceObservableValue);
    }

    public ChangeWatcher(ObservableValue<T> sourceObservableValue) {
        this.sourceObservableValue = sourceObservableValue;
        sourceObservableValue.addListener((ChangeListener)this);
    }

    public void addTrigger(Trigger<T, ?> trigger) {
        this.triggers.add(trigger);
        if (this.sourceObservableValue.getValue() != null) {
            trigger.afterChange(this.sourceObservableValue.getValue(), null);
        }
    }

    public void changed(ObservableValue<? extends T> source, T oldSource, T newSource) {
        Object[] results = new Object[this.triggers.size()];
        int i = 0;
        for (Trigger<T, ?> trigger : this.triggers) {
            results[i++] = trigger.beforeChange(oldSource);
        }
        i = 0;
        for (Trigger<T, ?> trigger : this.triggers) {
            trigger.afterChange(newSource, results[i++]);
        }
    }

    public static interface Trigger<T, X> {
        public X beforeChange(T var1);

        public void afterChange(T var1, X var2);
    }
}

