/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import java.net.URI;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.channel.Credentials;
import org.granite.client.messaging.transport.Transport;

public abstract class AbstractChannel<T extends Transport>
implements Channel {
    protected final T transport;
    protected final String id;
    protected final URI uri;
    protected volatile String clientId;
    protected volatile Credentials credentials = null;
    protected volatile Object transportData = null;

    public AbstractChannel(T transport, String id, URI uri) {
        if (transport == null || id == null || uri == null) {
            throw new NullPointerException("Transport, id and uri must be not null");
        }
        this.transport = transport;
        this.id = id;
        this.uri = uri;
    }

    public T getTransport() {
        return this.transport;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public <D> D getTransportData() {
        return (D)this.transportData;
    }

    @Override
    public void setTransportData(Object data) {
        this.transportData = data;
    }
}

