/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel;

import flex.messaging.messages.Message;
import java.net.URI;
import java.net.URISyntaxException;
import org.granite.client.messaging.ServerApp;
import org.granite.client.messaging.channel.ChannelBuilder;
import org.granite.client.messaging.channel.MessagingChannel;
import org.granite.client.messaging.channel.RemotingChannel;
import org.granite.client.messaging.channel.amf.BaseAMFMessagingChannel;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.client.messaging.transport.Transport;
import org.granite.messaging.amf.AMF0Message;
import org.granite.util.TypeUtil;

public class DefaultChannelBuilder
implements ChannelBuilder {
    private String graniteUrlMapping = "/graniteamf/amf.txt";
    private String gravityUrlMapping = "/gravityamf/amf.txt";
    private String websocketUrlMapping = "/websocketamf/amf";

    public DefaultChannelBuilder() {
    }

    public DefaultChannelBuilder(String graniteUrlMapping, String gravityUrlMapping, String websocketUrlMapping) {
        this.graniteUrlMapping = graniteUrlMapping;
        this.gravityUrlMapping = gravityUrlMapping;
        this.websocketUrlMapping = websocketUrlMapping;
    }

    public void setGraniteUrlMapping(String graniteUrlMapping) {
        this.graniteUrlMapping = graniteUrlMapping;
    }

    public void setGravityUrlMapping(String gravityUrlMapping) {
        this.gravityUrlMapping = gravityUrlMapping;
    }

    public void setWebsocketUrlMapping(String websocketUrlMapping) {
        this.websocketUrlMapping = websocketUrlMapping;
    }

    @Override
    public RemotingChannel buildRemotingChannel(Class<? extends RemotingChannel> channelClass, String id, URI uri, int maxConcurrentRequests, Transport transport, MessagingCodec<AMF0Message> codec) {
        try {
            return TypeUtil.newInstance(channelClass, new Class[]{Transport.class, MessagingCodec.class, String.class, URI.class, Integer.TYPE}, new Object[]{transport, codec, id, uri, maxConcurrentRequests});
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build remoting channel for class " + channelClass, e);
        }
    }

    @Override
    public RemotingChannel buildRemotingChannel(Class<? extends RemotingChannel> channelClass, String id, ServerApp serverApp, int maxConcurrentRequest, Transport transport, MessagingCodec<AMF0Message> codec) {
        String uri = (serverApp.getSecure() ? "https" : "http") + "://" + serverApp.getServerName() + ":" + serverApp.getServerPort() + serverApp.getContextRoot() + this.graniteUrlMapping;
        try {
            return this.buildRemotingChannel(channelClass, id, new URI(uri), maxConcurrentRequest, transport, codec);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad uri: " + uri, e);
        }
    }

    @Override
    public MessagingChannel buildMessagingChannel(String channelType, String id, URI uri, Transport transport, MessagingCodec<Message[]> codec) {
        if (!channelType.startsWith("long-polling") && !channelType.startsWith("websocket")) {
            return null;
        }
        return new BaseAMFMessagingChannel(codec, transport, id, uri);
    }

    @Override
    public MessagingChannel buildMessagingChannel(String channelType, String id, ServerApp serverApp, Transport transport, MessagingCodec<Message[]> codec) {
        String uri;
        if (channelType.startsWith("long-polling")) {
            uri = (serverApp.getSecure() ? "https" : "http") + "://" + serverApp.getServerName() + ":" + serverApp.getServerPort() + serverApp.getContextRoot() + this.gravityUrlMapping;
        } else if (channelType.startsWith("websocket")) {
            uri = (serverApp.getSecure() ? "wss" : "ws") + "://" + serverApp.getServerName() + ":" + serverApp.getServerPort() + serverApp.getContextRoot() + this.websocketUrlMapping;
        } else {
            return null;
        }
        try {
            return this.buildMessagingChannel(channelType, id, new URI(uri), transport, codec);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad uri: " + uri, e);
        }
    }
}

