/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.channel.amf;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.granite.client.messaging.channel.AsyncToken;
import org.granite.client.messaging.channel.RemotingChannel;
import org.granite.client.messaging.channel.amf.AbstractAMFChannel;
import org.granite.client.messaging.codec.JMFAMF0MessagingCodec;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.client.messaging.jmf.ClientSharedContext;
import org.granite.client.messaging.messages.ResponseMessage;
import org.granite.client.messaging.messages.responses.AbstractResponseMessage;
import org.granite.client.messaging.transport.DefaultTransportMessage;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.messaging.amf.AMF0Body;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.AMF3Object;

public class JMFRemotingChannel
extends AbstractAMFChannel
implements RemotingChannel {
    protected final MessagingCodec<AMF0Message> codec;
    protected volatile int index = 1;

    public JMFRemotingChannel(Transport transport, ClientSharedContext sharedContext, String id, URI uri, int maxConcurrentRequests) {
        super(transport, id, uri, maxConcurrentRequests);
        this.codec = new JMFAMF0MessagingCodec(sharedContext);
    }

    public JMFRemotingChannel(Transport transport, MessagingCodec<AMF0Message> codec, String id, URI uri, int maxConcurrentRequests) {
        super(transport, id, uri, maxConcurrentRequests);
        this.codec = codec;
    }

    @Override
    protected TransportMessage createTransportMessage(AsyncToken token) throws UnsupportedEncodingException {
        AMF0Message amf0Message = new AMF0Message();
        for (Message message : this.convertToAmf(token.getRequest())) {
            AMF0Body body = new AMF0Body("", "/" + this.index++, new Object[]{message}, 17);
            amf0Message.addBody(body);
        }
        return new DefaultTransportMessage<AMF0Message>(token.getId(), false, token.isDisconnectRequest(), this.clientId, null, amf0Message, this.codec);
    }

    @Override
    protected ResponseMessage decodeResponse(InputStream is) throws IOException {
        AMF0Message amf0Message = this.codec.decode(is);
        int messagesCount = amf0Message.getBodyCount();
        AbstractResponseMessage response = null;
        AbstractResponseMessage previous = null;
        for (int i = 0; i < messagesCount; ++i) {
            AMF0Body body = amf0Message.getBody(i);
            if (!(body.getValue() instanceof AMF3Object)) {
                throw new RuntimeException("Message should be an AMF3Object: " + body.getValue());
            }
            AMF3Object bodyObject = (AMF3Object)body.getValue();
            if (!(bodyObject.getValue() instanceof AcknowledgeMessage)) {
                throw new RuntimeException("Message should be an AcknowledgeMessage: " + bodyObject.getValue());
            }
            AcknowledgeMessage message = (AcknowledgeMessage)bodyObject.getValue();
            AbstractResponseMessage current = this.convertFromAmf(message);
            if (response == null) {
                response = previous = current;
                continue;
            }
            previous.setNext(current);
            previous = current;
        }
        return response;
    }
}

