/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.codec;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.granite.util.TypeUtil;

class SunConstructorFactory {
    private final Object reflectionFactory;
    private final Method newConstructorForSerialization;

    public SunConstructorFactory() {
        try {
            Class<?> factoryClass = TypeUtil.forName("sun.reflect.ReflectionFactory");
            Method getReflectionFactory = factoryClass.getDeclaredMethod("getReflectionFactory", new Class[0]);
            this.reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            this.newConstructorForSerialization = factoryClass.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Sun Factory", e);
        }
    }

    public <T> Constructor<T> findDefaultConstructor(Class<T> clazz) {
        try {
            Constructor constructor = Object.class.getDeclaredConstructor(new Class[0]);
            constructor = (Constructor)this.newConstructorForSerialization.invoke(this.reflectionFactory, clazz, constructor);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

