/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.messaging.transport.websocket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.transport.AbstractTransport;
import org.granite.client.messaging.transport.TransportException;
import org.granite.client.messaging.transport.TransportFuture;
import org.granite.client.messaging.transport.TransportMessage;
import org.granite.logging.Logger;
import org.granite.util.PublicByteArrayOutputStream;

public abstract class AbstractWebSocketTransport<S>
extends AbstractTransport<Object> {
    private static final Logger log = Logger.getLogger(AbstractWebSocketTransport.class);
    private static final int CLOSE_NORMAL = 1000;
    private static final int CLOSE_SHUTDOWN = 1001;
    private boolean connected = false;
    private boolean disconnecting = false;
    private int maxIdleTime = 3000000;
    private int pingDelay = 30000;
    private int reconnectMaxAttempts = 5;
    private int reconnectIntervalMillis = 60000;
    private int maxMessageSize = 16364;
    private int reconnectAttempts = 0;
    private TransportMessage connectMessage = null;
    private boolean stopping = false;

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setPingDelay(int pingDelay) {
        this.pingDelay = pingDelay;
    }

    public void setReconnectIntervalMillis(int reconnectIntervalMillis) {
        this.reconnectIntervalMillis = reconnectIntervalMillis;
    }

    @Override
    public boolean isReconnectAfterReceive() {
        return false;
    }

    @Override
    public boolean isDisconnectAfterAuthenticationFailure() {
        return true;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransportFuture send(Channel channel, TransportMessage message) {
        TransportData<S> transportData = null;
        boolean pending = false;
        Channel channel2 = channel;
        synchronized (channel2) {
            transportData = (TransportData<S>)channel.getTransportData();
            if (transportData == null) {
                transportData = this.newTransportData();
                channel.setTransportData(transportData);
            }
            if (message != null) {
                if (message.isConnect()) {
                    this.connectMessage = message;
                } else {
                    if (message.isDisconnect()) {
                        this.disconnecting = true;
                    }
                    pending = true;
                }
            }
        }
        if (!transportData.isConnected() && !this.disconnecting) {
            this.connected = true;
            this.connect(channel, message);
            return null;
        }
        if (pending) {
            ((TransportData)transportData).pendingMessages.addLast(message);
        }
        channel2 = channel;
        synchronized (channel2) {
            while (!((TransportData)transportData).pendingMessages.isEmpty()) {
                TransportMessage pendingMessage = (TransportMessage)((TransportData)transportData).pendingMessages.removeFirst();
                try {
                    PublicByteArrayOutputStream os = new PublicByteArrayOutputStream(256);
                    pendingMessage.encode(os);
                    transportData.sendBytes(os.getBytes());
                }
                catch (IOException e) {
                    ((TransportData)transportData).pendingMessages.addFirst(pendingMessage);
                    break;
                }
            }
        }
        return null;
    }

    protected abstract TransportData<S> newTransportData();

    public abstract void connect(Channel var1, TransportMessage var2);

    protected void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnect(Channel channel, S connection) {
        Channel channel2 = channel;
        synchronized (channel2) {
            this.reconnectAttempts = 0;
            ((TransportData)channel.getTransportData()).connect(connection);
        }
        this.send(channel, null);
    }

    protected void onBinaryMessage(Channel channel, byte[] data, int offset, int length) {
        channel.onMessage(this.connectMessage, new ByteArrayInputStream(data, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onClose(Channel channel, int closeCode, String message) {
        boolean waitBeforeReconnect;
        log.info("Websocket connection closed %d %s channel %s", closeCode, message, channel.getClientId());
        boolean bl = waitBeforeReconnect = closeCode != 1000 || message == null || !message.startsWith("Idle");
        if (channel.getTransportData() != null) {
            ((TransportData)channel.getTransportData()).disconnect();
            channel.setTransportData(null);
        }
        if (this.stopping || !this.isStarted()) {
            log.debug("Websocket connection marked as disconnected", new Object[0]);
            this.connected = false;
        } else if (closeCode != 1001 && channel.getClientId() == null) {
            log.debug("Websocket connection could not connect", new Object[0]);
            this.getStatusHandler().handleException(new TransportException("Transport could not connect code: " + closeCode + " " + message));
            return;
        }
        if (this.disconnecting) {
            channel.onDisconnect();
            this.disconnecting = false;
            this.connected = false;
        }
        if (this.connected) {
            Channel channel2 = channel;
            synchronized (channel2) {
                if (waitBeforeReconnect || this.reconnectAttempts >= this.reconnectMaxAttempts) {
                    this.connected = false;
                    log.debug("Websocket disconnected", new Object[0]);
                    channel.onError(this.connectMessage, new RuntimeException(message + " (code=" + closeCode + ")"));
                    this.getStatusHandler().handleException(new TransportException("Transport disconnected"));
                    return;
                }
                ++this.reconnectAttempts;
                log.info("Connection lost (code %d, msg %s), reconnect channel (retry #%d)", closeCode, message, this.reconnectAttempts);
                this.connected = true;
                this.connect(channel, this.connectMessage);
            }
        }
    }

    protected void onError(Channel channel, Throwable throwable) {
        log.error(throwable, "Websocket connection error", new Object[0]);
        channel.onError(this.connectMessage, new RuntimeException("Websocket connection error", throwable));
        this.getStatusHandler().handleException(new TransportException("Websocket connection error: " + throwable.getMessage()));
    }

    public static abstract class TransportData<S> {
        private final LinkedList<TransportMessage> pendingMessages = new LinkedList();

        public abstract void connect(S var1);

        public abstract boolean isConnected();

        public abstract void disconnect();

        public abstract void sendBytes(byte[] var1) throws IOException;
    }
}

