/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.granite.client.persistence.Entity;
import org.granite.client.persistence.Id;
import org.granite.client.persistence.Lazy;
import org.granite.client.persistence.Uid;
import org.granite.client.persistence.Version;
import org.granite.client.persistence.collection.PersistentCollection;
import org.granite.messaging.reflect.Property;
import org.granite.messaging.reflect.PropertyAccessException;
import org.granite.messaging.reflect.PropertyNotFoundException;
import org.granite.messaging.reflect.Reflection;

public class Persistence {
    private static final String INITIALIZED_FIELD_NAME = "__initialized__";
    private static final String DETACHED_STATE_FIELD_NAME = "__detachedState__";
    private final Reflection reflection;

    public Persistence(Reflection reflection) {
        this.reflection = reflection;
    }

    public boolean isEntity(Class<?> cls) {
        return cls != null && cls.isAnnotationPresent(Entity.class);
    }

    protected void checkEntity(Class<?> entityClass) {
        if (!this.isEntity(entityClass)) {
            throw new PropertyNotFoundException("Not annotated with @" + Entity.class.getName() + ": " + entityClass);
        }
    }

    protected Property getInitializedProperty(Class<?> entityClass, boolean throwIfNotFound) {
        this.checkEntity(entityClass);
        Property property = this.reflection.findProperty(entityClass, INITIALIZED_FIELD_NAME, Boolean.TYPE);
        if (property == null && throwIfNotFound) {
            throw new PropertyNotFoundException("No boolean __initialized__ property in " + entityClass);
        }
        return property;
    }

    public Property getInitializedProperty(Class<?> entityClass) {
        return this.getInitializedProperty(entityClass, false);
    }

    public boolean hasInitializedProperty(Class<?> entityClass) {
        return this.getInitializedProperty(entityClass, false) != null;
    }

    public boolean isInitialized(Object o) {
        if (o instanceof PersistentCollection) {
            return ((PersistentCollection)o).wasInitialized();
        }
        Class<?> cls = o.getClass();
        if (!this.isEntity(cls)) {
            return true;
        }
        Property property = this.getInitializedProperty(cls, false);
        if (property == null) {
            return true;
        }
        try {
            return property.getBoolean(o);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not get " + property + " of object " + o, e);
        }
    }

    public void setInitialized(Object entity, boolean value) {
        Property property = this.getInitializedProperty(entity.getClass(), true);
        try {
            property.setBoolean(entity, value);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not set " + property + " of object " + entity + " to value " + value, e);
        }
    }

    protected Property getDetachedStateProperty(Class<?> entityClass, boolean throwIfNotFound) {
        this.checkEntity(entityClass);
        Property property = this.reflection.findProperty(entityClass, DETACHED_STATE_FIELD_NAME, String.class);
        if (property == null && throwIfNotFound) {
            throw new PropertyNotFoundException("No String __detachedState__ property in " + entityClass);
        }
        return property;
    }

    public Property getDetachedStateProperty(Class<?> entityClass) {
        return this.getDetachedStateProperty(entityClass, false);
    }

    public boolean hasDetachedStateProperty(Class<?> entityClass) {
        return this.getDetachedStateProperty(entityClass, false) != null;
    }

    public String getDetachedState(Object entity) {
        Property property = this.getDetachedStateProperty(entity.getClass(), true);
        try {
            return (String)property.getObject(entity);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not get " + property + " of object " + entity, e);
        }
    }

    public void setDetachedState(Object entity, String value) {
        Property property = this.getDetachedStateProperty(entity.getClass(), true);
        try {
            property.setObject(entity, value);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not set " + property + " of object " + entity + " to value " + value, e);
        }
    }

    protected Property getIdProperty(Class<?> entityClass, boolean throwIfNotFound) {
        this.checkEntity(entityClass);
        Property property = this.reflection.findProperty(entityClass, Id.class);
        if (property == null && throwIfNotFound) {
            throw new PropertyNotFoundException("No property annotated with " + Id.class.getName() + " in " + entityClass);
        }
        return property;
    }

    public Property getIdProperty(Class<?> entityClass) {
        return this.getIdProperty(entityClass, false);
    }

    public boolean hasIdProperty(Class<?> entityClass) {
        return this.getIdProperty(entityClass, false) != null;
    }

    public <T> T getId(Object entity) {
        Property property = this.getIdProperty(entity.getClass(), true);
        try {
            return (T)property.getObject(entity);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not get " + property + " of object " + entity, e);
        }
    }

    public void setId(Object entity, Object value) {
        Property property = this.getIdProperty(entity.getClass(), true);
        try {
            property.setObject(entity, value);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not set " + property + " of object " + entity + " to value " + value, e);
        }
    }

    protected Property getUidProperty(Class<?> entityClass, boolean throwIfNotFound) {
        this.checkEntity(entityClass);
        Property property = this.reflection.findProperty(entityClass, Uid.class);
        if (property == null && throwIfNotFound) {
            throw new PropertyNotFoundException("No property annotated with " + Uid.class.getName() + " in " + entityClass);
        }
        return property;
    }

    public Property getUidProperty(Class<?> entityClass) {
        return this.getUidProperty(entityClass, false);
    }

    public boolean hasUidProperty(Class<?> entityClass) {
        return this.getUidProperty(entityClass, false) != null;
    }

    public String getUid(Object entity) {
        Property property = this.getUidProperty(entity.getClass(), true);
        try {
            return (String)property.getObject(entity);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not get " + property + " of object " + entity, e);
        }
    }

    public void setUid(Object entity, String value) {
        Property property = this.getUidProperty(entity.getClass(), true);
        try {
            property.setObject(entity, value);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not set " + property + " of object " + entity + " to value " + value, e);
        }
    }

    protected Property getVersionProperty(Class<?> entityClass, boolean throwIfNotFound) {
        this.checkEntity(entityClass);
        Property property = this.reflection.findProperty(entityClass, Version.class);
        if (property == null && throwIfNotFound) {
            throw new PropertyNotFoundException("No property annotated with " + Version.class.getName() + " in " + entityClass);
        }
        return property;
    }

    public Property getVersionProperty(Class<?> entityClass) {
        return this.getVersionProperty(entityClass, false);
    }

    public boolean hasVersionProperty(Class<?> entityClass) {
        return this.getVersionProperty(entityClass, false) != null;
    }

    public <T> T getVersion(Object entity) {
        Property property = this.getVersionProperty(entity.getClass(), true);
        try {
            return (T)property.getObject(entity);
        }
        catch (Exception e) {
            throw new PropertyAccessException("Could not get " + property + " of object " + entity, e);
        }
    }

    public List<Property> getLazyProperties(Class<?> entityClass) {
        List<Property> properties = this.reflection.findSerializableProperties(entityClass);
        ArrayList<Property> lazyProperties = new ArrayList<Property>();
        for (Property property : properties) {
            if (!property.isAnnotationPresent(Lazy.class)) continue;
            lazyProperties.add(property);
        }
        return lazyProperties;
    }

    public List<Property> getProperties(Class<?> entityClass) {
        return this.reflection.findSerializableProperties(entityClass);
    }

    public Object getPropertyValue(Object entity, String name, boolean raw) {
        Property property = this.reflection.findSerializableProperty(entity.getClass(), name);
        if (property == null) {
            throw new RuntimeException("Property " + name + " not found on object " + entity);
        }
        try {
            return raw ? property.getRawObject(entity) : property.getObject(entity);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get " + property + " of object " + entity, e);
        }
    }

    public void setPropertyValue(Object entity, String name, Object value) {
        Property property = this.reflection.findSerializableProperty(entity.getClass(), name);
        if (property == null) {
            throw new RuntimeException("Property " + name + " not found on object " + entity);
        }
        try {
            property.setObject(entity, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set " + property + " of object " + entity, e);
        }
    }

    public Map<String, Object> getPropertyValues(Object entity, boolean raw, boolean excludeIdUid, boolean excludeVersion, boolean includeReadOnly) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        List<Property> properties = this.reflection.findSerializableProperties(entity.getClass());
        ArrayList<Property> excludedProperties = new ArrayList<Property>();
        if (this.isEntity(entity.getClass())) {
            excludedProperties.add(this.getInitializedProperty(entity.getClass()));
            excludedProperties.add(this.getDetachedStateProperty(entity.getClass()));
            if (excludeIdUid && this.hasIdProperty(entity.getClass())) {
                excludedProperties.add(this.getIdProperty(entity.getClass()));
            }
            if (excludeIdUid && this.hasUidProperty(entity.getClass())) {
                excludedProperties.add(this.getUidProperty(entity.getClass()));
            }
            if (excludeVersion && this.hasVersionProperty(entity.getClass())) {
                excludedProperties.add(this.getVersionProperty(entity.getClass()));
            }
        }
        for (Property property : properties) {
            if (excludedProperties.contains(property) || !includeReadOnly && !property.isWritable()) continue;
            try {
                values.put(property.getName(), raw ? property.getRawObject(entity) : property.getObject(entity));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get property " + property.getName() + " on entity " + entity, e);
            }
        }
        return values;
    }
}

