/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.util.Collection;
import java.util.Map;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;
import org.granite.util.ContentType;
import org.granite.util.TypeUtil;

public abstract class PersistentCollectionSnapshotFactory {
    public static PersistentCollectionSnapshotFactory newInstance(Object io) {
        if (io.getClass().getSimpleName().startsWith("AMF3")) {
            return PersistentCollectionSnapshotFactory.newInstance(ContentType.AMF);
        }
        return PersistentCollectionSnapshotFactory.newInstance(ContentType.JMF_AMF);
    }

    public static PersistentCollectionSnapshotFactory newInstance(ContentType contentType) {
        try {
            switch (contentType) {
                case JMF_AMF: {
                    return TypeUtil.newInstance("org.granite.client.messaging.jmf.persistence.JMFPersistentCollectionSnapshotFactory", PersistentCollectionSnapshotFactory.class);
                }
                case AMF: {
                    return TypeUtil.newInstance("org.granite.client.messaging.amf.persistence.AMFPersistentCollectionSnapshotFactory", PersistentCollectionSnapshotFactory.class);
                }
            }
            throw new UnsupportedOperationException("Unsupported content type: " + (Object)((Object)contentType));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create collection snapshot factory: " + (Object)((Object)contentType), e);
        }
    }

    public abstract PersistentCollectionSnapshot newPersistentCollectionSnapshot(String var1);

    public abstract PersistentCollectionSnapshot newPersistentCollectionSnapshot(boolean var1, String var2);

    public abstract PersistentCollectionSnapshot newPersistentCollectionSnapshot(boolean var1, String var2, boolean var3, Collection<?> var4);

    public abstract PersistentCollectionSnapshot newPersistentCollectionSnapshot(boolean var1, String var2, boolean var3, Map<?, ?> var4);
}

