/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.persistence.collection;

import java.io.ObjectInput;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.granite.client.persistence.collection.AbstractPersistentCollection;
import org.granite.client.persistence.collection.AbstractPersistentMapCollection;
import org.granite.client.persistence.collection.PersistentCollectionSnapshotFactory;
import org.granite.client.persistence.collection.PersistentSortedCollection;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;

public class PersistentSortedMap<K, V>
extends AbstractPersistentMapCollection<K, V, SortedMap<K, V>>
implements SortedMap<K, V>,
PersistentSortedCollection<SortedMap<K, V>, K> {
    private static final long serialVersionUID = 1L;

    public PersistentSortedMap() {
    }

    public PersistentSortedMap(boolean initialized) {
        this(initialized ? new TreeMap() : null, false);
    }

    public PersistentSortedMap(SortedMap<K, V> collection) {
        this(collection, true);
    }

    public PersistentSortedMap(SortedMap<K, V> collection, boolean clone) {
        if (collection != null) {
            this.init(clone ? new TreeMap(collection) : collection, null, false);
        }
    }

    @Override
    public void doInitialize(SortedMap<K, V> sortedMap, boolean empty) {
        this.init(empty ? new TreeMap(sortedMap.comparator()) : sortedMap, null, false);
    }

    @Override
    public Comparator<? super K> comparator() {
        return ((SortedMap)this.getCollection()).comparator();
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return new AbstractPersistentCollection.SortedMapProxy(((SortedMap)this.getCollection()).subMap(fromKey, toKey));
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return new AbstractPersistentCollection.SortedMapProxy(((SortedMap)this.getCollection()).headMap(toKey));
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return new AbstractPersistentCollection.SortedMapProxy(((SortedMap)this.getCollection()).tailMap(fromKey));
    }

    @Override
    public K firstKey() {
        if (!this.checkInitializedRead()) {
            return null;
        }
        return ((SortedMap)this.getCollection()).firstKey();
    }

    @Override
    public K lastKey() {
        this.checkInitializedRead();
        return ((SortedMap)this.getCollection()).lastKey();
    }

    @Override
    protected PersistentCollectionSnapshot createSnapshot(Object io, boolean forReading) {
        PersistentCollectionSnapshotFactory factory = PersistentCollectionSnapshotFactory.newInstance(io);
        if (forReading || !this.wasInitialized()) {
            return factory.newPersistentCollectionSnapshot(true, this.getDetachedState());
        }
        return factory.newPersistentCollectionSnapshot(true, this.getDetachedState(), this.isDirty(), this);
    }

    @Override
    protected void updateFromSnapshot(ObjectInput in, PersistentCollectionSnapshot snapshot) {
        if (snapshot.isInitialized()) {
            Comparator comparator = null;
            try {
                comparator = snapshot.newComparator(in);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create instance of comparator", e);
            }
            TreeMap map = new TreeMap(comparator);
            map.putAll(snapshot.getElementsAsMap());
            this.init(map, snapshot.getDetachedState(), snapshot.isDirty());
        } else {
            this.init(null, snapshot.getDetachedState(), false);
        }
    }

    public PersistentSortedMap<K, V> clone(boolean uninitialize) {
        PersistentSortedMap<K, V> map = new PersistentSortedMap<K, V>();
        if (this.wasInitialized() && !uninitialize) {
            map.init(this.getCollection(), null, this.isDirty());
        }
        return map;
    }
}

