/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.platform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.granite.client.configuration.ClassScanner;
import org.granite.client.configuration.Configuration;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.persistence.Persistence;
import org.granite.client.platform.PlatformConfigurationError;
import org.granite.logging.Logger;
import org.granite.messaging.reflect.Reflection;
import org.granite.util.ServiceLoader;
import org.granite.util.TypeUtil;

public class Platform {
    private static final Logger log = Logger.getLogger(Platform.class);
    public static final String SYSTEM_PROPERTY_KEY = Platform.class.getName();
    protected static Platform instance = null;
    protected final Reflection reflection;
    protected final Persistence persistence;
    protected Object context;

    public static synchronized Platform getInstance() {
        if (instance == null) {
            String platformClassName = System.getProperty(SYSTEM_PROPERTY_KEY);
            if (platformClassName == null) {
                Platform.initInstance((ClassLoader)null);
            }
            if (instance == null) {
                Platform.initInstance(platformClassName, null);
            }
        }
        return instance;
    }

    public static synchronized Platform initInstance(ClassLoader platformClassLoader) {
        if (instance != null) {
            throw new IllegalStateException("Platform already loaded");
        }
        if (platformClassLoader == null) {
            platformClassLoader = Thread.currentThread().getContextClassLoader();
        }
        ServiceLoader<Platform> platformLoader = ServiceLoader.load(Platform.class, platformClassLoader);
        Iterator platforms = null;
        try {
            platforms = platformLoader.iterator();
            if (platforms.hasNext()) {
                instance = (Platform)platforms.next();
            }
            if (platforms.hasNext()) {
                throw new PlatformConfigurationError("Multiple Platform services: " + instance + " / " + platforms.next());
            }
        }
        catch (PlatformConfigurationError e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PlatformConfigurationError("Could not load Platform service", t);
        }
        return instance;
    }

    public static synchronized Platform initInstance(String platformClassName) {
        return Platform.initInstance(platformClassName, null);
    }

    public static synchronized Platform initInstance(String platformClassName, ClassLoader platformClassLoader) {
        return Platform.initInstance(platformClassName, platformClassLoader, null);
    }

    public static synchronized Platform initInstance(String platformClassName, ClassLoader platformClassLoader, ClassLoader reflectionClassLoader) {
        if (instance != null) {
            throw new IllegalStateException("Platform already loaded");
        }
        if (platformClassLoader == null) {
            platformClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (platformClassName == null) {
            platformClassName = Platform.class.getName();
        }
        try {
            Class<?> platformClass = platformClassLoader.loadClass(platformClassName);
            instance = (Platform)platformClass.getConstructor(ClassLoader.class).newInstance(reflectionClassLoader);
        }
        catch (Throwable t) {
            throw new PlatformConfigurationError("Could not create new Platform of type: " + platformClassName, t);
        }
        return instance;
    }

    public Platform() {
        this(new Reflection(null));
    }

    public Platform(ClassLoader reflectionClassLoader) {
        this(new Reflection(reflectionClassLoader));
    }

    public Platform(Reflection reflection) {
        if (reflection == null) {
            throw new NullPointerException("reflection cannot be null");
        }
        this.reflection = reflection;
        this.persistence = new Persistence(reflection);
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public ClassScanner newClassScanner() {
        String scannerClassName = System.getProperty("scanner.className");
        if (scannerClassName != null) {
            try {
                return TypeUtil.newInstance(scannerClassName, ClassScanner.class);
            }
            catch (Throwable t) {
                throw new RuntimeException("Specified scanner class " + scannerClassName + " not available", t);
            }
        }
        try {
            return TypeUtil.newInstance("org.granite.client.scan.ExtCosClassScanner", ClassScanner.class);
        }
        catch (Throwable t) {
            log.debug(t, "Extcos scanner not available, using classpath scanner", new Object[0]);
            try {
                return TypeUtil.newInstance("org.granite.client.scan.StandardClassScanner", ClassScanner.class);
            }
            catch (Throwable t2) {
                throw new RuntimeException("Could not create class scanner", t2);
            }
        }
    }

    public Reflection getReflection() {
        return this.reflection;
    }

    public Configuration newConfiguration() {
        try {
            return TypeUtil.newInstance("org.granite.client.configuration.SimpleConfiguration", Configuration.class);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not create simple configuration", t);
        }
    }

    public String defaultChannelType() {
        return "long-polling";
    }

    public Transport newRemotingTransport() {
        try {
            return TypeUtil.newInstance("org.granite.client.messaging.transport.apache.ApacheAsyncTransport", Transport.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Apache transport");
        }
    }

    public Transport newMessagingTransport() {
        return null;
    }

    public Map<String, Transport> getMessagingTransports() {
        HashMap<String, Transport> transportMap = new HashMap<String, Transport>();
        try {
            TypeUtil.forName("org.eclipse.jetty.websocket.jsr356.JettyClientContainerProvider");
            transportMap.put("websocket", TypeUtil.newInstance("org.granite.client.messaging.transport.jetty9.JettyStdWebSocketTransport", Transport.class));
        }
        catch (Throwable e1) {
            try {
                TypeUtil.forName("org.eclipse.jetty.websocket.client.WebSocketClient");
                transportMap.put("websocket", TypeUtil.newInstance("org.granite.client.messaging.transport.jetty9.JettyStdWebSocketTransport", Transport.class));
            }
            catch (Throwable e2) {
                try {
                    TypeUtil.forName("org.eclipse.jetty.websocket.WebSocketClientFactory");
                    transportMap.put("websocket", TypeUtil.newInstance("org.granite.client.messaging.transport.jetty.JettyWebSocketTransport", Transport.class));
                }
                catch (Throwable e3) {
                    try {
                        TypeUtil.forName("org.glassfish.tyrus.client.ClientManager");
                        transportMap.put("websocket", TypeUtil.newInstance("org.granite.client.messaging.transport.tyrus.TyrusWebSocketTransport", Transport.class));
                    }
                    catch (Throwable e4) {
                        // empty catch block
                    }
                }
            }
        }
        return transportMap;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public static Reflection reflection() {
        return Platform.getInstance().reflection;
    }

    public static Persistence persistence() {
        return Platform.getInstance().persistence;
    }
}

