/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.granite.config.AMF3Config;
import org.granite.config.ExternalizersConfig;
import org.granite.config.api.AliasRegistryConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.AliasRegistry;
import org.granite.messaging.amf.io.AMF3Constants;
import org.granite.messaging.amf.io.AMF3DeserializerSecurizer;
import org.granite.messaging.amf.io.util.ActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.DefaultActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.instantiator.AbstractInstantiator;
import org.granite.util.TypeUtil;
import org.granite.util.XMLUtil;
import org.granite.util.XMLUtilFactory;
import org.w3c.dom.Document;

public class AMF3Deserializer
implements ObjectInput,
AMF3Constants {
    protected final List<String> storedStrings;
    protected final List<Object> storedObjects;
    protected final List<ActionScriptClassDescriptor> storedClassDescriptors;
    protected Map<String, Document> documentCache;
    protected final AliasRegistry aliasRegistry;
    protected final ExternalizersConfig externalizersConfig;
    protected final AMF3DeserializerSecurizer securizer;
    protected final XMLUtil xmlUtil;
    private final InputStream in;
    private final byte[] buffer;
    private int position;
    private int size;

    public AMF3Deserializer(InputStream in) {
        this(in, 1024);
    }

    public AMF3Deserializer(InputStream in, int capacity) {
        this.in = in;
        this.buffer = new byte[capacity];
        this.position = 0;
        this.size = 0;
        this.storedStrings = new ArrayList<String>(64);
        this.storedObjects = new ArrayList<Object>(64);
        this.storedClassDescriptors = new ArrayList<ActionScriptClassDescriptor>();
        this.documentCache = null;
        GraniteContext context = GraniteContext.getCurrentInstance();
        this.aliasRegistry = ((AliasRegistryConfig)context.getGraniteConfig()).getAliasRegistry();
        this.externalizersConfig = (ExternalizersConfig)context.getGraniteConfig();
        this.securizer = ((AMF3Config)context.getGraniteConfig()).getAmf3DeserializerSecurizer();
        this.xmlUtil = XMLUtilFactory.getXMLUtil();
    }

    public void reset() {
        this.storedStrings.clear();
        this.storedObjects.clear();
        this.storedClassDescriptors.clear();
        this.documentCache = null;
    }

    @Override
    public Object readObject() throws IOException {
        this.ensureAvailable(1);
        byte type = this.buffer[this.position++];
        return this.readObject(type);
    }

    protected Object readObject(int type) throws IOException {
        switch (type) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 3: {
                return Boolean.TRUE;
            }
            case 4: {
                return this.readAMF3Integer();
            }
            case 5: {
                return this.readAMF3Double();
            }
            case 6: {
                return this.readAMF3String();
            }
            case 7: {
                return this.readAMF3Xml();
            }
            case 8: {
                return this.readAMF3Date();
            }
            case 9: {
                return this.readAMF3Array();
            }
            case 10: {
                return this.readAMF3Object();
            }
            case 11: {
                return this.readAMF3XmlString();
            }
            case 12: {
                return this.readAMF3ByteArray();
            }
            case 13: {
                return this.readAMF3VectorInt();
            }
            case 14: {
                return this.readAMF3VectorUint();
            }
            case 15: {
                return this.readAMF3VectorNumber();
            }
            case 16: {
                return this.readAMF3VectorObject();
            }
            case 17: {
                return this.readAMF3Dictionary();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    protected int readAMF3Integer() throws IOException {
        return this.readAMF3UnsignedInteger() << 3 >> 3;
    }

    protected int readAMF3UnsignedInteger() throws IOException {
        this.ensureAvailable(1);
        byte b = this.buffer[this.position++];
        if (b >= 0) {
            return b;
        }
        this.ensureAvailable(1);
        int result = (b & 0x7F) << 7;
        b = this.buffer[this.position++];
        if (b >= 0) {
            return result | b;
        }
        this.ensureAvailable(1);
        result = (result | b & 0x7F) << 7;
        b = this.buffer[this.position++];
        if (b >= 0) {
            return result | b;
        }
        this.ensureAvailable(1);
        return (result | b & 0x7F) << 8 | this.buffer[this.position++] & 0xFF;
    }

    protected Double readAMF3Double() throws IOException {
        this.ensureAvailable(8);
        double d = Double.longBitsToDouble(AMF3Deserializer.readLongData(this.buffer, this.position));
        this.position += 8;
        return Double.isNaN(d) ? null : Double.valueOf(d);
    }

    protected String readAMF3String() throws IOException {
        String result;
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return this.storedStrings.get(lengthOrIndex);
        }
        if (lengthOrIndex == 0) {
            return "";
        }
        if (lengthOrIndex <= this.buffer.length) {
            this.ensureAvailable(lengthOrIndex);
            result = new String(this.buffer, this.position, lengthOrIndex, UTF8);
            this.position += lengthOrIndex;
        } else {
            byte[] bytes = new byte[lengthOrIndex];
            this.readFully(bytes, 0, lengthOrIndex);
            result = new String(bytes, UTF8);
        }
        this.storedStrings.add(result);
        return result;
    }

    protected Date readAMF3Date() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        if ((type & 1) == 0) {
            return (Date)this.storedObjects.get(type >>> 1);
        }
        this.ensureAvailable(8);
        Date result = new Date((long)Double.longBitsToDouble(AMF3Deserializer.readLongData(this.buffer, this.position)));
        this.position += 8;
        this.storedObjects.add(result);
        return result;
    }

    protected Object readAMF3Array() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return this.storedObjects.get(lengthOrIndex);
        }
        String key = this.readAMF3String();
        if (key.length() == 0) {
            Object[] objects = new Object[lengthOrIndex];
            this.storedObjects.add(objects);
            for (int i = 0; i < lengthOrIndex; ++i) {
                objects[i] = this.readObject();
            }
            return objects;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(lengthOrIndex);
        this.storedObjects.add(map);
        while (key.length() > 0) {
            map.put(key, this.readObject());
            key = this.readAMF3String();
        }
        for (int i = 0; i < lengthOrIndex; ++i) {
            map.put(i, this.readObject());
        }
        return map;
    }

    protected int[] readAMF3VectorInt() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return (int[])this.storedObjects.get(lengthOrIndex);
        }
        this.readByte();
        int[] vector = new int[lengthOrIndex];
        this.storedObjects.add(vector);
        for (int i = 0; i < lengthOrIndex; ++i) {
            vector[i] = this.readInt();
        }
        return vector;
    }

    protected long[] readAMF3VectorUint() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return (long[])this.storedObjects.get(lengthOrIndex);
        }
        this.readByte();
        long[] vector = new long[lengthOrIndex];
        this.storedObjects.add(vector);
        for (int i = 0; i < lengthOrIndex; ++i) {
            vector[i] = (long)this.readInt() & 0xFFFFFFFFL;
        }
        return vector;
    }

    protected double[] readAMF3VectorNumber() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return (double[])this.storedObjects.get(lengthOrIndex);
        }
        this.readByte();
        double[] vector = new double[lengthOrIndex];
        this.storedObjects.add(vector);
        for (int i = 0; i < lengthOrIndex; ++i) {
            vector[i] = this.readDouble();
        }
        return vector;
    }

    protected List<Object> readAMF3VectorObject() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return (List)this.storedObjects.get(lengthOrIndex);
        }
        this.readByte();
        this.readAMF3String();
        ArrayList<Object> vector = new ArrayList<Object>(lengthOrIndex);
        this.storedObjects.add(vector);
        for (int i = 0; i < lengthOrIndex; ++i) {
            vector.add(this.readObject());
        }
        return vector;
    }

    protected Map<Object, Object> readAMF3Dictionary() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return (Map)this.storedObjects.get(lengthOrIndex);
        }
        this.readByte();
        HashMap<Object, Object> dictionary = new HashMap<Object, Object>(lengthOrIndex);
        this.storedObjects.add(dictionary);
        for (int i = 0; i < lengthOrIndex; ++i) {
            Object key = this.readObject();
            Object value = this.readObject();
            dictionary.put(key, value);
        }
        return dictionary;
    }

    protected Document readAMF3Xml() throws IOException {
        Document doc;
        String xml = this.readAMF3XmlString();
        if (this.documentCache == null) {
            this.documentCache = new IdentityHashMap<String, Document>(32);
        }
        if ((doc = this.documentCache.get(xml)) == null) {
            doc = this.xmlUtil.buildDocument(xml);
            this.documentCache.put(xml, doc);
        }
        return doc;
    }

    protected String readAMF3XmlString() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return (String)this.storedObjects.get(lengthOrIndex);
        }
        byte[] bytes = new byte[lengthOrIndex];
        this.readFully(bytes, 0, lengthOrIndex);
        String result = new String(bytes, UTF8);
        this.storedObjects.add(result);
        return result;
    }

    protected byte[] readAMF3ByteArray() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        int lengthOrIndex = type >>> 1;
        if ((type & 1) == 0) {
            return (byte[])this.storedObjects.get(lengthOrIndex);
        }
        byte[] result = new byte[lengthOrIndex];
        this.readFully(result, 0, lengthOrIndex);
        this.storedObjects.add(result);
        return result;
    }

    protected Object readAMF3Object() throws IOException {
        int type = this.readAMF3UnsignedInteger();
        if ((type & 1) == 0) {
            return this.storedObjects.get(type >>> 1);
        }
        ActionScriptClassDescriptor desc = this.readActionScriptClassDescriptor(type);
        Object result = this.newInstance(desc);
        int index = this.storedObjects.size();
        this.storedObjects.add(result);
        if (result == null) {
            return null;
        }
        if (desc.isExternalizable()) {
            this.readExternalizable(desc, result);
        } else {
            this.readStandard(desc, result);
        }
        if (result instanceof AbstractInstantiator) {
            try {
                result = ((AbstractInstantiator)result).resolve();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate object: " + result, e);
            }
            this.storedObjects.set(index, result);
        }
        return result;
    }

    protected void readExternalizable(ActionScriptClassDescriptor desc, Object result) throws IOException {
        Externalizer externalizer = desc.getExternalizer();
        if (externalizer != null) {
            try {
                externalizer.readExternal(result, this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read externalized object: " + result, e);
            }
        }
        if (!(result instanceof Externalizable)) {
            throw new RuntimeException("The ActionScript3 class bound to " + result.getClass().getName() + " (ie: [RemoteClass(alias=\"" + result.getClass().getName() + "\")])" + " implements flash.utils.IExternalizable but this Java class neither" + " implements java.io.Externalizable nor is in the scope of a configured" + " externalizer (please fix your granite-config.xml)");
        }
        try {
            ((Externalizable)result).readExternal(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read externalizable object: " + result, e);
        }
    }

    protected void readStandard(ActionScriptClassDescriptor desc, Object result) throws IOException {
        int count = desc.getPropertiesCount();
        for (int i = 0; i < count; ++i) {
            Property property = desc.getProperty(i);
            Object value = this.readObject(this.readUnsignedByte());
            if (value != null && value.getClass() == property.getType()) {
                property.setValue(result, value, false);
                continue;
            }
            property.setValue(result, value, true);
        }
        if (desc.isDynamic()) {
            String name;
            while ((name = this.readAMF3String()).length() != 0) {
                Object value = this.readObject(this.readUnsignedByte());
                desc.setPropertyValue(name, result, value);
            }
        }
    }

    protected Object newInstance(ActionScriptClassDescriptor desc) {
        Externalizer externalizer = desc.getExternalizer();
        if (externalizer == null) {
            return desc.newJavaInstance();
        }
        try {
            return externalizer.newInstance(desc.getType(), this);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate type: " + desc.getType(), e);
        }
    }

    protected ActionScriptClassDescriptor readActionScriptClassDescriptor(int flags) throws IOException {
        if ((flags & 2) == 0) {
            return this.storedClassDescriptors.get(flags >>> 2);
        }
        return this.readInlineActionScriptClassDescriptor(flags);
    }

    protected ActionScriptClassDescriptor readInlineActionScriptClassDescriptor(int flags) throws IOException {
        int propertiesCount = flags >>> 4;
        byte encoding = (byte)(flags >>> 2 & 3);
        String alias = this.readAMF3String();
        String className = this.aliasRegistry.getTypeForAlias(alias);
        if (this.securizer != null && !this.securizer.allowInstantiation(className)) {
            throw new SecurityException("Illegal attempt to instantiate class: " + className + ", securizer: " + this.securizer.getClass());
        }
        Class<? extends ActionScriptClassDescriptor> descriptorType = null;
        if (!"".equals(className)) {
            descriptorType = this.externalizersConfig.getActionScriptDescriptor(className);
        }
        ActionScriptClassDescriptor desc = null;
        if (descriptorType != null) {
            try {
                desc = TypeUtil.newInstance(descriptorType, new Class[]{String.class, Byte.TYPE}, new Object[]{className, encoding});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate AS descriptor: " + descriptorType, e);
            }
        }
        if (desc == null) {
            desc = new DefaultActionScriptClassDescriptor(className, encoding);
        }
        for (int i = 0; i < propertiesCount; ++i) {
            String name = this.readAMF3String();
            ((ActionScriptClassDescriptor)desc).defineProperty(name);
        }
        this.storedClassDescriptors.add(desc);
        return desc;
    }

    protected void addToStoredClassDescriptors(ActionScriptClassDescriptor desc) {
        this.storedClassDescriptors.add(desc);
    }

    protected ActionScriptClassDescriptor getFromStoredClassDescriptors(int index) {
        return this.storedClassDescriptors.get(index);
    }

    private static long readLongData(byte[] buffer, int position) {
        return ((long)buffer[position++] & 0xFFL) << 56 | ((long)buffer[position++] & 0xFFL) << 48 | ((long)buffer[position++] & 0xFFL) << 40 | ((long)buffer[position++] & 0xFFL) << 32 | ((long)buffer[position++] & 0xFFL) << 24 | ((long)buffer[position++] & 0xFFL) << 16 | ((long)buffer[position++] & 0xFFL) << 8 | (long)buffer[position] & 0xFFL;
    }

    private void ensureAvailable(int count) throws IOException {
        if (this.size - this.position < count) {
            this.ensureAvailable0(count);
        }
    }

    private void ensureAvailable0(int count) throws IOException {
        if (count > this.buffer.length) {
            throw new IllegalArgumentException("Count=" + count + " cannot be larger than buffer.length=" + this.buffer.length);
        }
        if (this.position > 0) {
            this.size -= this.position;
            System.arraycopy(this.buffer, this.position, this.buffer, 0, this.size);
            this.position = 0;
        }
        do {
            int read;
            if ((read = this.in.read(this.buffer, this.size, this.buffer.length - this.size)) <= 0) {
                if (read == -1) {
                    throw new EOFException("Count not read " + count + " bytes from input stream");
                }
                throw new RuntimeException("Internal error: buffer.length=" + this.buffer.length + ", size=" + this.size + ", count=" + count);
            }
            this.size += read;
        } while (this.size < count);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int left = this.size - this.position;
        if (len <= left) {
            System.arraycopy(this.buffer, this.position, b, off, len);
            this.position += len;
        } else {
            if (left > 0) {
                System.arraycopy(this.buffer, this.position, b, off, left);
                off += left;
                len -= left;
                this.position = this.size;
            }
            while (len > 0) {
                int count = this.in.read(b, off, len);
                if (count <= 0) {
                    throw new EOFException();
                }
                off += count;
                len -= count;
            }
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.ensureAvailable(1);
        return this.buffer[this.position++] != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureAvailable(1);
        return this.buffer[this.position++];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.ensureAvailable(1);
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.ensureAvailable(2);
        return (short)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.ensureAvailable(2);
        return (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        this.ensureAvailable(2);
        return (char)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
    }

    @Override
    public int readInt() throws IOException {
        this.ensureAvailable(4);
        byte[] buffer = this.buffer;
        int position = this.position;
        int i = (buffer[position++] & 0xFF) << 24 | (buffer[position++] & 0xFF) << 16 | (buffer[position++] & 0xFF) << 8 | buffer[position++] & 0xFF;
        this.position = position;
        return i;
    }

    @Override
    public long readLong() throws IOException {
        this.ensureAvailable(8);
        byte[] buffer = this.buffer;
        int position = this.position;
        long l = ((long)buffer[position++] & 0xFFL) << 56 | ((long)buffer[position++] & 0xFFL) << 48 | ((long)buffer[position++] & 0xFFL) << 40 | ((long)buffer[position++] & 0xFFL) << 32 | ((long)buffer[position++] & 0xFFL) << 24 | ((long)buffer[position++] & 0xFFL) << 16 | ((long)buffer[position++] & 0xFFL) << 8 | (long)buffer[position++] & 0xFFL;
        this.position = position;
        return l;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return new DataInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                AMF3Deserializer.this.ensureAvailable(1);
                return AMF3Deserializer.this.buffer[AMF3Deserializer.this.position++];
            }
        }).readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int read() throws IOException {
        this.ensureAvailable(1);
        return this.buffer[this.position++];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.ensureAvailable(1);
        int count = Math.min(this.size - this.position, len);
        System.arraycopy(this.buffer, this.position, b, off, count);
        this.position += count;
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        long total;
        long count;
        if (n <= 0L) {
            return 0L;
        }
        int left = this.size - this.position;
        if (n <= (long)left) {
            this.position = (int)((long)this.position + n);
            return n;
        }
        this.position = this.size;
        for (total = (long)left; total < n; total += count) {
            count = this.in.skip(n - total);
            if (count > 0L) continue;
            return total;
        }
        return total;
    }

    @Override
    public int available() throws IOException {
        return this.size - this.position + this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.position = this.size;
        this.in.close();
    }
}

