/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.convert;

import java.lang.reflect.Type;
import org.granite.messaging.amf.io.convert.Converter;

public class IllegalConverterArgumentException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Converter converter;
    private final Object value;
    private final Type targetType;

    public IllegalConverterArgumentException(Converter converter, Object value, Type targetType) {
        this(converter, value, targetType, IllegalConverterArgumentException.buildDefaultMessage(converter, value, targetType), null);
    }

    public IllegalConverterArgumentException(Converter converter, Object value, Type targetType, String message) {
        this(converter, value, targetType, message, null);
    }

    public IllegalConverterArgumentException(Converter converter, Object value, Type targetType, Throwable cause) {
        this(converter, value, targetType, IllegalConverterArgumentException.buildDefaultMessage(converter, value, targetType), cause);
    }

    public IllegalConverterArgumentException(Converter converter, Object value, Type targetType, String message, Throwable cause) {
        super(message, cause);
        this.converter = converter;
        this.value = value;
        this.targetType = targetType;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public Object getValue() {
        return this.value;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    private static String buildDefaultMessage(Converter converter, Object value, Type targetType) {
        try {
            return "Illegal argument for converter: " + converter + " from: " + value + " to: " + targetType;
        }
        catch (Exception e) {
            return "Illegal argument for converter. Additionally, an error occured when trying to build default error message: " + e.toString();
        }
    }
}

