/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.types.AMFSpecialValueFactory;

public class FieldProperty
extends Property {
    private final Field field;
    private final AMFSpecialValueFactory.SpecialValueFactory<?> factory;

    public FieldProperty(Converters converters, Field field) {
        super(converters, field.getName());
        field.setAccessible(true);
        this.field = field;
        this.factory = specialValueFactory.getValueFactory(this);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass, boolean recursive) {
        return this.field.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass, boolean recursive) {
        return this.field.getAnnotation(annotationClass);
    }

    @Override
    public Type getType() {
        return this.field.getGenericType();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public void setValue(Object instance, Object value, boolean convert) {
        try {
            this.field.set(instance, convert ? this.convert(value) : value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getValue(Object instance) {
        try {
            Object o = this.field.get(instance);
            if (this.factory != null) {
                o = this.factory.create(o);
            }
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

