/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.impl.util.IntegerUtil;

public class ClassNameUtil {
    private static final char[] ALPHABET;
    private static final byte[] ALPHABET_INDICES;
    private static final int CLASS_NAME_END;
    private static final int INDEX_0;
    private static final int INDEX_OVERFLOW;

    private ClassNameUtil() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static void initClassNameDictionary(List<String> dictionary, String className) {
        if (!dictionary.contains(className)) {
            int lastIndexOfDot;
            ArrayList<String> lookups = new ArrayList<String>();
            String lookup = className;
            do {
                lookups.add(lookup);
                lastIndexOfDot = lookup.lastIndexOf(46);
                if (lastIndexOfDot != -1) continue;
                lookup = "";
                break;
            } while (!dictionary.contains(lookup = lookup.substring(0, lastIndexOfDot)));
            for (int i = lookups.size() - 1; i >= 0; --i) {
                dictionary.add((String)lookups.get(i));
            }
        }
    }

    public static void encodeClassName(OutputContext ctx, String className) throws IOException {
        int i;
        OutputStream os = ctx.getOutputStream();
        String lookup = className;
        int indexOfStoredClassName = ctx.indexOfClassName(lookup);
        if (indexOfStoredClassName == -1) {
            int lastIndexOfDot;
            ArrayList<String> lookups = new ArrayList<String>();
            do {
                lookups.add(lookup);
                lastIndexOfDot = lookup.lastIndexOf(46);
                if (lastIndexOfDot != -1) continue;
                lookup = "";
                break;
            } while ((indexOfStoredClassName = ctx.indexOfClassName(lookup = lookup.substring(0, lastIndexOfDot))) == -1);
            for (i = lookups.size() - 1; i >= 0; --i) {
                ctx.addToClassNames((String)lookups.get(i));
            }
        }
        if (indexOfStoredClassName != -1) {
            if (indexOfStoredClassName < INDEX_OVERFLOW) {
                os.write(indexOfStoredClassName + INDEX_0);
            } else {
                os.write(255);
                IntegerUtil.encodeVariableUnsignedInteger(ctx, indexOfStoredClassName - INDEX_OVERFLOW);
            }
        }
        if (lookup.length() != className.length()) {
            int start;
            for (i = start = lookup.length() == 0 ? 0 : lookup.length() + 1; i < className.length(); ++i) {
                byte code = ALPHABET_INDICES[className.charAt(i)];
                if (code == -1) {
                    throw new RuntimeException();
                }
                os.write(code);
            }
        }
        os.write(CLASS_NAME_END);
    }

    public static String decodeClassName(InputContext ctx) throws IOException {
        String className = "";
        int code = ctx.safeRead();
        if (code > CLASS_NAME_END) {
            if (code != 255) {
                className = ctx.getClassName(code - INDEX_0);
            } else {
                int index = IntegerUtil.decodeVariableUnsignedInteger(ctx) + INDEX_OVERFLOW;
                className = ctx.getClassName(index);
            }
            code = ctx.safeRead();
        }
        if (code != CLASS_NAME_END) {
            StringBuilder sb;
            StringBuilder stringBuilder = sb = className.length() > 0 ? new StringBuilder(className).append('.') : new StringBuilder(64);
            do {
                char c;
                if ((c = ALPHABET[code]) == '.') {
                    ctx.addToClassNames(sb.toString());
                }
                sb.append(c);
            } while ((code = ctx.safeRead()) != CLASS_NAME_END);
            className = sb.toString();
            ctx.addToClassNames(className);
        }
        return className;
    }

    static {
        int i;
        ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$.".toCharArray();
        ALPHABET_INDICES = new byte[128];
        for (i = 0; i < ALPHABET_INDICES.length; ++i) {
            ClassNameUtil.ALPHABET_INDICES[i] = -1;
        }
        for (i = 0; i < ALPHABET.length; ++i) {
            ClassNameUtil.ALPHABET_INDICES[ClassNameUtil.ALPHABET[i]] = (byte)i;
        }
        CLASS_NAME_END = ALPHABET.length;
        INDEX_0 = CLASS_NAME_END + 1;
        INDEX_OVERFLOW = 255 - INDEX_0;
    }
}

