/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl.util;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;

public class IntegerUtil {
    public static void encodeInteger(OutputContext ctx, int v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(v >>> 24);
        os.write(v >>> 16);
        os.write(v >>> 8);
        os.write(v);
    }

    public static int decodeInteger(InputContext ctx) throws IOException {
        return ctx.safeRead() << 24 | ctx.safeRead() << 16 | ctx.safeRead() << 8 | ctx.safeRead();
    }

    public static int significantIntegerBytesCount0(int v) {
        if (v < 0) {
            return 3;
        }
        if (v <= 65535) {
            return v <= 255 ? 0 : 1;
        }
        return v <= 0xFFFFFF ? 2 : 3;
    }

    public static void encodeInteger(OutputContext ctx, int v, int significantIntegerBytesCount0) throws IOException {
        OutputStream os = ctx.getOutputStream();
        switch (significantIntegerBytesCount0) {
            case 3: {
                os.write(v >>> 24);
            }
            case 2: {
                os.write(v >>> 16);
            }
            case 1: {
                os.write(v >>> 8);
            }
            case 0: {
                os.write(v);
            }
        }
    }

    public static int decodeInteger(InputContext ctx, int significantIntegerBytesCount0) throws IOException {
        int v = 0;
        switch (significantIntegerBytesCount0) {
            case 3: {
                v |= ctx.safeRead() << 24;
            }
            case 2: {
                v |= ctx.safeRead() << 16;
            }
            case 1: {
                v |= ctx.safeRead() << 8;
            }
            case 0: {
                v |= ctx.safeRead();
            }
        }
        return v;
    }

    public static void encodeVariableInteger(OutputContext ctx, int v) throws IOException {
        IntegerUtil.encodeVariableUnsignedInteger(ctx, v << 1 ^ v >> 31);
    }

    public static int decodeVariableInteger(InputContext ctx) throws IOException {
        int v = IntegerUtil.decodeVariableUnsignedInteger(ctx);
        return (v & 1) == 0 ? v >>> 1 : 0xFFFFFFFF ^ v >>> 1;
    }

    public static void encodeVariableUnsignedInteger(OutputContext ctx, int v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        if (v >= 0 && v < 270549120) {
            if (v < 16512) {
                if (v < 128) {
                    os.write(v);
                } else {
                    os.write(0x80 | (v -= 128));
                    os.write(v >>> 7);
                }
            } else if (v < 2113664) {
                os.write(0x80 | (v -= 16512));
                os.write(0x80 | v >>> 7);
                os.write(v >>> 14);
            } else {
                os.write(0x80 | (v -= 2113664));
                os.write(0x80 | v >>> 7);
                os.write(0x80 | v >>> 14);
                os.write(v >>> 21);
            }
        } else {
            os.write(0x80 | v);
            os.write(0x80 | v >>> 7);
            os.write(0x80 | v >>> 14);
            os.write(0x80 | v >>> 21);
            os.write(v >>> 28);
        }
    }

    public static int decodeVariableUnsignedInteger(InputContext ctx) throws IOException {
        int v = ctx.safeRead();
        if ((v & 0x80) != 0) {
            v = ((v = v & 0x7F | ctx.safeRead() << 7) & 0x4000) != 0 ? (((v = v & 0x3FFF | ctx.safeRead() << 14) & 0x200000) != 0 ? (((v = v & 0x1FFFFF | ctx.safeRead() << 21) & 0x10000000) != 0 ? v & 0xFFFFFFF | ctx.safeRead() << 28 : (v += 2113664)) : (v += 16512)) : (v += 128);
        }
        return v;
    }
}

