/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.persistence;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.granite.messaging.jmf.ExtendedObjectInput;
import org.granite.messaging.persistence.PersistentCollectionSnapshot;

public class JMFPersistentCollectionSnapshot
implements PersistentCollectionSnapshot {
    private static final long serialVersionUID = 1L;
    protected boolean initialized = false;
    protected boolean dirty = false;
    protected Object[] elements = null;
    protected boolean sorted = false;
    protected String comparatorClassName = null;

    public JMFPersistentCollectionSnapshot(String detachedState) {
    }

    public JMFPersistentCollectionSnapshot(boolean sorted, String detachedState) {
        this.sorted = sorted;
    }

    public JMFPersistentCollectionSnapshot(boolean initialized, String detachedState, boolean dirty, Collection<?> collection) {
        this.initialized = initialized;
        if (initialized) {
            this.dirty = dirty;
            this.elements = collection.toArray();
            if (collection instanceof SortedSet) {
                this.sorted = true;
                Comparator comparator = ((SortedSet)collection).comparator();
                if (comparator != null) {
                    this.comparatorClassName = comparator.getClass().getName();
                }
            }
        }
    }

    public JMFPersistentCollectionSnapshot(boolean initialized, String detachedState, boolean dirty, Map<?, ?> collection) {
        this.initialized = initialized;
        if (initialized) {
            this.dirty = dirty;
            Object[] entries = collection.entrySet().toArray();
            this.elements = new Object[entries.length * 2];
            int elementIndex = 0;
            for (int entryIndex = 0; entryIndex < entries.length; ++entryIndex) {
                Map.Entry entry = (Map.Entry)entries[entryIndex];
                this.elements[elementIndex++] = entry.getKey();
                this.elements[elementIndex++] = entry.getValue();
            }
            if (collection instanceof SortedMap) {
                this.sorted = true;
                Comparator comparator = ((SortedMap)collection).comparator();
                if (comparator != null) {
                    this.comparatorClassName = comparator.getClass().getName();
                }
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getDetachedState() {
        return null;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    @Override
    public <T> Comparator<T> newComparator(ObjectInput in) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        if (this.comparatorClassName == null) {
            return null;
        }
        return (Comparator)((ExtendedObjectInput)in).getReflection().newInstance(this.comparatorClassName);
    }

    @Override
    public <T> Collection<T> getElementsAsCollection() {
        return Arrays.asList(this.elements);
    }

    @Override
    public <K, V> Map<K, V> getElementsAsMap() {
        return new SnapshotMap(this.elements);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.initialized);
        if (this.initialized) {
            if (this.sorted) {
                out.writeUTF(this.comparatorClassName);
            }
            out.writeBoolean(this.dirty);
            out.writeObject(this.elements);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInitializationData(in);
        if (this.initialized) {
            this.readCoreData(in);
        }
    }

    @Override
    public void readInitializationData(ObjectInput in) throws IOException {
        this.initialized = in.readBoolean();
        if (this.initialized && this.sorted) {
            this.comparatorClassName = in.readUTF();
        }
    }

    @Override
    public void readCoreData(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dirty = in.readBoolean();
        this.elements = (Object[])in.readObject();
    }

    static class SnapshotMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public SnapshotMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }
    }

    static class SnapshotMap<K, V>
    implements Map<K, V> {
        private final Object[] elements;

        public SnapshotMap(Object[] elements) {
            if (elements.length % 2 != 0) {
                throw new IllegalArgumentException("Elements must have an even length: " + elements.length);
            }
            this.elements = elements;
        }

        @Override
        public int size() {
            return this.elements.length / 2;
        }

        @Override
        public boolean isEmpty() {
            return this.elements.length == 0;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new Set<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return SnapshotMap.this.elements.length / 2;
                }

                @Override
                public boolean isEmpty() {
                    return SnapshotMap.this.elements.length == 0;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private int cursor = 0;

                        @Override
                        public boolean hasNext() {
                            return this.cursor < SnapshotMap.this.elements.length;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.cursor >= SnapshotMap.this.elements.length) {
                                throw new NoSuchElementException();
                            }
                            Object key = SnapshotMap.this.elements[this.cursor++];
                            Object value = SnapshotMap.this.elements[this.cursor++];
                            return new SnapshotMapEntry<Object, Object>(key, value);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean add(Map.Entry<K, V> e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int hashCode() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean equals(Object obj) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<V> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }
    }
}

