/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

public abstract class AbstractIndexedCache<T> {
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final int DEFAULT_INITIAL_CAPACITY = 64;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected int initialCapacity;
    protected Entry[] entries;
    protected int threshold;
    protected int size;

    protected final void init(int capacity) {
        this.initialCapacity = capacity;
        this.entries = new Entry[capacity];
        this.threshold = (int)Math.min((float)capacity * 0.75f, 1.0737418E9f);
        this.size = 0;
    }

    public abstract int putIfAbsent(T var1);

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.init(this.initialCapacity);
    }

    protected final int resize(int newCapacity) {
        Entry[] oldEntries = this.entries;
        if (oldEntries.length == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return 0x3FFFFFFF;
        }
        int indexMask = newCapacity - 1;
        Entry[] newEntries = new Entry[newCapacity];
        for (Entry entry : oldEntries) {
            while (entry != null) {
                int i = entry.hash & indexMask;
                Entry next = entry.next;
                entry.next = newEntries[i];
                newEntries[i] = entry;
                entry = next;
            }
        }
        this.entries = newEntries;
        this.threshold = (int)Math.min((float)newCapacity * 0.75f, 1.0737418E9f);
        return indexMask;
    }

    protected static int roundUpToPowerOf2(int number) {
        if (number >= 0x40000000) {
            return 0x40000000;
        }
        int rounded = Integer.highestOneBit(number);
        if (rounded == 0) {
            return 1;
        }
        if (Integer.bitCount(number) > 1) {
            return rounded << 1;
        }
        return rounded;
    }

    protected static final class Entry {
        public final Object key;
        public final int hash;
        public final int index;
        public Entry next;

        public Entry(Object key, int hash, int index, Entry next) {
            this.key = key;
            this.hash = hash;
            this.index = index;
            this.next = next;
        }
    }
}

