/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.Message;
import org.granite.gravity.Gravity;
import org.granite.gravity.Subscriber;
import org.granite.gravity.util.ArrayUtil;

public abstract class AbstractChannel {
    private final String clientId;
    protected final Gravity gravity;
    protected boolean connected = false;
    private Subscriber[] subscriptions = new Subscriber[0];

    protected AbstractChannel(Gravity gravity) {
        this.gravity = gravity;
        this.clientId = gravity.registerChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.connected = true;
            return this.connected;
        }
    }

    public abstract void deliver(AbstractChannel var1, Message var2, String var3);

    public String getClientId() {
        return this.clientId;
    }

    public String toString() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(Subscriber subscription) {
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.subscriptions = (Subscriber[])ArrayUtil.addToArray(this.subscriptions, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(Subscriber subscription) {
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.subscriptions = (Subscriber[])ArrayUtil.removeFromArray(this.subscriptions, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribeAll() {
        Subscriber[] subscriptions;
        AbstractChannel abstractChannel = this;
        synchronized (abstractChannel) {
            this.clearQueue();
            subscriptions = this.subscriptions;
            this.subscriptions = new Subscriber[0];
        }
        Subscriber[] subscriberArray = subscriptions;
        int n = subscriptions.length;
        int n2 = 0;
        while (n2 < n) {
            Subscriber subscriber = subscriberArray[n2];
            subscriber.getTopic().unsubscribe(subscriber.getClient(), subscriber.getSubscriptionId());
            ++n2;
        }
    }

    protected abstract void clearQueue();

    public boolean equals(Object obj) {
        return obj instanceof AbstractChannel && ((AbstractChannel)obj).clientId.equals(this.clientId);
    }

    public int hashCode() {
        return this.clientId.hashCode();
    }
}

