/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.messaging.service.ServiceException;
import org.granite.util.XMap;

public class JMSServiceAdapter
extends ServiceAdapter {
    private static final Logger log = Logger.getLogger(JMSServiceAdapter.class);
    protected ConnectionFactory jmsConnectionFactory = null;
    protected Destination jmsDestination = null;
    protected Map<String, JMSClient> jmsClients = new HashMap<String, JMSClient>();
    protected String destinationName = null;
    protected boolean textMessages = false;
    protected boolean transactedSessions = false;
    protected int acknowledgeMode = 1;
    protected int messagePriority = 4;
    protected int deliveryMode = 2;

    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        super.configure(adapterProperties, destinationProperties);
        try {
            this.destinationName = destinationProperties.get("jms/destination-name");
            if ("true".equals(destinationProperties.get("jms/transacted-sessions"))) {
                this.transactedSessions = true;
            }
            if ("AUTO_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 1;
            } else if ("CLIENT_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 2;
            } else if ("DUPS_OK_ACKNOWLEDGE".equals(destinationProperties.get("jms/acknowledge-mode"))) {
                this.acknowledgeMode = 3;
            }
            if ("javax.jms.TextMessage".equals(destinationProperties.get("jms/message-type"))) {
                this.textMessages = true;
            }
            Properties environment = new Properties();
            for (XMap property : destinationProperties.getAll("jms/initial-context-environment/property")) {
                String name = property.get("name");
                String value = property.get("value");
                if ("Context.PROVIDER_URL".equals(name)) {
                    environment.put("java.naming.provider.url", value);
                    continue;
                }
                if ("Context.INITIAL_CONTEXT_FACTORY".equals(name)) {
                    environment.put("java.naming.factory.initial", value);
                    continue;
                }
                if ("Context.URL_PKG_PREFIXES".equals(name)) {
                    environment.put("java.naming.factory.url.pkgs", value);
                    continue;
                }
                if ("Context.SECURITY_PRINCIPAL".equals(name)) {
                    environment.put("java.naming.security.principal", value);
                    continue;
                }
                if ("Context.SECURITY_CREDENTIALS".equals(name)) {
                    environment.put("java.naming.security.credentials", value);
                    continue;
                }
                log.warn("Unknown InitialContext property: %s (ignored)", new Object[]{name});
            }
            InitialContext ic = new InitialContext(environment.size() > 0 ? environment : null);
            String cfJndiName = destinationProperties.get("jms/connection-factory");
            this.jmsConnectionFactory = (ConnectionFactory)ic.lookup(cfJndiName);
            String dsJndiName = destinationProperties.get("jms/destination-jndi-name");
            this.jmsDestination = (Destination)ic.lookup(dsJndiName);
        }
        catch (Exception e) {
            throw new ServiceException("Error when configuring JMS Adapter", (Throwable)e);
        }
    }

    protected Destination getProducerDestination(String topic) {
        return this.jmsDestination;
    }

    protected Destination getConsumerDestination(String topic) {
        return this.jmsDestination;
    }

    public void start() throws ServiceException {
        super.start();
    }

    public void stop() throws ServiceException {
        super.stop();
        for (JMSClient jmsClient : this.jmsClients.values()) {
            jmsClient.close();
        }
    }

    private synchronized JMSClient createJMSClient(AbstractChannel client) throws Exception {
        JMSClient jmsClient = this.jmsClients.get(client.getClientId());
        if (jmsClient == null) {
            jmsClient = new JMSClient(client);
            jmsClient.connect();
            this.jmsClients.put(client.getClientId(), jmsClient);
        }
        return jmsClient;
    }

    public Object invoke(AbstractChannel fromClient, Message message) {
        try {
            JMSClient jmsClient = this.createJMSClient(fromClient);
            jmsClient.send(message);
            AcknowledgeMessage reply = new AcknowledgeMessage(message);
            reply.setMessageId(message.getMessageId());
            return reply;
        }
        catch (Exception e) {
            ErrorMessage error = new ErrorMessage(message, null);
            error.setFaultString("JMS Adapter error " + e.getMessage());
            return error;
        }
    }

    public Object manage(AbstractChannel fromClient, CommandMessage message) {
        if (message.getOperation() == 0) {
            try {
                JMSClient jmsClient = this.createJMSClient(fromClient);
                jmsClient.subscribe((Message)message);
                AcknowledgeMessage reply = new AcknowledgeMessage((Message)message);
                return reply;
            }
            catch (Exception e) {
                throw new RuntimeException("JMSAdapter invoke error on topic  message " + message, e);
            }
        }
        if (message.getOperation() == 1) {
            try {
                JMSClient jmsClient = this.createJMSClient(fromClient);
                jmsClient.unsubscribe((Message)message);
                AcknowledgeMessage reply = new AcknowledgeMessage((Message)message);
                return reply;
            }
            catch (Exception e) {
                throw new RuntimeException("JMSAdapter invoke error on topic  message " + message, e);
            }
        }
        return null;
    }

    private class JMSClient {
        private AbstractChannel client = null;
        private String topic = null;
        private Connection jmsConnection = null;
        private Session jmsProducerSession = null;
        private MessageProducer jmsProducer = null;
        private Map<String, JMSConsumer> consumers = new HashMap<String, JMSConsumer>();

        public JMSClient(AbstractChannel client) {
            this.client = client;
        }

        public void connect() throws ServiceException {
            try {
                this.jmsConnection = JMSServiceAdapter.this.jmsConnectionFactory.createConnection();
                this.jmsConnection.start();
            }
            catch (JMSException e) {
                throw new ServiceException("JMS Initialize error", (Throwable)e);
            }
        }

        public void close() throws ServiceException {
            try {
                if (this.jmsProducer != null) {
                    this.jmsProducer.close();
                }
                if (this.jmsProducerSession != null) {
                    this.jmsProducerSession.close();
                }
                for (JMSConsumer consumer : this.consumers.values()) {
                    consumer.close();
                }
                this.jmsConnection.stop();
                this.jmsConnection.close();
            }
            catch (JMSException e) {
                throw new ServiceException("JMS Stop error", (Throwable)e);
            }
        }

        public void send(Message message) throws Exception {
            if (this.jmsProducerSession == null) {
                this.jmsProducerSession = this.jmsConnection.createSession(JMSServiceAdapter.this.transactedSessions, JMSServiceAdapter.this.acknowledgeMode);
            }
            if (this.jmsProducer == null) {
                this.jmsProducer = this.jmsProducerSession.createProducer(JMSServiceAdapter.this.getProducerDestination(this.topic));
                this.jmsProducer.setPriority(JMSServiceAdapter.this.messagePriority);
                this.jmsProducer.setDeliveryMode(JMSServiceAdapter.this.deliveryMode);
            }
            TextMessage jmsMessage = null;
            if (JMSServiceAdapter.this.textMessages) {
                jmsMessage = this.jmsProducerSession.createTextMessage(message.getBody().toString());
            } else {
                byte[] byteArray = (byte[])message.getBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
                AMF3Deserializer deser = new AMF3Deserializer((InputStream)bais);
                Object msg = deser.readObject();
                jmsMessage = this.jmsProducerSession.createObjectMessage((Serializable)msg);
            }
            jmsMessage.setJMSMessageID(message.getMessageId());
            jmsMessage.setJMSCorrelationID(((AsyncMessage)message).getCorrelationId());
            jmsMessage.setJMSTimestamp(message.getTimestamp());
            jmsMessage.setJMSExpiration(message.getTimeToLive());
            for (Map.Entry me : message.getHeaders().entrySet()) {
                if ("JMSType".equals(me.getKey())) {
                    if (!(me.getValue() instanceof String)) continue;
                    jmsMessage.setJMSType((String)me.getValue());
                    continue;
                }
                if ("JMSPriority".equals(me.getKey())) {
                    if (!(me.getValue() instanceof Integer)) continue;
                    jmsMessage.setJMSPriority(((Integer)me.getValue()).intValue());
                    continue;
                }
                if (me.getValue() instanceof String) {
                    jmsMessage.setStringProperty((String)me.getKey(), (String)me.getValue());
                    continue;
                }
                if (me.getValue() instanceof Boolean) {
                    jmsMessage.setBooleanProperty((String)me.getKey(), ((Boolean)me.getValue()).booleanValue());
                    continue;
                }
                if (me.getValue() instanceof Integer) {
                    jmsMessage.setIntProperty((String)me.getKey(), ((Integer)me.getValue()).intValue());
                    continue;
                }
                if (me.getValue() instanceof Long) {
                    jmsMessage.setLongProperty((String)me.getKey(), ((Long)me.getValue()).longValue());
                    continue;
                }
                if (me.getValue() instanceof Double) {
                    jmsMessage.setDoubleProperty((String)me.getKey(), ((Double)me.getValue()).doubleValue());
                    continue;
                }
                jmsMessage.setObjectProperty((String)me.getKey(), me.getValue());
            }
            this.jmsProducer.send((javax.jms.Message)jmsMessage);
            if (JMSServiceAdapter.this.transactedSessions) {
                this.jmsProducerSession.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribe(Message message) throws Exception {
            String subscriptionId = (String)message.getHeader("DSDstClientId");
            String selector = (String)message.getHeader("DSSelector");
            this.topic = (String)message.getHeader("DSSubtopic");
            Map<String, JMSConsumer> map = this.consumers;
            synchronized (map) {
                JMSConsumer consumer = this.consumers.get(subscriptionId);
                if (consumer == null) {
                    consumer = new JMSConsumer(subscriptionId, selector, false);
                    this.consumers.put(subscriptionId, consumer);
                } else {
                    consumer.setSelector(selector);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsubscribe(Message message) throws Exception {
            String subscriptionId = (String)message.getHeader("DSDstClientId");
            Map<String, JMSConsumer> map = this.consumers;
            synchronized (map) {
                JMSConsumer consumer = this.consumers.get(subscriptionId);
                if (consumer != null) {
                    consumer.close();
                }
                this.consumers.remove(subscriptionId);
            }
        }

        private class JMSConsumer
        implements MessageListener {
            private String subscriptionId = null;
            private Session jmsConsumerSession = null;
            private MessageConsumer jmsConsumer = null;

            public JMSConsumer(String subscriptionId, String selector, boolean noLocal) throws JMSException {
                this.subscriptionId = subscriptionId;
                this.jmsConsumerSession = JMSClient.this.jmsConnection.createSession(((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions, ((JMSClient)JMSClient.this).JMSServiceAdapter.this.acknowledgeMode);
                this.jmsConsumer = this.jmsConsumerSession.createConsumer(JMSServiceAdapter.this.getConsumerDestination(JMSClient.this.topic), selector, noLocal);
                this.jmsConsumer.setMessageListener((MessageListener)this);
            }

            public void setSelector(String selector) throws JMSException {
                if (this.jmsConsumer != null) {
                    this.jmsConsumer.close();
                }
                this.jmsConsumer = this.jmsConsumerSession.createConsumer(JMSServiceAdapter.this.getConsumerDestination(JMSClient.this.topic), selector);
                this.jmsConsumer.setMessageListener((MessageListener)this);
            }

            public void close() throws JMSException {
                if (this.jmsConsumer != null) {
                    this.jmsConsumer.close();
                }
                if (this.jmsConsumerSession != null) {
                    this.jmsConsumerSession.close();
                }
            }

            public void onMessage(javax.jms.Message message) {
                if (!(message instanceof ObjectMessage) && !(message instanceof TextMessage)) {
                    log.error("JMS Adapter message type not allowed: %s", new Object[]{message.getClass().getName()});
                    try {
                        if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.acknowledgeMode == 2) {
                            message.acknowledge();
                        }
                        if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                            this.jmsConsumerSession.commit();
                        }
                    }
                    catch (JMSException e) {
                        log.error((Throwable)e, "Could not ack/commit JMS onMessage", new Object[0]);
                    }
                }
                log.debug("Delivering JMS message", new Object[0]);
                AsyncMessage dmsg = new AsyncMessage();
                try {
                    TextMessage jmsMessage;
                    Object msg = null;
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.textMessages) {
                        jmsMessage = (TextMessage)message;
                        msg = jmsMessage.getText();
                    } else {
                        jmsMessage = (ObjectMessage)message;
                        msg = jmsMessage.getObject();
                    }
                    JMSServiceAdapter.this.getGravity().initThread();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
                    AMF3Serializer ser = new AMF3Serializer((OutputStream)baos, false);
                    ser.writeObject(msg);
                    ser.close();
                    baos.close();
                    dmsg.setDestination(JMSServiceAdapter.this.getDestination().getId());
                    dmsg.setBody((Object)baos.toByteArray());
                    dmsg.setMessageId(message.getJMSMessageID());
                    dmsg.setCorrelationId(message.getJMSCorrelationID());
                    dmsg.setTimestamp(message.getJMSTimestamp());
                    dmsg.setTimeToLive(message.getJMSExpiration());
                    dmsg.setHeader("JMSType", (Object)message.getJMSType());
                    dmsg.setHeader("JMSPriority", (Object)message.getJMSPriority());
                    dmsg.setHeader("JMSRedelivered", (Object)message.getJMSRedelivered());
                    dmsg.setHeader("JMSDeliveryMode", (Object)message.getJMSDeliveryMode());
                    Enumeration ename = message.getPropertyNames();
                    while (ename.hasMoreElements()) {
                        String pname = (String)ename.nextElement();
                        dmsg.setHeader(pname, message.getObjectProperty(pname));
                    }
                }
                catch (IOException e) {
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", new Object[]{dmsg.getMessageId()});
                        }
                    }
                    throw new RuntimeException("IO Error", e);
                }
                catch (JMSException e) {
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", new Object[]{dmsg.getMessageId()});
                        }
                    }
                    throw new RuntimeException("JMS Error", e);
                }
                JMSClient.this.client.deliver(null, (Message)dmsg, this.subscriptionId);
                try {
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.acknowledgeMode == 2) {
                        message.acknowledge();
                    }
                    if (((JMSClient)JMSClient.this).JMSServiceAdapter.this.transactedSessions) {
                        this.jmsConsumerSession.commit();
                    }
                }
                catch (JMSException e) {
                    log.error("Could not ack/commit JMS onMessage, messageId: %s", new Object[]{dmsg.getMessageId()});
                }
            }
        }
    }
}

