/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.gravity.adapters.Topic;
import org.granite.gravity.adapters.TopicId;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.util.XMap;

public class SimpleServiceAdapter
extends ServiceAdapter {
    private static final Logger log = Logger.getLogger(SimpleServiceAdapter.class);
    private final Topic rootTopic = new Topic("/", this);
    private transient ConcurrentHashMap<String, TopicId> _topicIdCache;

    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        this._topicIdCache = new ConcurrentHashMap();
    }

    public Topic getTopic(TopicId id) {
        return this.rootTopic.getChild(id);
    }

    public Topic getTopic(String id) {
        TopicId cid = this.getTopicId(id);
        if (cid.depth() == 0) {
            return null;
        }
        return this.rootTopic.getChild(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic getTopic(String id, boolean create) {
        SimpleServiceAdapter simpleServiceAdapter = this;
        synchronized (simpleServiceAdapter) {
            Topic topic = this.getTopic(id);
            if (topic == null && create) {
                topic = new Topic(id, this);
                this.rootTopic.addChild(topic);
                log.debug("New Topic: %s", new Object[]{topic});
            }
            return topic;
        }
    }

    public TopicId getTopicId(String id) {
        TopicId tid = this._topicIdCache.get(id);
        if (tid == null) {
            tid = new TopicId(id);
            this._topicIdCache.put(id, tid);
        }
        return tid;
    }

    public boolean hasTopic(String id) {
        TopicId cid = this.getTopicId(id);
        return this.rootTopic.getChild(cid) != null;
    }

    public boolean removeChannel(TopicId channelId) {
        return false;
    }

    public void publish(TopicId to, AbstractChannel fromClient, Message message) {
        if (message.getMessageId() == null) {
            long id = message.hashCode() ^ (to == null ? 0 : to.hashCode()) ^ (fromClient == null ? 0 : fromClient.hashCode());
            id = id < 0L ? -id : id;
            message.setMessageId(Long.toString(id, 36));
        }
        this.rootTopic.publish(to, fromClient, message);
    }

    public void publish(AbstractChannel fromClient, String toTopicId, Message message) {
        this.publish(this.getTopicId(toTopicId), fromClient, message);
    }

    public void subscribe(String toTopicId, AbstractChannel client, String subscriptionId, String selector) {
        Topic topic = this.getTopic(toTopicId, true);
        if (topic != null) {
            topic.subscribe(client, subscriptionId, selector);
        }
    }

    public void unsubscribe(String toTopicId, AbstractChannel client, String subscriptionId) {
        Topic topic = this.getTopic(toTopicId);
        if (topic != null) {
            topic.unsubscribe(client, subscriptionId);
        }
    }

    public String[] getSubscriberIds(String destination, String topicId) {
        String subscriptionTopicId = topicId != null ? "/" + topicId.replace('.', '/') : "/";
        Topic topic = this.getTopic(subscriptionTopicId);
        if (topic == null) {
            throw new RuntimeException("Topic " + topicId + " not found in destination " + destination);
        }
        return topic.getSubscriberIds();
    }

    public Object invoke(AbstractChannel fromClient, Message message) {
        String topicId = (String)message.getHeader("DSSubtopic");
        topicId = topicId != null ? "/" + topicId.replace('.', '/') : "/";
        ErrorMessage reply = null;
        if (message.getBody() != null && this.getSecurityPolicy().canPublish(fromClient, topicId, message)) {
            TopicId tid = this.getTopicId(topicId);
            this.publish(tid, fromClient, message);
            reply = new AcknowledgeMessage(message);
            reply.setMessageId(message.getMessageId());
        } else {
            reply = new ErrorMessage(message, null);
            reply.setFaultString("unknown channel");
        }
        return reply;
    }

    public Object manage(AbstractChannel fromClient, CommandMessage message) {
        if (message.getOperation() == 0) {
            String subscribeTopicId = (String)message.getHeader("DSSubtopic");
            subscribeTopicId = subscribeTopicId != null ? "/" + subscribeTopicId.replace('.', '/') : "/";
            ErrorMessage reply = null;
            if (this.getSecurityPolicy().canSubscribe(fromClient, subscribeTopicId, (Message)message)) {
                Topic topic = this.getTopic(subscribeTopicId);
                if (topic == null && this.getSecurityPolicy().canCreate(fromClient, subscribeTopicId, (Message)message)) {
                    topic = this.getTopic(subscribeTopicId, true);
                }
                if (topic != null) {
                    String subscriptionId = (String)message.getHeader("DSDstClientId");
                    String selector = (String)message.getHeader("DSSelector");
                    topic.subscribe(fromClient, subscriptionId, selector);
                    reply = new AcknowledgeMessage((Message)message);
                } else {
                    reply = new ErrorMessage((Message)message, null);
                    reply.setFaultString("cannot create");
                }
            } else {
                reply = new ErrorMessage((Message)message, null);
                reply.setFaultString("cannot subscribe");
            }
            return reply;
        }
        if (message.getOperation() == 1) {
            String unsubscribeTopicId = (String)message.getHeader("DSSubtopic");
            unsubscribeTopicId = unsubscribeTopicId != null ? "/" + unsubscribeTopicId.replace('.', '/') : "/";
            Topic topic = this.getTopic(unsubscribeTopicId);
            String subscriptionId = null;
            if (topic != null) {
                subscriptionId = (String)message.getHeader("DSDstClientId");
                topic.unsubscribe(fromClient, subscriptionId);
            }
            AcknowledgeMessage reply = new AcknowledgeMessage((Message)message);
            reply.setHeader("DSDstClientId", (Object)subscriptionId);
            return reply;
        }
        ErrorMessage reply = new ErrorMessage((Message)message, null);
        reply.setFaultString("unknown operation");
        return reply;
    }
}

